/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.rate.ratebar;

import android.animation.Animator;
import android.content.Context;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.airbnb.lottie.LottieAnimationView;
import com.talpa.rate.R;

@Keep
public class PartialView
extends RelativeLayout {
    private ImageView mFilledView;
    private ImageView mEmptyView;
    private LottieAnimationView lottieAnimationView;
    private int mStarWidth = 0;
    private int mStarHeight = 0;
    private TextView mGuidanceText;

    public PartialView(Context context, int partialViewId, int starWidth, int startHeight, int padding) {
        super(context);
        this.mStarWidth = starWidth;
        this.mStarHeight = startHeight;
        this.setTag(partialViewId);
        this.setPadding(padding, padding, padding, padding);
        this.init();
    }

    public PartialView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PartialView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 1.0f));
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(this.mStarWidth == 0 ? -2 : this.mStarWidth, this.mStarHeight == 0 ? -2 : this.mStarHeight);
        params.addRule(13);
        this.mFilledView = new ImageView(this.getContext());
        this.mFilledView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.addView((View)this.mFilledView, (ViewGroup.LayoutParams)params);
        this.mEmptyView = new ImageView(this.getContext());
        this.mEmptyView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.addView((View)this.mEmptyView, (ViewGroup.LayoutParams)params);
        this.mFilledView.setVisibility(4);
        this.mEmptyView.setVisibility(4);
        this.lottieAnimationView = new LottieAnimationView(this.getContext());
        this.lottieAnimationView.setScaleType(ImageView.ScaleType.CENTER);
        this.lottieAnimationView.setSpeed(2.0f);
        this.addView((View)this.lottieAnimationView, (ViewGroup.LayoutParams)params);
        this.setEmpty();
    }

    public void setLottieAnim(String fileName) {
        this.lottieAnimationView.setAnimation(fileName);
    }

    public void playAnimation() {
        this.lottieAnimationView.playAnimation();
    }

    public void cancelAnimation() {
        this.removeView((View)this.lottieAnimationView);
        this.mFilledView.setVisibility(0);
        this.mEmptyView.setVisibility(0);
    }

    public void setAnimListener(final PartialView nextView, final EndAnimListener endAnimListener) {
        this.lottieAnimationView.addAnimatorListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (nextView != null) {
                    nextView.playAnimation();
                    if (endAnimListener != null) {
                        endAnimListener.onCurrentEnd(PartialView.this);
                    }
                } else if (endAnimListener != null) {
                    endAnimListener.onEnd();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public void setGuidanceText(String text) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13);
        this.mGuidanceText = new TextView(this.getContext());
        this.mGuidanceText.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.guidance_color));
        this.mGuidanceText.setText((CharSequence)text);
        this.addView((View)this.mGuidanceText, (ViewGroup.LayoutParams)params);
    }

    public void setFilledDrawable(@NonNull Drawable drawable2) {
        if (drawable2.getConstantState() == null) {
            return;
        }
        ClipDrawable clipDrawable = new ClipDrawable(drawable2.getConstantState().newDrawable(), 0x800003, 1);
        this.mFilledView.setImageDrawable((Drawable)clipDrawable);
    }

    public void setEmptyDrawable(@NonNull Drawable drawable2) {
        if (drawable2.getConstantState() == null) {
            return;
        }
        ClipDrawable clipDrawable = new ClipDrawable(drawable2.getConstantState().newDrawable(), 0x800005, 1);
        this.mEmptyView.setImageDrawable((Drawable)clipDrawable);
    }

    public void setFilled() {
        this.mFilledView.setImageLevel(10000);
        this.mEmptyView.setImageLevel(0);
        if (this.mGuidanceText != null) {
            this.mGuidanceText.setTextColor(-1);
        }
    }

    public void setPartialFilled(float rating) {
        float percentage = rating % 1.0f;
        int level = (int)(10000.0f * percentage);
        level = level == 0 ? 10000 : level;
        this.mFilledView.setImageLevel(level);
        this.mEmptyView.setImageLevel(10000 - level);
        if (this.mGuidanceText != null) {
            this.mGuidanceText.setTextColor(-1);
        }
    }

    public void setEmpty() {
        this.mFilledView.setImageLevel(0);
        this.mEmptyView.setImageLevel(10000);
        if (this.mGuidanceText != null) {
            this.mGuidanceText.setTextColor(-16777216);
        }
    }

    public void setStarWidth(@IntRange(from=0L) int starWidth) {
        this.mStarWidth = starWidth;
        ViewGroup.LayoutParams params = this.mFilledView.getLayoutParams();
        params.width = this.mStarWidth;
        this.mFilledView.setLayoutParams(params);
        this.mEmptyView.setLayoutParams(params);
    }

    public void setStarHeight(@IntRange(from=0L) int starHeight) {
        this.mStarHeight = starHeight;
        ViewGroup.LayoutParams params = this.mFilledView.getLayoutParams();
        params.height = this.mStarHeight;
        this.mFilledView.setLayoutParams(params);
        this.mEmptyView.setLayoutParams(params);
    }

    public static interface EndAnimListener {
        public void onEnd();

        public void onCurrentEnd(PartialView var1);
    }
}

