/*
 * Decompiled with CFR 0.152.
 */
package com.tapla.textspeech;

import android.app.Application;
import android.content.Context;
import android.media.AudioManager;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0002 !B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\"\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0007J\b\u0010\u001e\u001a\u00020\tH\u0002J\u0006\u0010\u001f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/tapla/textspeech/TextSpeech;", "Landroid/speech/tts/TextToSpeech$OnInitListener;", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "()V", "mApplication", "Landroid/app/Application;", "soundProgressListener", "Lcom/tapla/textspeech/TextSpeech$SoundProgressListener;", "textToSpeech", "Landroid/speech/tts/TextToSpeech;", "init", "", "application", "isLanguageAvailable", "", "locale", "Ljava/util/Locale;", "isSpeaking", "matchCode", "code", "", "onAudioFocusChange", "focusChange", "onInit", "status", "requestAudioFocus", "speak", "text", "", "listener", "speech", "stopSpeak", "OnUtteranceProgressListener", "SoundProgressListener", "textspeech_release"})
public final class TextSpeech
implements TextToSpeech.OnInitListener,
AudioManager.OnAudioFocusChangeListener {
    @NotNull
    public static final TextSpeech INSTANCE = new TextSpeech();
    @Nullable
    private static TextToSpeech textToSpeech;
    private static Application mApplication;
    @Nullable
    private static SoundProgressListener soundProgressListener;

    private TextSpeech() {
    }

    public void onInit(int status) {
        if (status != 0) {
            textToSpeech = null;
        }
    }

    public final void init(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        mApplication = application;
        try {
            this.speech();
            TextToSpeech textToSpeech = TextSpeech.textToSpeech;
            if (textToSpeech != null) {
                textToSpeech.setOnUtteranceProgressListener((UtteranceProgressListener)new OnUtteranceProgressListener(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final TextToSpeech speech() {
        TextToSpeech textToSpeech;
        TextToSpeech textToSpeech2 = TextSpeech.textToSpeech;
        if (textToSpeech2 == null) {
            Application application = mApplication;
            if (application == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mApplication");
                throw null;
            }
            application = new TextToSpeech((Context)application, (TextToSpeech.OnInitListener)this);
            boolean bl = false;
            boolean bl2 = false;
            Application $this$speech_u24lambda_u2d0 = application;
            boolean bl3 = false;
            TextSpeech.textToSpeech = $this$speech_u24lambda_u2d0;
            $this$speech_u24lambda_u2d0.setSpeechRate(0.8f);
            textToSpeech = application;
        } else {
            textToSpeech = textToSpeech2;
        }
        return textToSpeech;
    }

    public final boolean speak(@NotNull CharSequence text, @NotNull Locale locale, @Nullable SoundProgressListener listener) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        TextToSpeech textToSpeech = null;
        soundProgressListener = listener;
        try {
            textToSpeech = this.speech();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        int code = textToSpeech.setLanguage(locale);
        if (this.matchCode(code)) {
            boolean isSuccess;
            int status = textToSpeech.speak(text, 0, null, String.valueOf(System.currentTimeMillis()));
            boolean bl2 = isSuccess = status == 0;
            if (isSuccess) {
                Application application = mApplication;
                if (application == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mApplication");
                    throw null;
                }
                this.requestAudioFocus(application);
            }
            bl = isSuccess;
        } else {
            TextSpeech.textToSpeech = null;
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean speak$default(TextSpeech textSpeech, CharSequence charSequence, Locale locale, SoundProgressListener soundProgressListener, int n, Object object) {
        if ((n & 4) != 0) {
            soundProgressListener = null;
        }
        return textSpeech.speak(charSequence, locale, soundProgressListener);
    }

    public final void stopSpeak() {
        soundProgressListener = null;
        TextToSpeech textToSpeech = this.speech();
        if (textToSpeech.isSpeaking()) {
            this.speech().stop();
        }
    }

    public final boolean isSpeaking() {
        return this.speech().isSpeaking();
    }

    public final boolean isLanguageAvailable(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        TextToSpeech textToSpeech = this.speech();
        int code = textToSpeech.isLanguageAvailable(locale);
        return this.matchCode(code);
    }

    private final boolean matchCode(int code) {
        return code == 0 || code == 2 || code == 1;
    }

    private final void requestAudioFocus(Application application) {
        Object object = application.getSystemService("audio");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
        }
        AudioManager audioManager = (AudioManager)object;
        audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2);
    }

    public void onAudioFocusChange(int focusChange) {
        if (focusChange == -1) {
            this.stopSpeak();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/tapla/textspeech/TextSpeech$SoundProgressListener;", "", "onDone", "", "onError", "onStart", "onStop", "textspeech_release"})
    public static interface SoundProgressListener {
        public void onDone();

        public void onError();

        public void onStart();

        public void onStop();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/tapla/textspeech/TextSpeech$OnUtteranceProgressListener;", "Landroid/speech/tts/UtteranceProgressListener;", "textSpeech", "Lcom/tapla/textspeech/TextSpeech;", "(Lcom/tapla/textspeech/TextSpeech;)V", "getTextSpeech", "()Lcom/tapla/textspeech/TextSpeech;", "onDone", "", "utteranceId", "", "onError", "onStart", "onStop", "interrupted", "", "textspeech_release"})
    private static final class OnUtteranceProgressListener
    extends UtteranceProgressListener {
        @NotNull
        private final TextSpeech textSpeech;

        public OnUtteranceProgressListener(@NotNull TextSpeech textSpeech) {
            Intrinsics.checkNotNullParameter((Object)textSpeech, (String)"textSpeech");
            this.textSpeech = textSpeech;
        }

        @NotNull
        public final TextSpeech getTextSpeech() {
            return this.textSpeech;
        }

        public void onDone(@Nullable String utteranceId) {
            Application application = mApplication;
            if (application == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mApplication");
                throw null;
            }
            Object object = application.getSystemService("audio");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
            }
            AudioManager audioManager = (AudioManager)object;
            audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this.textSpeech);
            object = soundProgressListener;
            if (object != null) {
                object.onDone();
            }
        }

        public void onError(@Nullable String utteranceId) {
            SoundProgressListener soundProgressListener = soundProgressListener;
            if (soundProgressListener != null) {
                soundProgressListener.onError();
            }
        }

        public void onStop(@Nullable String utteranceId, boolean interrupted) {
            super.onStop(utteranceId, interrupted);
            SoundProgressListener soundProgressListener = soundProgressListener;
            if (soundProgressListener != null) {
                soundProgressListener.onStop();
            }
        }

        public void onStart(@Nullable String utteranceId) {
            SoundProgressListener soundProgressListener = soundProgressListener;
            if (soundProgressListener != null) {
                soundProgressListener.onStart();
            }
        }
    }
}

