package com.talpa.datareport

import android.app.Application
import androidx.work.*
import com.talpa.datareport.DataReportTask.Companion.FAILED
import com.talpa.datareport.DataReportTask.Companion.SUCCESS
import com.talpa.tengine.Trans
import com.talpa.tengine.UNKNOWN
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.sync.Mutex
import kotlinx.coroutines.sync.withLock
import java.util.concurrent.TimeUnit

/**
 * Create by chenjunsheng on 2021/7/23
 */
class DataReportTask {

    companion object {

        const val SUCCESS = 1000
        const val FAILED = 2000
        var mutex: Mutex = Mutex()
        var mApp: Application? = null

        var UPLOAD_TASK_NAME = "upload_task_name"

        fun initialize(application: Application, appId: String) {
            mApp = application
            ReportNetwork.initialize(application, appId)
            val reporter = PeriodicWorkRequestBuilder<DataReportRequest>(1, TimeUnit.DAYS)
                .build()
            WorkManager.getInstance(application)
                .enqueueUniquePeriodicWork(UPLOAD_TASK_NAME, ExistingPeriodicWorkPolicy.KEEP, reporter)
        }
    }

}

fun Trans.reportStartTrans() {
    val trans = this
    DataReportTask.mApp?.let {
        GlobalScope.launch(Dispatchers.IO) {
            DataReportTask.mutex.withLock {
                ReportDatabase.getInstance(it)
                    .reportDao()
                    .markTrans(
                        ReportEntity(
                            from = trans.from ?: "AUTO",
                            to = trans.to,
                            strLength = trans.text.length,
                            transHash = trans.hashCode(),
                            startTime = System.currentTimeMillis()
                        )
                    )
            }

        }
    }

}

fun Trans.report2Server() {
    val trans = this
    DataReportTask.mApp?.let {
        GlobalScope.launch(Dispatchers.IO) {
            DataReportTask.mutex.withLock {

                val startedTrans = ReportDatabase.getInstance(it)
                    .reportDao()
                    .queryStartedTrans(trans.hashCode())

                if (startedTrans == null) {
                    val reportData = ReportEntity(
                        finishTime = System.currentTimeMillis(),
                        startTime = System.currentTimeMillis(),
                        from = trans.from ?: "AUTO",
                        to = trans.to,
                        strLength = trans.text.length,
                        source = trans.result?.source ?: UNKNOWN,
                        transHash = trans.hashCode(),
                        code = if (trans.result == null) {
                            FAILED
                        } else {
                            SUCCESS
                        }
                    )
                    ReportDatabase.getInstance(it).reportDao().markTrans(reportData)
                } else {
                    startedTrans.finishTime = System.currentTimeMillis()
                    startedTrans.from = trans.from ?: "AUTO"
                    startedTrans.to = trans.to
                    startedTrans.strLength = trans.text.length
                    startedTrans.source = trans.result?.source ?: UNKNOWN
                    trans.result?.let {
                        startedTrans.code = SUCCESS
                    } ?: kotlin.run {
                        startedTrans.code = FAILED
                    }
                    ReportDatabase.getInstance(it)
                        .reportDao()
                        .markTransFinish(startedTrans)
                }
            }
        }
    }
}