package com.talpa.datareport

import androidx.annotation.Keep
import androidx.room.*

/**
 * Create by chenjunsheng on 2021/7/23
 */
@Dao
@Keep
interface ReportDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun markTrans(reportEntity: ReportEntity)

    @Update(onConflict = OnConflictStrategy.REPLACE)
    fun markTransFinish(reportEntity: ReportEntity)

    @Query("SELECT * FROM report_table WHERE transHash = :hash")
    fun queryStartedTrans(hash: Int): ReportEntity?

    @Query("SELECT * FROM report_table WHERE finishTime != 0 AND startTime != 0")
    fun queryUploadTrans(): List<ReportEntity>

    @Delete
    fun deleteFinishTrans(reportEntities: List<ReportEntity>)
}