package com.talpa.datareport

import android.content.Context
import androidx.annotation.Keep
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase

/**
 * Create by chenjunsheng on 2021/7/23
 */

@Database(
    entities = [
        ReportEntity::class
    ],
    version = 1,
    exportSchema = false
)
@Keep
abstract class ReportDatabase : RoomDatabase() {

    companion object {

        private var INSTANCE: ReportDatabase? = null

        fun getInstance(context: Context): ReportDatabase {
            synchronized(ReportDatabase::class) {
                if (INSTANCE == null) {
                    INSTANCE = Room.databaseBuilder(
                        context.getApplicationContext(),
                        ReportDatabase::class.java, "report_server.db"
                    )
                        .build()
                }
                return INSTANCE!!
            }
        }

    }

    abstract fun reportDao(): ReportDao
}