package com.talpa.datareport

import androidx.annotation.Keep
import androidx.room.Entity
import androidx.room.Index
import androidx.room.PrimaryKey
import com.talpa.tengine.UNKNOWN

/**
 * Create by chenjunsheng on 2021/7/23
 */

@Entity(
    tableName = "report_table",
    indices = [Index(value = ["transHash"], unique = true)]
)
@Keep
data class ReportEntity(
    @PrimaryKey(autoGenerate = true)
    var id: Int = 0,
    var from: String = "AUTO",
    var to: String = "",
    var code: Int = 0,
    var source: String = UNKNOWN,
    var strLength: Int = 0,
    var transHash: Int = 0,
    var startTime: Long = 0L,
    var finishTime: Long = 0L
)