package com.talpa.datareport

import android.app.Application
import android.util.Log
import androidx.annotation.Keep
import com.talpa.datareport.DataReportTask.Companion.SUCCESS
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.util.*

/**
 * Create by chenjunsheng on 2021/7/23
 */
object ReportNetwork {


    var mReportApi: ReportApi? = null
    const val BASE_URL = "https://monitor.translasion.com"
    var mAppId: String? = null
    var mApplication: Application? = null

    fun initialize(application: Application, appId: String) {
        mAppId = appId
        mApplication = application
        val logInterceptor = HttpLoggingInterceptor(object : HttpLoggingInterceptor.Logger {
            override fun log(message: String) {
                Log.d("okhttp", message)
            }

        })
        logInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY)

        val okHttpClient = OkHttpClient.Builder()
            .addInterceptor {
                val requestBuilder = it.request().newBuilder()
                requestBuilder.addHeader("appId", mAppId ?: "")
                it.proceed(requestBuilder.build())
            }
            //.addNetworkInterceptor(logInterceptor)
            .build()
        mReportApi = Retrofit.Builder()
            .baseUrl(BASE_URL)
            .addConverterFactory(GsonConverterFactory.create())
            .client(okHttpClient)
            .build().create(ReportApi::class.java)
    }
}

@Keep
data class UploadBody(
    var appName: String,
    var country: String,
    var osVersion: String,
    var versionName: String,
    var reportingTime: Long = System.currentTimeMillis(),
    var data: List<ReportDetail>
)

@Keep
data class ReportDetail(
    var sourceLanguage: String,
    var targetLanguage: String,
    var strLength: Int,
    var translationTime: Long,
    var engine: String,
    var timeConsuming: Long = 1L,
    var status: Int
)

@Keep
data class ReportResponse(
    var code: Int,
    var message: String,
    var success: Boolean = code == SUCCESS
)