package com.talpa.tengine

import android.content.Context

/**
 * @author CY 2020/4/14
 */
sealed class Builder(context: Context) {
    var serverAppKey: String? = null
        protected set
    var serverAppSecret: String? = null
        protected set
    var googleKey: String? = null
        protected set
    var microsoftKey: String? = null
        protected set
    var isEnabledOfflineTranslate: Boolean = false
        protected set
    var isDownloadModelIfNeeded: Boolean = false
        protected set
    var isEnabledYandex: Boolean = false
        protected set
}

class TranslatorBuilder constructor(val context: Context) : Builder(context) {

    fun setServerAppKey(serverAppKey: String?) = apply {
        this.serverAppKey = serverAppKey
    }

    fun setServerAppSecret(serverAppSecret: String?) = apply {
        this.serverAppSecret = serverAppSecret
    }

    fun setGoogleKey(googleKey: String?) = apply {
        this.googleKey = googleKey
    }

    fun setMicrosoftKey(microsoftKey: String?) = apply {
        this.microsoftKey = microsoftKey
    }

    fun isEnabledOfflineTranslate(isEnabledOfflineTranslate: Boolean) = apply {
        this.isEnabledOfflineTranslate = isEnabledOfflineTranslate
    }

    fun isDownloadModelIfNeeded(isDownloadModelIfNeeded: Boolean) = apply {
        this.isDownloadModelIfNeeded = isDownloadModelIfNeeded
    }

    fun isEnabledYandex(isEnabledYandex: Boolean) = apply {
        this.isEnabledYandex = isEnabledYandex
    }


    /*fun build() = Translator(
        context,
        googleKey,
        microsoftKey,
        serverAppKey = serverAppKey,
        serverAppSecret = serverAppSecret
    )*/
}