package com.talpa.tengine.charge

import com.google.gson.Gson
import com.google.gson.JsonObject
import com.talpa.tengine.lang.LANG
import io.reactivex.Flowable
import okhttp3.ResponseBody
import java.util.*

/**
 * @author CY 19-3-6
 */
class GoogleCloudTranslate(private val key: String) : TranslateFactory() {

    override val isSupportMultiTextTranslate: Boolean = true

    override fun setFormData(from: String, to: String, text: String): TranslateFactory {
        formData["q"] = text
        formData["target"] = langMap[to]!!
        formData["format"] = "text"
        if (LANG.AUTO != from && langMap.containsKey(from)) {
            formData["source"] = langMap[from]!!
        }
        formData["model"] = "nmt"
        formData["key"] = key//"AIzaSyBCC6RoPvSC5iGGuw920KEZxHN8LFLWNkU"
        return this
    }

    override fun parses(response: retrofit2.Response<ResponseBody>): List<String> {

        if (response.isSuccessful) {
            val responseBody = response.body()!!
            val text = responseBody.string()
            //println("text=$text")
            val jsonObject = Gson().fromJson<JsonObject>(text, JsonObject::class.java)

            val resultArray = jsonObject.getAsJsonObject("data")
                .getAsJsonArray("translations")
            val list = arrayListOf<String>()
            for (ja in resultArray) {
                val tran = ja.asJsonObject.get("translatedText").asString
                val detectedSourceLanguage =
                    ja.asJsonObject?.get("detectedSourceLanguage")?.asString
                if (detectedSourceLanguage != null) {
                    //detectLang = googleCodeToLang(detectedSourceLanguage)
                }

                list.add(tran)
            }
            return list
        }

        val errorBody = response.errorBody()?.string()
        println("errorBody=$errorBody")
        throw Exception("Google Cloud Code=${response.code()}")

    }

    /**
     * @return key:language value:translation
     */
    fun parses2(response: retrofit2.Response<ResponseBody>): Map<String, String> {
        if (response.isSuccessful) {
            val responseBody = response.body()!!
            val text = responseBody.string()
            val jsonObject = Gson().fromJson<JsonObject>(text, JsonObject::class.java)
            val resultArray = jsonObject.getAsJsonObject("data")
                .getAsJsonArray("translations")
            //val list = arrayListOf<String>()
            val map = hashMapOf<String, String>()
            for (ja in resultArray) {

                val detectedSourceLanguage =
                    ja.asJsonObject.get("detectedSourceLanguage")?.asString ?: ""
                val translation = ja.asJsonObject.get("translatedText")?.asString ?: ""

                //val detectLang = detectedSourceLanguage?.let { googleCodeToLang(it) } ?: ""
                map[detectedSourceLanguage] = translation
            }
            return map
        }

        val errorBody = response.errorBody()?.string()
        println("errorBody=$errorBody")
        throw Exception("Google Cloud Code=${response.code()}")

    }

    override fun setLangSupport(langMap: HashMap<String, String>) {
        langMap[LANG.AUTO] = "auto"
        langMap[LANG.AF] = "af"//南非荷兰语
        langMap[LANG.SQ] = "sq"//阿尔巴尼亚语
        langMap[LANG.AM] = "am"//阿姆哈拉语
        langMap[LANG.AR] = "ar"//阿拉伯语
        langMap[LANG.HY] = "hy"//亚美尼亚语
        langMap[LANG.AZ] = "az"//阿塞拜疆语
        langMap[LANG.EU] = "eu"//巴斯克语
        langMap[LANG.BE] = "be"//白俄罗斯语
        langMap[LANG.BN] = "bn"//孟加拉语
        langMap[LANG.BS] = "bs"//波斯尼亚语
        langMap[LANG.BG] = "bg"//保加利亚语
        langMap[LANG.CA] = "ca"//加泰罗尼亚语
        langMap[LANG.CEB] = "ceb"//宿务语
        langMap[LANG.ZH_CN] = "zh"//中文
        langMap[LANG.ZH_TW] = "zh-TW"//中文
        langMap[LANG.CO] = "co"//科西嘉语
        langMap[LANG.HR] = "hr"//克罗地亚语
        langMap[LANG.CS] = "cs"//捷克语
        langMap[LANG.DA] = "da"//丹麦语
        langMap[LANG.NL] = "nl"//荷兰语
        langMap[LANG.EN] = "en"//英语
        langMap[LANG.EO] = "eo"//世界语
        langMap[LANG.ET] = "et"//爱沙尼亚语
        langMap[LANG.FI] = "fi"//芬兰语
        langMap[LANG.FR] = "fr"//法语
        langMap[LANG.FY] = "fy"//西弗里西亚语
        langMap[LANG.GL] = "gl"//加利西亚语
        langMap[LANG.KA] = "ka"//格鲁吉亚语
        langMap[LANG.DE] = "de"//德语
        langMap[LANG.EL] = "el"//希腊语
        langMap[LANG.GU] = "gu"//古吉拉特语
        langMap[LANG.HT] = "ht"//海地克里奥尔语
        langMap[LANG.HA] = "ha"//豪萨语
        langMap[LANG.HAW] = "haw"//夏威夷语
        langMap[LANG.HE] = "he"//希伯来语
        langMap[LANG.HI] = "hi"//印地语
        langMap[LANG.HMN] = "hmn"//苗语
        langMap[LANG.HU] = "hu"//匈牙利语
        langMap[LANG.IS] = "is"//冰岛语
        langMap[LANG.IG] = "ig"//伊博语
        langMap[LANG.ID] = "id"//印度尼西亚语
        langMap[LANG.GA] = "ga"//爱尔兰语
        langMap[LANG.IT] = "it"//意大利语
        langMap[LANG.JA] = "ja"//日语
        langMap[LANG.JV] = "jv"//爪哇语
        langMap[LANG.KN] = "kn"//卡纳达语
        langMap[LANG.KK] = "kk"//哈萨克语
        langMap[LANG.KM] = "km"//高棉语
        langMap[LANG.RW] = "rw"//卢旺达语
        langMap[LANG.KO] = "ko"//韩语
        langMap[LANG.KU] = "ku"//库尔德语
        langMap[LANG.KY] = "ky"//柯尔克孜语
        langMap[LANG.LO] = "lo"//老挝语
        langMap[LANG.LA] = "la"//拉丁语
        langMap[LANG.LV] = "lv"//拉脱维亚语
        langMap[LANG.LT] = "lt"//立陶宛语
        langMap[LANG.LB] = "lb"//卢森堡语
        langMap[LANG.MK] = "mk"//马其顿语
        langMap[LANG.MG] = "mg"//马拉加斯语
        langMap[LANG.MS] = "ms"//马来语
        langMap[LANG.ML] = "ml"//马拉雅拉姆语
        langMap[LANG.MT] = "mt"//马耳他语
        langMap[LANG.MI] = "mi"//毛利语
        langMap[LANG.MR] = "mr"//马拉地语
        langMap[LANG.MN] = "mn"//蒙古语
        langMap[LANG.MY] = "my"//缅甸语
        langMap[LANG.NE] = "ne"//尼泊尔语
        langMap[LANG.NO] = "no"//挪威语
        langMap[LANG.NY] = "ny"//齐切瓦语
        langMap[LANG.OR] = "or"//奥里亚语
        langMap[LANG.PS] = "ps"//普什图语
        langMap[LANG.FA] = "fa"//波斯语
        langMap[LANG.PL] = "pl"//波兰语
        langMap[LANG.PT] = "pt"//葡萄牙语
        langMap[LANG.PA] = "pa"//旁遮普语
        langMap[LANG.RO] = "ro"//罗马尼亚语
        langMap[LANG.RU] = "ru"//俄语
        langMap[LANG.SM] = "sm"//萨摩亚语
        langMap[LANG.GD] = "gd"//苏格兰盖尔语
        langMap[LANG.SR] = "sr"//塞尔维亚语
        langMap[LANG.ST] = "st"//南索托语
        langMap[LANG.SN] = "sn"//绍纳语
        langMap[LANG.SD] = "sd"//信德语
        langMap[LANG.SI] = "si"//僧伽罗语
        langMap[LANG.SK] = "sk"//斯洛伐克语
        langMap[LANG.SL] = "sl"//斯洛文尼亚语
        langMap[LANG.SO] = "so"//索马里语
        langMap[LANG.ES] = "es"//西班牙语
        langMap[LANG.SU] = "su"//巽他语
        langMap[LANG.SW] = "sw"//斯瓦希里语
        langMap[LANG.SV] = "sv"//瑞典语
        langMap[LANG.TL] = "tl"//他加禄语
        langMap[LANG.FIL] = "tl"
        langMap[LANG.TG] = "tg"//塔吉克语
        langMap[LANG.TA] = "ta"//泰米尔语
        langMap[LANG.TT] = "tt"//鞑靼语
        langMap[LANG.TE] = "te"//泰卢固语
        langMap[LANG.TH] = "th"//泰语
        langMap[LANG.TR] = "tr"//土耳其语
        langMap[LANG.TK] = "tk"//土库曼语
        langMap[LANG.UK] = "uk"//乌克兰语
        langMap[LANG.UR] = "ur"//乌尔都语
        langMap[LANG.UG] = "ug"//维吾尔语
        langMap[LANG.UZ] = "uz"//乌兹别克语
        langMap[LANG.VI] = "vi"//越南语
        langMap[LANG.CY] = "cy"//威尔士语
        langMap[LANG.XH] = "xh"//科萨语
        langMap[LANG.YI] = "yi"//意第绪语
        langMap[LANG.YO] = "yo"//约鲁巴语
        langMap[LANG.ZU] = "zu"//祖玛语
    }

    override fun execute(): Flowable<retrofit2.Response<ResponseBody>> {

        return com.talpa.tengine.request.RequestHelper.get(
            BASE_URL,
            PATHS, params = formData
        )
    }

    //https://cloud.google.com/translate/docs/reference/translate?hl=zh-cn

    companion object {
        private const val BASE_URL = "https://translation.googleapis.com/"
        private const val PATHS = "language/translate/v2"
    }
}

fun main() {
    val key1 = "AIzaSyCgkgTZvW5GK0wy1Qu4HdjPtm6w7I6nSOQ"
    val key2 = "AIzaSyB4o0Ni6lsGKxqB41Jt1Dq6LlMODOdEXhI"
    val key3 = "AIzaSyA88XSmCUKvc3EbIi69H9vqLrRn1YglIvA"
    val key4 = "AIzaSyALIF6ta7tNX9g8jJlcGdzzVlszHqWZttI"//po jie
//    val key5 = "AIzaSyCBM06BQ9Iea6W57NJurkE6462kjxSN3U"
    //val key5 = "AIzaSyCBM06BQ9lea6W57NJurkE6_462kjxSN3U"
    //wfvA7ZxWYNPX7EZNOKayyOXFxHJmVdfaFzBla9RPEOgSItK3BAcoew1qdQY2 uRwN
    val translate =
        GoogleCloudTranslate(key = key4)//"AIzaSyBCC6RoPvSC5iGGuw920KEZxHN8LFLWNkU"
    translate.setFormData(LANG.AUTO, LANG.EN, "今天天气怎样")
    val d = translate.execute().subscribe({

        println(translate.parses(it))
    }, Throwable::printStackTrace)

    //println(localeToLang(Locale.forLanguageTag("hi-IN")))


}