package com.talpa.tengine.offline

import android.util.Log
import com.google.mlkit.nl.translate.TranslateLanguage
import com.talpa.tengine.OFFLINE
import com.talpa.tengine.Trans
import com.talpa.tengine.lang.LANG
import io.reactivex.Flowable


/**
 * 扩展 离线翻译
 *
 * @author CY 19-12-25
 *
 */
fun TranslateFlow.startOfflineTranslate(
    trans: Trans,
    downloadModelIfNeeded: Boolean = false
): Flowable<Trans> {

    val targetLanguageCode = trans.to.toFirebaseTranslateLanguage()
    if (targetLanguageCode == null) {
        trans.result = Trans.Result(code = Trans.ERROR_OTHER, source = OFFLINE)
        return Flowable.just(trans)
    }

    val text = trans.text

    val map = { result: TranslateFlow.Result ->

        when (result.code) {
            TranslateFlow.SUCCESS_TRANSLATE -> {

                val identifyLanguageCode = result.identifyLanguageCode
                val detectLang = if (identifyLanguageCode != null) {
                    val code = TranslateLanguage.fromLanguageTag(
                        identifyLanguageCode
                    )
                    if (code != null) {
                        firebaseTranslateLanguageToLANG(code)
                    } else null

                } else {
                    null
                }

                trans.result = Trans.Result(
                    code = Trans.SUCCESS,
                    translation = result.translation,
                    detectLang = detectLang,
                    source = OFFLINE
                )
            }
            TranslateFlow.SUCCESS_IDENTIFY_LANGUAGE -> {
            }
            TranslateFlow.SUCCESS_DOWNLOAD_MODE -> {
            }
            TranslateFlow.ERROR_TRANSLATE -> {
                trans.result = Trans.Result(
                    code = Trans.ERROR_OTHER,
                    errorMessage = result.exception?.localizedMessage,
                    source = OFFLINE
                )
            }
            TranslateFlow.ERROR_DOWNLOAD_MODE -> {
                trans.result = Trans.Result(
                    code = Trans.ERROR_OTHER,
                    errorMessage = result.exception?.localizedMessage,
                    source = OFFLINE
                )
            }
            TranslateFlow.ERROR_IDENTIFY_LANGUAGE -> {
                trans.result = Trans.Result(
                    code = Trans.ERROR_OTHER,
                    errorMessage = result.exception?.localizedMessage,
                    source = OFFLINE
                )
            }
            TranslateFlow.ERROR_NOT_SUPPORT_LANGUAGE -> {
                trans.result = Trans.Result(
                    code = Trans.ERROR_OTHER,
                    errorMessage = result.exception?.localizedMessage,
                    source = OFFLINE
                )
            }
            else -> {
                trans.result = Trans.Result(
                    code = Trans.ERROR_OTHER,
                    errorMessage = result.exception?.localizedMessage,
                    source = OFFLINE
                )
            }
        }
        trans
    }

    val languageCode = trans.from.toFirebaseTranslateLanguage()

    if (languageCode != null) {
        return translate(languageCode, targetLanguageCode, text, downloadModelIfNeeded, true)
            .map(map)
    } else {
        return Flowable.just(
            TranslateFlow.Result(
                code = TranslateFlow.ERROR_TRANSLATE,
                sourceText = text,
                sourceLanguage = trans.from,
                targetLanguage = trans.to
            )
        ).map(map)
    }
    /*return autoTranslate(
        targetLanguageCode,
        text,
        downloadModelIfNeeded = downloadModelIfNeeded,
        downloadModelRequireWifi = true
    ).map(map)*/

}

fun firebaseTranslateLanguageToLANG(@TranslateLanguage.Language language: String): String? {
    val map = hashMapOf(

        TranslateLanguage.AFRIKAANS to LANG.AF,//南非荷兰语
        TranslateLanguage.ARABIC to LANG.AR,//阿拉伯语
        TranslateLanguage.BELARUSIAN to LANG.BE,//白俄罗斯语
        TranslateLanguage.BULGARIAN to LANG.BG,//保加利亚语
        TranslateLanguage.BENGALI to LANG.BN,//孟加拉语
        TranslateLanguage.CATALAN to LANG.CA,//加泰罗尼亚语
        TranslateLanguage.CZECH to LANG.CS,//捷克语
        TranslateLanguage.WELSH to LANG.CY,//威尔士语
        TranslateLanguage.DANISH to LANG.DA,//丹麦语
        TranslateLanguage.GERMAN to LANG.DE,//德语
        TranslateLanguage.GREEK to LANG.EL,//希腊语
        TranslateLanguage.ENGLISH to LANG.EN,//英语
        TranslateLanguage.ESPERANTO to LANG.EO,//世界语
        TranslateLanguage.SPANISH to LANG.ES,//西班牙语
        TranslateLanguage.ESTONIAN to LANG.ET,//爱沙尼亚语
        TranslateLanguage.PERSIAN to LANG.FA,//波斯语
        TranslateLanguage.FINNISH to LANG.FI,//芬兰语
        TranslateLanguage.FRENCH to LANG.FR,//法语
        TranslateLanguage.IRISH to LANG.GA,//爱尔兰语
        TranslateLanguage.GALICIAN to LANG.GL,//加利西亚语
        TranslateLanguage.GUJARATI to LANG.GU,//古吉拉特语
        TranslateLanguage.HEBREW to LANG.HE,//希伯来语
        TranslateLanguage.HINDI to LANG.HI,//印地语
        TranslateLanguage.CROATIAN to LANG.HR,//克罗地亚语
        TranslateLanguage.HAITIAN_CREOLE to LANG.HT,//海地语
        TranslateLanguage.HUNGARIAN to LANG.HU,//匈牙利语
        TranslateLanguage.INDONESIAN to LANG.ID,//印度尼西亚语
        TranslateLanguage.ICELANDIC to LANG.IS,//冰岛语
        TranslateLanguage.ITALIAN to LANG.IT,//意大利语
        TranslateLanguage.JAPANESE to LANG.JA,//日语
        TranslateLanguage.GEORGIAN to LANG.KA,//格鲁吉亚语
        TranslateLanguage.KANNADA to LANG.KN,//卡纳达语
        TranslateLanguage.KOREAN to LANG.KO,//韩语
        TranslateLanguage.LITHUANIAN to LANG.LT,//立陶宛语
        TranslateLanguage.LATVIAN to LANG.LV,//拉脱维亚语
        TranslateLanguage.MACEDONIAN to LANG.MK,//马其顿语
        TranslateLanguage.MARATHI to LANG.MR,//马拉地语
        TranslateLanguage.MALAY to LANG.MS,//马来语
        TranslateLanguage.MALTESE to LANG.MT,//马耳他语
        TranslateLanguage.DUTCH to LANG.NL,//荷兰语
        TranslateLanguage.NORWEGIAN to LANG.NO,//挪威语
        TranslateLanguage.POLISH to LANG.PL,//波兰语
        TranslateLanguage.PORTUGUESE to LANG.PT,//葡萄牙语
        TranslateLanguage.ROMANIAN to LANG.RO,//罗马尼亚语
        TranslateLanguage.RUSSIAN to LANG.RU,//俄语
        TranslateLanguage.SLOVAK to LANG.SK,//斯洛伐克语
        TranslateLanguage.SLOVENIAN to LANG.SL,//斯洛文尼亚语
        TranslateLanguage.ALBANIAN to LANG.SQ,//阿尔巴尼亚语
        TranslateLanguage.SWEDISH to LANG.SV,//瑞典语
        TranslateLanguage.SWAHILI to LANG.SW,//斯瓦希里语
        TranslateLanguage.TAMIL to LANG.TA,//泰米尔语
        TranslateLanguage.TELUGU to LANG.TE,//泰卢固语
        TranslateLanguage.THAI to LANG.TH,//泰语
        TranslateLanguage.TAGALOG to LANG.TL,//塔加路语
        TranslateLanguage.TURKISH to LANG.TR,//土耳其语
        TranslateLanguage.UKRAINIAN to LANG.UK,//乌克兰语
        TranslateLanguage.URDU to LANG.UR,//乌尔都语
        TranslateLanguage.VIETNAMESE to LANG.VI,//越南语
        TranslateLanguage.CHINESE to LANG.ZH_CN//中文
    )

    return map[language]
}


fun String.toFirebaseTranslateLanguage(): String? {
    val map = hashMapOf(
        LANG.AF to TranslateLanguage.AFRIKAANS,
        LANG.AR to TranslateLanguage.ARABIC,
        LANG.BE to TranslateLanguage.BELARUSIAN,
        LANG.BG to TranslateLanguage.BULGARIAN,
        LANG.BN to TranslateLanguage.BENGALI,
        LANG.CA to TranslateLanguage.CATALAN,
        LANG.CS to TranslateLanguage.CZECH,
        LANG.CY to TranslateLanguage.WELSH,
        LANG.DA to TranslateLanguage.DANISH,
        LANG.DE to TranslateLanguage.GERMAN,
        LANG.EL to TranslateLanguage.GREEK,
        LANG.EN to TranslateLanguage.ENGLISH,
        LANG.EO to TranslateLanguage.ESPERANTO,
        LANG.ES to TranslateLanguage.SPANISH,
        LANG.ET to TranslateLanguage.ESTONIAN,
        LANG.FA to TranslateLanguage.PERSIAN,
        LANG.FI to TranslateLanguage.FINNISH,
        LANG.FR to TranslateLanguage.FRENCH,
        LANG.GA to TranslateLanguage.IRISH,
        LANG.GL to TranslateLanguage.GALICIAN,
        LANG.GU to TranslateLanguage.GUJARATI,
        LANG.HE to TranslateLanguage.HEBREW,
        LANG.HI to TranslateLanguage.HINDI,
        LANG.HR to TranslateLanguage.CROATIAN,
        LANG.HT to TranslateLanguage.HAITIAN_CREOLE,
        LANG.HU to TranslateLanguage.HUNGARIAN,
        LANG.ID to TranslateLanguage.INDONESIAN,
        LANG.IS to TranslateLanguage.ICELANDIC,
        LANG.IT to TranslateLanguage.ITALIAN,
        LANG.JA to TranslateLanguage.JAPANESE,
        LANG.KA to TranslateLanguage.GEORGIAN,
        LANG.KN to TranslateLanguage.KANNADA,
        LANG.KO to TranslateLanguage.KOREAN,
        LANG.LT to TranslateLanguage.LITHUANIAN,
        LANG.LV to TranslateLanguage.LATVIAN,
        LANG.MK to TranslateLanguage.MACEDONIAN,
        LANG.MR to TranslateLanguage.MARATHI,
        LANG.MS to TranslateLanguage.MALAY,
        LANG.MT to TranslateLanguage.MALTESE,
        LANG.NL to TranslateLanguage.DUTCH,
        LANG.NO to TranslateLanguage.NORWEGIAN,
        LANG.PL to TranslateLanguage.POLISH,
        LANG.PT to TranslateLanguage.PORTUGUESE,
        LANG.RO to TranslateLanguage.ROMANIAN,
        LANG.RU to TranslateLanguage.RUSSIAN,
        LANG.SK to TranslateLanguage.SLOVAK,
        LANG.SL to TranslateLanguage.SLOVENIAN,
        LANG.SQ to TranslateLanguage.ALBANIAN,
        LANG.SV to TranslateLanguage.SWEDISH,
        LANG.SW to TranslateLanguage.SWAHILI,
        LANG.TA to TranslateLanguage.TAMIL,
        LANG.TE to TranslateLanguage.TELUGU,
        LANG.TH to TranslateLanguage.THAI,
        LANG.TL to TranslateLanguage.TAGALOG,
        LANG.TR to TranslateLanguage.TURKISH,
        LANG.UK to TranslateLanguage.UKRAINIAN,
        LANG.UR to TranslateLanguage.URDU,
        LANG.VI to TranslateLanguage.VIETNAMESE,
        LANG.ZH_CN to TranslateLanguage.CHINESE
    )

    return map[this]

}

//
//fun firebaseTranslateLanguageToLocale(@FirebaseTranslateLanguage.TranslateLanguage language: Int):String? {
//    val map = hashMapOf(
//
//        FirebaseTranslateLanguage.AF to Locale.forLanguageTag(
//            FirebaseTranslateLanguage.languageCodeForLanguage(
//                FirebaseTranslateLanguage.AF
//            )
//        ),//南非荷兰语
//        FirebaseTranslateLanguage.AR to LANG.AR,//阿拉伯语
//        FirebaseTranslateLanguage.BE to LANG.BE,//白俄罗斯语
//        FirebaseTranslateLanguage.BG to LANG.BG,//保加利亚语
//        FirebaseTranslateLanguage.BN to LANG.BN,//孟加拉语
//        FirebaseTranslateLanguage.CA to LANG.CA,//加泰罗尼亚语
//        FirebaseTranslateLanguage.CS to LANG.CS,//捷克语
//        FirebaseTranslateLanguage.CY to LANG.CY,//威尔士语
//        FirebaseTranslateLanguage.DA to LANG.DA,//丹麦语
//        FirebaseTranslateLanguage.DE to LANG.DE,//德语
//        FirebaseTranslateLanguage.EL to LANG.EL,//希腊语
//        FirebaseTranslateLanguage.EN to LANG.EN,//英语
//        FirebaseTranslateLanguage.EO to LANG.EO,//世界语
//        FirebaseTranslateLanguage.ES to LANG.ES,//西班牙语
//        FirebaseTranslateLanguage.ET to LANG.ET,//爱沙尼亚语
//        FirebaseTranslateLanguage.FA to LANG.FA,//波斯语
//        FirebaseTranslateLanguage.FI to LANG.FI,//芬兰语
//        FirebaseTranslateLanguage.FR to LANG.FR,//法语
//        FirebaseTranslateLanguage.GA to LANG.GA,//爱尔兰语
//        FirebaseTranslateLanguage.GL to LANG.GL,//加利西亚语
//        FirebaseTranslateLanguage.GU to LANG.GU,//古吉拉特语
//        FirebaseTranslateLanguage.HE to LANG.HE,//希伯来语
//        FirebaseTranslateLanguage.HI to LANG.HI,//印地语
//        FirebaseTranslateLanguage.HR to LANG.HR,//克罗地亚语
//        FirebaseTranslateLanguage.HT to LANG.HT,//海地语
//        FirebaseTranslateLanguage.HU to LANG.HU,//匈牙利语
//        FirebaseTranslateLanguage.ID to LANG.ID,//印度尼西亚语
//        FirebaseTranslateLanguage.IS to LANG.IS,//冰岛语
//        FirebaseTranslateLanguage.IT to LANG.IT,//意大利语
//        FirebaseTranslateLanguage.JA to LANG.JA,//日语
//        FirebaseTranslateLanguage.KA to LANG.KA,//格鲁吉亚语
//        FirebaseTranslateLanguage.KN to LANG.KN,//卡纳达语
//        FirebaseTranslateLanguage.KO to LANG.KO,//韩语
//        FirebaseTranslateLanguage.LT to LANG.LT,//立陶宛语
//        FirebaseTranslateLanguage.LV to LANG.LV,//拉脱维亚语
//        FirebaseTranslateLanguage.MK to LANG.MK,//马其顿语
//        FirebaseTranslateLanguage.MR to LANG.MR,//马拉地语
//        FirebaseTranslateLanguage.MS to LANG.MS,//马来语
//        FirebaseTranslateLanguage.MT to LANG.MT,//马耳他语
//        FirebaseTranslateLanguage.NL to LANG.NL,//荷兰语
//        FirebaseTranslateLanguage.NO to LANG.NB,//挪威语
//        FirebaseTranslateLanguage.PL to LANG.PL,//波兰语
//        FirebaseTranslateLanguage.PT to LANG.PT,//葡萄牙语
//        FirebaseTranslateLanguage.RO to LANG.RO,//罗马尼亚语
//        FirebaseTranslateLanguage.RU to LANG.RU,//俄语
//        FirebaseTranslateLanguage.SK to LANG.SK,//斯洛伐克语
//        FirebaseTranslateLanguage.SL to LANG.SL,//斯洛文尼亚语
//        FirebaseTranslateLanguage.SQ to LANG.SQ,//阿尔巴尼亚语
//        FirebaseTranslateLanguage.SV to LANG.SV,//瑞典语
//        FirebaseTranslateLanguage.SW to LANG.SW,//斯瓦希里语
//        FirebaseTranslateLanguage.TA to LANG.TA,//泰米尔语
//        FirebaseTranslateLanguage.TE to LANG.TE,//泰卢固语
//        FirebaseTranslateLanguage.TH to LANG.TH,//泰语
//        FirebaseTranslateLanguage.TL to LANG.FIL,//塔加路语
//        FirebaseTranslateLanguage.TR to LANG.TR,//土耳其语
//        FirebaseTranslateLanguage.UK to LANG.UK,//乌克兰语
//        FirebaseTranslateLanguage.UR to LANG.UR,//乌尔都语
//        FirebaseTranslateLanguage.VI to LANG.VI,//越南语
//        FirebaseTranslateLanguage.ZH to LANG.ZH_CN//中文
//    )
//
//    return map[language]
//}
