package com.talpa.translator.link

import android.content.Context
import android.text.TextUtils
import android.util.Base64
import com.talpa.translate.config.*

/**
 * @author CY 2020/6/19
 */


internal fun Context.getServerAppKey(): String? {
    return getString(R.string.s_ky).decode()
}

internal fun Context.getServerAppSecret(): String? {
    return getString(R.string.s_st).decode()
}

internal fun Context.getGoogleKey(): String? {
    return getStringFromRemoteConfig(GOOGLE_SUBSCRIPTION_KEY)
}

internal fun Context.getMicrosoftKey(): String? {
    return getStringFromRemoteConfig(MICROSOFT_SUBSCRIPTION_KEY)
}

internal fun Context.getOfflineTranslateLimitDate(): Long {

    val days = getLongFromRemoteConfig(SILENCE_DAYS)?.toInt() ?: 30
    if (days <= 0) {
        return silenceDate()
    }
    return silenceDate(days)
}

internal fun Context.isEnabledOfflineTranslate(): Boolean {
    val limitDate = getOfflineTranslateLimitDate()
    val currentDate = System.currentTimeMillis()
    return currentDate >= limitDate
}


internal fun Context.isEnabledYandex(): Boolean {
    return getBooleanFromRemoteConfig("translator_yandex") ?: false
}


/**
 * String 加密
 */
internal fun String.encode(): String {
    return reversed().encode64().encode64()
}

/**
 * String 解密
 */
internal fun String.decode(): String {
    return decode64().decode64().reversed()
}

internal fun String.decode64(): String {
    return Base64.decode(this, Base64.DEFAULT)
        .toString(Charsets.UTF_8)
}

internal fun String.encode64(): String {
    return Base64.encodeToString(this.toByteArray(Charsets.UTF_8), Base64.DEFAULT)
}