/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.datareport;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.talpa.datareport.ReportDao;
import com.talpa.datareport.ReportEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ReportDao_Impl
implements ReportDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ReportEntity> __insertionAdapterOfReportEntity;
    private final EntityDeletionOrUpdateAdapter<ReportEntity> __deletionAdapterOfReportEntity;
    private final EntityDeletionOrUpdateAdapter<ReportEntity> __updateAdapterOfReportEntity;

    public ReportDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfReportEntity = new EntityInsertionAdapter<ReportEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `report_table` (`id`,`from`,`to`,`code`,`source`,`strLength`,`transHash`,`startTime`,`finishTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ReportEntity value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getFrom() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFrom());
                }
                if (value.getTo() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTo());
                }
                stmt.bindLong(4, (long)value.getCode());
                if (value.getSource() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSource());
                }
                stmt.bindLong(6, (long)value.getStrLength());
                stmt.bindLong(7, (long)value.getTransHash());
                stmt.bindLong(8, value.getStartTime());
                stmt.bindLong(9, value.getFinishTime());
            }
        };
        this.__deletionAdapterOfReportEntity = new EntityDeletionOrUpdateAdapter<ReportEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `report_table` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ReportEntity value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__updateAdapterOfReportEntity = new EntityDeletionOrUpdateAdapter<ReportEntity>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `report_table` SET `id` = ?,`from` = ?,`to` = ?,`code` = ?,`source` = ?,`strLength` = ?,`transHash` = ?,`startTime` = ?,`finishTime` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ReportEntity value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getFrom() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFrom());
                }
                if (value.getTo() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTo());
                }
                stmt.bindLong(4, (long)value.getCode());
                if (value.getSource() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSource());
                }
                stmt.bindLong(6, (long)value.getStrLength());
                stmt.bindLong(7, (long)value.getTransHash());
                stmt.bindLong(8, value.getStartTime());
                stmt.bindLong(9, value.getFinishTime());
                stmt.bindLong(10, (long)value.getId());
            }
        };
    }

    @Override
    public void markTrans(ReportEntity reportEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfReportEntity.insert((Object)reportEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteFinishTrans(List<ReportEntity> reportEntities) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfReportEntity.handleMultiple(reportEntities);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void markTransFinish(ReportEntity reportEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfReportEntity.handle((Object)reportEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportEntity queryStartedTrans(int hash) {
        String _sql = "SELECT * FROM report_table WHERE transHash = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM report_table WHERE transHash = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)hash);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ReportEntity _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"from");
            int _cursorIndexOfTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"to");
            int _cursorIndexOfCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"code");
            int _cursorIndexOfSource = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"source");
            int _cursorIndexOfStrLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"strLength");
            int _cursorIndexOfTransHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transHash");
            int _cursorIndexOfStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"startTime");
            int _cursorIndexOfFinishTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"finishTime");
            if (_cursor.moveToFirst()) {
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                String _tmpFrom = _cursor.isNull(_cursorIndexOfFrom) ? null : _cursor.getString(_cursorIndexOfFrom);
                String _tmpTo = _cursor.isNull(_cursorIndexOfTo) ? null : _cursor.getString(_cursorIndexOfTo);
                int _tmpCode = _cursor.getInt(_cursorIndexOfCode);
                String _tmpSource = _cursor.isNull(_cursorIndexOfSource) ? null : _cursor.getString(_cursorIndexOfSource);
                int _tmpStrLength = _cursor.getInt(_cursorIndexOfStrLength);
                int _tmpTransHash = _cursor.getInt(_cursorIndexOfTransHash);
                long _tmpStartTime = _cursor.getLong(_cursorIndexOfStartTime);
                long _tmpFinishTime = _cursor.getLong(_cursorIndexOfFinishTime);
                _result = new ReportEntity(_tmpId, _tmpFrom, _tmpTo, _tmpCode, _tmpSource, _tmpStrLength, _tmpTransHash, _tmpStartTime, _tmpFinishTime);
            } else {
                _result = null;
            }
            ReportEntity reportEntity = _result;
            return reportEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReportEntity> queryUploadTrans() {
        String _sql = "SELECT * FROM report_table WHERE finishTime != 0 AND startTime != 0";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM report_table WHERE finishTime != 0 AND startTime != 0", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"from");
            int _cursorIndexOfTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"to");
            int _cursorIndexOfCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"code");
            int _cursorIndexOfSource = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"source");
            int _cursorIndexOfStrLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"strLength");
            int _cursorIndexOfTransHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transHash");
            int _cursorIndexOfStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"startTime");
            int _cursorIndexOfFinishTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"finishTime");
            ArrayList<ReportEntity> _result = new ArrayList<ReportEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                String _tmpFrom = _cursor.isNull(_cursorIndexOfFrom) ? null : _cursor.getString(_cursorIndexOfFrom);
                String _tmpTo = _cursor.isNull(_cursorIndexOfTo) ? null : _cursor.getString(_cursorIndexOfTo);
                int _tmpCode = _cursor.getInt(_cursorIndexOfCode);
                String _tmpSource = _cursor.isNull(_cursorIndexOfSource) ? null : _cursor.getString(_cursorIndexOfSource);
                int _tmpStrLength = _cursor.getInt(_cursorIndexOfStrLength);
                int _tmpTransHash = _cursor.getInt(_cursorIndexOfTransHash);
                long _tmpStartTime = _cursor.getLong(_cursorIndexOfStartTime);
                long _tmpFinishTime = _cursor.getLong(_cursorIndexOfFinishTime);
                ReportEntity _item = new ReportEntity(_tmpId, _tmpFrom, _tmpTo, _tmpCode, _tmpSource, _tmpStrLength, _tmpTransHash, _tmpStartTime, _tmpFinishTime);
                _result.add(_item);
            }
            ArrayList<ReportEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

