/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import com.talpa.tengine.store.TranslationStoreKt;
import com.talpa.translate.Hex;
import com.talpa.translator.link.TranslatorLinkKt;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.POST;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 %2\u00020\u0001:\u0007#$%&'()B1\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u0012\u001a\u00020\u0003H\u0002J0\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\f\u0010\"\u001a\u00020\u0003*\u00020\u0003H\u0002R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/talpa/translate/HiTranslator;", "", "sourceLanguage", "", "targetLanguage", "text", "appKey", "secret", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "apiService", "Lcom/talpa/translate/HiTranslator$ApiService;", "getApiService", "()Lcom/talpa/translate/HiTranslator$ApiService;", "apiService$delegate", "Lkotlin/Lazy;", "connect", "Lcom/talpa/translate/HiTranslator$Result;", "execute", "generateNonce", "generateSign", "timestamp", "", "nonce", "parserJson", "json", "provideCache", "Lokhttp3/Cache;", "readInputStream", "inputStream", "Ljava/io/InputStream;", "writeOutputStream", "", "outputStream", "Ljava/io/OutputStream;", "md5", "ApiService", "Builder", "Companion", "HttpLogger", "Result", "ResultV2", "TransResult", "translator-link_release"})
@Keep
public final class HiTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String sourceLanguage;
    @NotNull
    private final String targetLanguage;
    @NotNull
    private final String text;
    @NotNull
    private final String appKey;
    @NotNull
    private final String secret;
    @NotNull
    private final Lazy apiService$delegate;
    @NotNull
    private static final String BASE_URL = "https://api.translasion.com";
    private static final int CONNECT_TIME_OUT = 6000;
    private static final int READ_TIME_OUT = 8000;
    @NotNull
    private static final String REQUEST_METHOD = "POST";
    @NotNull
    private static final String CONTENT_TYPE = "application/json";
    @NotNull
    private static final HashMap<String, String> supportLanguageMap;

    private HiTranslator(String sourceLanguage, String targetLanguage, String text, String appKey, String secret) {
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.text = text;
        this.appKey = appKey;
        this.secret = secret;
        this.apiService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ApiService>(this){
            final /* synthetic */ HiTranslator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ApiService invoke() {
                ApiService apiService2;
                if (TranslatorLinkKt.getDEBUG()) {
                    HttpLoggingInterceptor logInterceptor2 = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new HttpLogger());
                    logInterceptor2.setLevel(HttpLoggingInterceptor.Level.BODY);
                    Retrofit.Builder builder = new Retrofit.Builder().baseUrl("https://api.translasion.com").addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(new OkHttpClient.Builder().cache(HiTranslator.access$provideCache(this.this$0)).addNetworkInterceptor((Interceptor)logInterceptor2).build());
                    apiService2 = (ApiService)builder.build().create(ApiService.class);
                } else {
                    Retrofit.Builder builder = new Retrofit.Builder().baseUrl("https://api.translasion.com").addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(new OkHttpClient.Builder().cache(HiTranslator.access$provideCache(this.this$0)).build());
                    apiService2 = (ApiService)builder.build().create(ApiService.class);
                }
                return apiService2;
            }
        }));
    }

    private final ApiService getApiService() {
        Lazy lazy = this.apiService$delegate;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-apiService>(...)");
        return (ApiService)object;
    }

    private final Cache provideCache() {
        File file = Environment.getDataDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDataDirectory()");
        return new Cache(file, 0xA00000L);
    }

    @NotNull
    public final Result execute() {
        int n;
        String translation = TranslationStoreKt.readTranslation(this.sourceLanguage, this.targetLanguage, this.text);
        if (!TextUtils.isEmpty((CharSequence)translation)) {
            return new Result(this.sourceLanguage, this.targetLanguage, this.text, translation, 1000, null, true, false, 160, null);
        }
        long timestamp = System.currentTimeMillis() / (long)1000;
        String nonce = this.generateNonce();
        String sig = this.generateSign(this.appKey, this.targetLanguage, timestamp, this.secret, nonce);
        TransResult resultv22 = (TransResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransResult>, Object>(this, timestamp, sig, nonce, null){
            int label;
            final /* synthetic */ HiTranslator this$0;
            final /* synthetic */ long $timestamp;
            final /* synthetic */ String $sig;
            final /* synthetic */ String $nonce;
            {
                this.this$0 = $receiver;
                this.$timestamp = $timestamp;
                this.$sig = $sig;
                this.$nonce = $nonce;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean bl = false;
                        HashMap<K, V> map2 = new HashMap<K, V>();
                        Object object3 = map2;
                        Object object4 = "text";
                        Object object5 = HiTranslator.access$getText$p(this.this$0);
                        boolean bl2 = false;
                        object3.put(object4, object5);
                        object3 = map2;
                        object4 = "timestamp";
                        object5 = Boxing.boxLong((long)this.$timestamp);
                        bl2 = false;
                        object3.put(object4, object5);
                        object3 = map2;
                        object4 = "sig";
                        object5 = this.$sig;
                        bl2 = false;
                        object3.put(object4, object5);
                        object3 = HiTranslator.access$getSourceLanguage$p(this.this$0);
                        if (object3 != null) {
                            object4 = object3;
                            boolean bl3 = false;
                            bl2 = false;
                            Object it = object4;
                            boolean bl4 = false;
                            Map map3 = map2;
                            String string = "from";
                            boolean bl5 = false;
                            map3.put(string, it);
                        }
                        object3 = map2;
                        object4 = "to";
                        String string = HiTranslator.access$getTargetLanguage$p(this.this$0);
                        bl2 = false;
                        object3.put(object4, string);
                        object3 = map2;
                        object4 = "app_key";
                        string = HiTranslator.access$getAppKey$p(this.this$0);
                        bl2 = false;
                        object3.put(object4, string);
                        object3 = map2;
                        object4 = "nonce";
                        string = this.$nonce;
                        bl2 = false;
                        object3.put(object4, string);
                        this.label = 1;
                        Object object6 = HiTranslator.access$getApiService(this.this$0).translate((Map<String, Object>)map2, (Continuation<? super TransResult>)((Continuation)this));
                        if (object6 != object2) return object6;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object6 = $result;
                        return object6;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super TransResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        String string = this.sourceLanguage;
        String string2 = this.targetLanguage;
        String string3 = this.text;
        String string4 = resultv22.getMessage();
        ResultV2 resultV2 = resultv22.getResult();
        String string5 = resultV2 == null ? null : resultV2.getText();
        Result result = new Result(string, string2, string3, string5, n = resultv22.getCode(), string4, false, false, 192, null);
        if (!TextUtils.isEmpty((CharSequence)result.getTranslation())) {
            String string6 = result.getTranslation();
            Intrinsics.checkNotNull((Object)string6);
            TranslationStoreKt.storeTranslation(this.sourceLanguage, this.targetLanguage, this.text, string6);
        }
        return result;
    }

    private final Result connect() {
        URL url = new URL(BASE_URL);
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod(REQUEST_METHOD);
        connection.setRequestProperty("content-type", CONTENT_TYPE);
        connection.setConnectTimeout(6000);
        connection.setReadTimeout(8000);
        connection.setDefaultUseCaches(true);
        connection.setDoOutput(true);
        OutputStream outputStream = connection.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
        this.writeOutputStream(outputStream);
        outputStream.close();
        InputStream inputStream = connection.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
        Result result = this.readInputStream(inputStream);
        inputStream.close();
        connection.disconnect();
        return result;
    }

    private final void writeOutputStream(OutputStream outputStream) {
        String json;
        long timestamp = System.currentTimeMillis() / (long)1000;
        String nonce = this.generateNonce();
        String sig = this.generateSign(this.appKey, this.targetLanguage, timestamp, this.secret, nonce);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("app_key", (Object)this.appKey);
        jsonObj.put("to", (Object)this.targetLanguage);
        jsonObj.put("text", (Object)this.text);
        jsonObj.put("timestamp", timestamp);
        jsonObj.put("nonce", (Object)nonce);
        jsonObj.put("sig", (Object)sig);
        if (this.sourceLanguage != null) {
            jsonObj.put("from", (Object)this.sourceLanguage);
        }
        String string = jsonObj.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObj.toString()");
        string = json = string;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        outputStream.write(byArray);
        outputStream.flush();
    }

    private final String generateNonce() {
        Object[] objectArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
        Object[] charArray = objectArray;
        IntRange intRange = ArraysKt.getIndices((Object[])charArray);
        boolean bl = false;
        int index1 = RangesKt.random((IntRange)intRange, (Random)((Random)Random.Default));
        IntRange intRange2 = ArraysKt.getIndices((Object[])charArray);
        boolean bl2 = false;
        int index2 = RangesKt.random((IntRange)intRange2, (Random)((Random)Random.Default));
        IntRange intRange3 = ArraysKt.getIndices((Object[])charArray);
        boolean bl3 = false;
        int index3 = RangesKt.random((IntRange)intRange3, (Random)((Random)Random.Default));
        IntRange intRange4 = ArraysKt.getIndices((Object[])charArray);
        boolean bl4 = false;
        int index4 = RangesKt.random((IntRange)intRange4, (Random)((Random)Random.Default));
        return "" + ((Character)charArray[index1]).charValue() + ((Character)charArray[index2]).charValue() + ((Character)charArray[index3]).charValue() + ((Character)charArray[index4]).charValue();
    }

    private final String generateSign(String appKey, String targetLanguage, long timestamp, String secret, String nonce) {
        String value = appKey + '&' + targetLanguage + '&' + timestamp + '&' + secret + '&' + nonce;
        return this.md5(value);
    }

    private final String md5(String $this$md5) {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String string = $this$md5;
        Object object = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] data = digest.digest(byArray);
        char[] charArray = Hex.encodeHex(data);
        Intrinsics.checkNotNullExpressionValue((Object)charArray, (String)"charArray");
        object = charArray;
        bl = false;
        return new String((char[])object);
    }

    private final Result readInputStream(InputStream inputStream) {
        byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        boolean bl = false;
        String content = new String(bytes, Charsets.UTF_8);
        return this.parserJson(content);
    }

    private final Result parserJson(String json) {
        JSONObject jsonObject = new JSONObject(json);
        String keyCode = "code";
        String keyMessage = "message";
        String keyResult = "result";
        String keyText = "text";
        int valueCode = 0;
        String valueMessage = null;
        String valueText = null;
        if (jsonObject.has(keyCode)) {
            valueCode = jsonObject.getInt(keyCode);
        }
        if (jsonObject.has(keyMessage)) {
            valueMessage = jsonObject.getString(keyMessage);
        }
        if (jsonObject.has(keyResult)) {
            JSONObject valueResult = jsonObject.getJSONObject(keyResult);
            valueText = valueResult.getString(keyText);
        }
        return new Result(this.sourceLanguage, this.targetLanguage, this.text, valueText, valueCode, valueMessage, false, false, 192, null);
    }

    public /* synthetic */ HiTranslator(String sourceLanguage, String targetLanguage, String text, String appKey, String secret, DefaultConstructorMarker $constructor_marker) {
        this(sourceLanguage, targetLanguage, text, appKey, secret);
    }

    public static final /* synthetic */ String access$getText$p(HiTranslator $this) {
        return $this.text;
    }

    public static final /* synthetic */ String access$getSourceLanguage$p(HiTranslator $this) {
        return $this.sourceLanguage;
    }

    public static final /* synthetic */ String access$getTargetLanguage$p(HiTranslator $this) {
        return $this.targetLanguage;
    }

    public static final /* synthetic */ String access$getAppKey$p(HiTranslator $this) {
        return $this.appKey;
    }

    public static final /* synthetic */ ApiService access$getApiService(HiTranslator $this) {
        return $this.getApiService();
    }

    public static final /* synthetic */ Cache access$provideCache(HiTranslator $this) {
        return $this.provideCache();
    }

    static {
        boolean bl = false;
        HashMap hashMap = new HashMap();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap $this$supportLanguageMap_u24lambda_u2d0 = hashMap;
        boolean bl4 = false;
        Map map2 = $this$supportLanguageMap_u24lambda_u2d0;
        String string = "auto";
        String string2 = "auto";
        boolean bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "af";
        string2 = "af";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sq";
        string2 = "sq";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "am";
        string2 = "am";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ar";
        string2 = "ar";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "hy";
        string2 = "hy";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "az";
        string2 = "az";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "eu";
        string2 = "eu";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "be";
        string2 = "be";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "bn";
        string2 = "bn";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "bs";
        string2 = "bs";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "bg";
        string2 = "bg";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ca";
        string2 = "ca";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ceb";
        string2 = "ceb";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "zh";
        string2 = "zh";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "zh-TW";
        string2 = "zh-TW";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "co";
        string2 = "co";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "hr";
        string2 = "hr";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "cs";
        string2 = "cs";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "da";
        string2 = "da";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "nl";
        string2 = "nl";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "en";
        string2 = "en";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "eo";
        string2 = "eo";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "et";
        string2 = "et";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "fi";
        string2 = "fi";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "fr";
        string2 = "fr";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "fy";
        string2 = "fy";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "gl";
        string2 = "gl";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ka";
        string2 = "ka";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "de";
        string2 = "de";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "el";
        string2 = "el";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "gu";
        string2 = "gu";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ht";
        string2 = "ht";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ha";
        string2 = "ha";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "haw";
        string2 = "haw";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "he";
        string2 = "he";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "hi";
        string2 = "hi";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "hmn";
        string2 = "hmn";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "hu";
        string2 = "hu";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "is";
        string2 = "is";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ig";
        string2 = "ig";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "id";
        string2 = "id";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ga";
        string2 = "ga";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "it";
        string2 = "it";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ja";
        string2 = "ja";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "jv";
        string2 = "jv";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "kn";
        string2 = "kn";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "kk";
        string2 = "kk";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "km";
        string2 = "km";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "rw";
        string2 = "rw";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ko";
        string2 = "ko";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ku";
        string2 = "ku";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ky";
        string2 = "ky";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "lo";
        string2 = "lo";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "la";
        string2 = "la";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "lv";
        string2 = "lv";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "lt";
        string2 = "lt";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "lb";
        string2 = "lb";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "mk";
        string2 = "mk";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "mg";
        string2 = "mg";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ms";
        string2 = "ms";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ml";
        string2 = "ml";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "mt";
        string2 = "mt";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "mi";
        string2 = "mi";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "mr";
        string2 = "mr";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "mn";
        string2 = "mn";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "my";
        string2 = "my";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ne";
        string2 = "ne";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "no";
        string2 = "no";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ny";
        string2 = "ny";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "or";
        string2 = "or";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ps";
        string2 = "ps";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "fa";
        string2 = "fa";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "pl";
        string2 = "pl";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "pt";
        string2 = "pt";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "pa";
        string2 = "pa";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ro";
        string2 = "ro";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ru";
        string2 = "ru";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sm";
        string2 = "sm";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "gd";
        string2 = "gd";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sr";
        string2 = "sr";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "st";
        string2 = "st";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sn";
        string2 = "sn";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sd";
        string2 = "sd";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "si";
        string2 = "si";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sk";
        string2 = "sk";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sl";
        string2 = "sl";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "so";
        string2 = "so";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "es";
        string2 = "es";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "su";
        string2 = "su";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sw";
        string2 = "sw";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sv";
        string2 = "sv";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "tl";
        string2 = "tl";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "fil";
        string2 = "tl";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "tg";
        string2 = "tg";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ta";
        string2 = "ta";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "tt";
        string2 = "tt";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "te";
        string2 = "te";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "th";
        string2 = "th";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "tr";
        string2 = "tr";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "tk";
        string2 = "tk";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "uk";
        string2 = "uk";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ur";
        string2 = "ur";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ug";
        string2 = "ug";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "uz";
        string2 = "uz";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "vi";
        string2 = "vi";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "cy";
        string2 = "cy";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "xh";
        string2 = "xh";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "yi";
        string2 = "yi";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "yo";
        string2 = "yo";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "zu";
        string2 = "zu";
        bl5 = false;
        map2.put(string, string2);
        supportLanguageMap = hashMap;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/talpa/translate/HiTranslator$HttpLogger;", "Lokhttp3/logging/HttpLoggingInterceptor$Logger;", "()V", "log", "", "message", "", "translator-link_release"})
    public static final class HttpLogger
    implements HttpLoggingInterceptor.Logger {
        public void log(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Log.d((String)"okhttp", (String)message);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\u00020\u00032\u0019\b\u0001\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u00070\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\t"}, d2={"Lcom/talpa/translate/HiTranslator$ApiService;", "", "translate", "Lcom/talpa/translate/HiTranslator$TransResult;", "transRequest", "", "", "Lkotlin/jvm/JvmSuppressWildcards;", "(Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "translator-link_release"})
    @Keep
    public static interface ApiService {
        @POST(value="/v2/translate")
        @Nullable
        public Object translate(@Body @NotNull Map<String, Object> var1, @NotNull Continuation<? super TransResult> var2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\r\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/talpa/translate/HiTranslator$Builder;", "", "()V", "appKey", "", "secret", "sourceLanguage", "targetLanguage", "text", "build", "Lcom/talpa/translate/HiTranslator;", "setAppKey", "setSecret", "setSourceLanguage", "setTargetLanguage", "setText", "translator-link_release"})
    public static final class Builder {
        @Nullable
        private String sourceLanguage;
        @Nullable
        private String targetLanguage;
        @Nullable
        private String text;
        @Nullable
        private String appKey;
        @Nullable
        private String secret;

        @NotNull
        public final Builder setSourceLanguage(@Nullable String sourceLanguage) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setSourceLanguage_u24lambda_u2d0 = builder;
            boolean bl3 = false;
            $this$setSourceLanguage_u24lambda_u2d0.sourceLanguage = sourceLanguage;
            return builder;
        }

        @NotNull
        public final Builder setTargetLanguage(@NotNull String targetLanguage) {
            Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTargetLanguage_u24lambda_u2d1 = builder;
            boolean bl3 = false;
            $this$setTargetLanguage_u24lambda_u2d1.targetLanguage = targetLanguage;
            return builder;
        }

        @NotNull
        public final Builder setText(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setText_u24lambda_u2d2 = builder;
            boolean bl3 = false;
            $this$setText_u24lambda_u2d2.text = text;
            return builder;
        }

        @NotNull
        public final Builder setAppKey(@NotNull String appKey) {
            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setAppKey_u24lambda_u2d3 = builder;
            boolean bl3 = false;
            $this$setAppKey_u24lambda_u2d3.appKey = appKey;
            return builder;
        }

        @NotNull
        public final Builder setSecret(@NotNull String secret) {
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setSecret_u24lambda_u2d4 = builder;
            boolean bl3 = false;
            $this$setSecret_u24lambda_u2d4.secret = secret;
            return builder;
        }

        @NotNull
        public final HiTranslator build() {
            String string = this.targetLanguage;
            if (string == null) {
                throw new NullPointerException("targetLanguage can`t null.");
            }
            string = this.text;
            if (string == null) {
                throw new NullPointerException("text can`t null.");
            }
            string = this.appKey;
            if (string == null) {
                throw new NullPointerException("key can`t null.");
            }
            string = this.secret;
            if (string == null) {
                throw new NullPointerException("secret can`t null.");
            }
            String string2 = this.targetLanguage;
            Intrinsics.checkNotNull((Object)string2);
            String string3 = this.text;
            Intrinsics.checkNotNull((Object)string3);
            String string4 = this.appKey;
            Intrinsics.checkNotNull((Object)string4);
            String string5 = this.secret;
            Intrinsics.checkNotNull((Object)string5);
            return new HiTranslator(this.sourceLanguage, string2, string3, string4, string5, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0019\b\u0087\b\u0018\u00002\u00020\u0001BS\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u000bH\u00c6\u0003J_\u0010\u001f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\bH\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000eR\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/talpa/translate/HiTranslator$Result;", "", "sourceLanguage", "", "targetLanguage", "text", "translation", "valueCode", "", "valueMessage", "isCache", "", "isSuccess", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;ZZ)V", "()Z", "getSourceLanguage", "()Ljava/lang/String;", "getTargetLanguage", "getText", "getTranslation", "getValueCode", "()I", "getValueMessage", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "translator-link_release"})
    @Keep
    public static final class Result {
        @Nullable
        private final String sourceLanguage;
        @NotNull
        private final String targetLanguage;
        @NotNull
        private final String text;
        @Nullable
        private final String translation;
        private final int valueCode;
        @Nullable
        private final String valueMessage;
        private final boolean isCache;
        private final boolean isSuccess;

        public Result(@Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull String text, @Nullable String translation, int valueCode, @Nullable String valueMessage, boolean isCache, boolean isSuccess) {
            Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.sourceLanguage = sourceLanguage;
            this.targetLanguage = targetLanguage;
            this.text = text;
            this.translation = translation;
            this.valueCode = valueCode;
            this.valueMessage = valueMessage;
            this.isCache = isCache;
            this.isSuccess = isSuccess;
        }

        public /* synthetic */ Result(String string, String string2, String string3, String string4, int n, String string5, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                string5 = null;
            }
            if ((n2 & 0x40) != 0) {
                bl = false;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = n == 1000;
            }
            this(string, string2, string3, string4, n, string5, bl, bl2);
        }

        @Nullable
        public final String getSourceLanguage() {
            return this.sourceLanguage;
        }

        @NotNull
        public final String getTargetLanguage() {
            return this.targetLanguage;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final String getTranslation() {
            return this.translation;
        }

        public final int getValueCode() {
            return this.valueCode;
        }

        @Nullable
        public final String getValueMessage() {
            return this.valueMessage;
        }

        public final boolean isCache() {
            return this.isCache;
        }

        public final boolean isSuccess() {
            return this.isSuccess;
        }

        @Nullable
        public final String component1() {
            return this.sourceLanguage;
        }

        @NotNull
        public final String component2() {
            return this.targetLanguage;
        }

        @NotNull
        public final String component3() {
            return this.text;
        }

        @Nullable
        public final String component4() {
            return this.translation;
        }

        public final int component5() {
            return this.valueCode;
        }

        @Nullable
        public final String component6() {
            return this.valueMessage;
        }

        public final boolean component7() {
            return this.isCache;
        }

        public final boolean component8() {
            return this.isSuccess;
        }

        @NotNull
        public final Result copy(@Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull String text, @Nullable String translation, int valueCode, @Nullable String valueMessage, boolean isCache, boolean isSuccess) {
            Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new Result(sourceLanguage, targetLanguage, text, translation, valueCode, valueMessage, isCache, isSuccess);
        }

        public static /* synthetic */ Result copy$default(Result result, String string, String string2, String string3, String string4, int n, String string5, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = result.sourceLanguage;
            }
            if ((n2 & 2) != 0) {
                string2 = result.targetLanguage;
            }
            if ((n2 & 4) != 0) {
                string3 = result.text;
            }
            if ((n2 & 8) != 0) {
                string4 = result.translation;
            }
            if ((n2 & 0x10) != 0) {
                n = result.valueCode;
            }
            if ((n2 & 0x20) != 0) {
                string5 = result.valueMessage;
            }
            if ((n2 & 0x40) != 0) {
                bl = result.isCache;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = result.isSuccess;
            }
            return result.copy(string, string2, string3, string4, n, string5, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Result(sourceLanguage=" + this.sourceLanguage + ", targetLanguage=" + this.targetLanguage + ", text=" + this.text + ", translation=" + this.translation + ", valueCode=" + this.valueCode + ", valueMessage=" + this.valueMessage + ", isCache=" + this.isCache + ", isSuccess=" + this.isSuccess + ')';
        }

        public int hashCode() {
            int result = this.sourceLanguage == null ? 0 : this.sourceLanguage.hashCode();
            result = result * 31 + this.targetLanguage.hashCode();
            result = result * 31 + this.text.hashCode();
            result = result * 31 + (this.translation == null ? 0 : this.translation.hashCode());
            result = result * 31 + Integer.hashCode(this.valueCode);
            result = result * 31 + (this.valueMessage == null ? 0 : this.valueMessage.hashCode());
            int n = this.isCache ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.isSuccess ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (!Intrinsics.areEqual((Object)this.sourceLanguage, (Object)result.sourceLanguage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.targetLanguage, (Object)result.targetLanguage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.text, (Object)result.text)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.translation, (Object)result.translation)) {
                return false;
            }
            if (this.valueCode != result.valueCode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.valueMessage, (Object)result.valueMessage)) {
                return false;
            }
            if (this.isCache != result.isCache) {
                return false;
            }
            return this.isSuccess == result.isSuccess;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/talpa/translate/HiTranslator$TransResult;", "", "code", "", "message", "", "result", "Lcom/talpa/translate/HiTranslator$ResultV2;", "(ILjava/lang/String;Lcom/talpa/translate/HiTranslator$ResultV2;)V", "getCode", "()I", "setCode", "(I)V", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "getResult", "()Lcom/talpa/translate/HiTranslator$ResultV2;", "setResult", "(Lcom/talpa/translate/HiTranslator$ResultV2;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "translator-link_release"})
    @Keep
    public static final class TransResult {
        private int code;
        @NotNull
        private String message;
        @Nullable
        private ResultV2 result;

        public TransResult(int code, @NotNull String message, @Nullable ResultV2 result) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.code = code;
            this.message = message;
            this.result = result;
        }

        public /* synthetic */ TransResult(int n, String string, ResultV2 resultV2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                string = "";
            }
            if ((n2 & 4) != 0) {
                resultV2 = null;
            }
            this(n, string, resultV2);
        }

        public final int getCode() {
            return this.code;
        }

        public final void setCode(int n) {
            this.code = n;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.message = string;
        }

        @Nullable
        public final ResultV2 getResult() {
            return this.result;
        }

        public final void setResult(@Nullable ResultV2 resultV2) {
            this.result = resultV2;
        }

        public final int component1() {
            return this.code;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @Nullable
        public final ResultV2 component3() {
            return this.result;
        }

        @NotNull
        public final TransResult copy(int code, @NotNull String message, @Nullable ResultV2 result) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new TransResult(code, message, result);
        }

        public static /* synthetic */ TransResult copy$default(TransResult transResult, int n, String string, ResultV2 resultV2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = transResult.code;
            }
            if ((n2 & 2) != 0) {
                string = transResult.message;
            }
            if ((n2 & 4) != 0) {
                resultV2 = transResult.result;
            }
            return transResult.copy(n, string, resultV2);
        }

        @NotNull
        public String toString() {
            return "TransResult(code=" + this.code + ", message=" + this.message + ", result=" + this.result + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.code);
            result = result * 31 + this.message.hashCode();
            result = result * 31 + (this.result == null ? 0 : this.result.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TransResult)) {
                return false;
            }
            TransResult transResult = (TransResult)other;
            if (this.code != transResult.code) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)transResult.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.result, (Object)transResult.result);
        }

        public TransResult() {
            this(0, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lcom/talpa/translate/HiTranslator$ResultV2;", "", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "setText", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "translator-link_release"})
    @Keep
    public static final class ResultV2 {
        @Nullable
        private String text;

        public ResultV2(@Nullable String text) {
            this.text = text;
        }

        public /* synthetic */ ResultV2(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        @Nullable
        public final String getText() {
            return this.text;
        }

        public final void setText(@Nullable String string) {
            this.text = string;
        }

        @Nullable
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final ResultV2 copy(@Nullable String text) {
            return new ResultV2(text);
        }

        public static /* synthetic */ ResultV2 copy$default(ResultV2 resultV2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = resultV2.text;
            }
            return resultV2.copy(string);
        }

        @NotNull
        public String toString() {
            return "ResultV2(text=" + this.text + ')';
        }

        public int hashCode() {
            return this.text == null ? 0 : this.text.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResultV2)) {
                return false;
            }
            ResultV2 resultV2 = (ResultV2)other;
            return Intrinsics.areEqual((Object)this.text, (Object)resultV2.text);
        }

        public ResultV2() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R-\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/talpa/translate/HiTranslator$Companion;", "", "()V", "BASE_URL", "", "CONNECT_TIME_OUT", "", "CONTENT_TYPE", "READ_TIME_OUT", "REQUEST_METHOD", "supportLanguageMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getSupportLanguageMap", "()Ljava/util/HashMap;", "translator-link_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashMap<String, String> getSupportLanguageMap() {
            return supportLanguageMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

