/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate;

import androidx.annotation.Keep;
import com.talpa.translate.Hex;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001d\u001e\u001fBA\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\fJ\b\u0010\u000e\u001a\u00020\u0003H\u0002J0\u0010\u000f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0003*\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/talpa/translate/MultiTextTranslator;", "", "sourceLanguage", "", "targetLanguage", "texts", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "appKey", "secret", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/ArrayList;Ljava/lang/String;Ljava/lang/String;)V", "connect", "Lcom/talpa/translate/MultiTextTranslator$Result;", "execute", "generateNonce", "generateSign", "timestamp", "", "nonce", "parserJson", "json", "readInputStream", "inputStream", "Ljava/io/InputStream;", "writeOutputStream", "", "outputStream", "Ljava/io/OutputStream;", "md5", "Builder", "Companion", "Result", "translator-link_release"})
@Keep
public final class MultiTextTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String sourceLanguage;
    @NotNull
    private final String targetLanguage;
    @NotNull
    private final ArrayList<String> texts;
    @NotNull
    private final String appKey;
    @NotNull
    private final String secret;
    @NotNull
    private static final String BASE_URL = "https://api.translasion.com/v2/translate";
    private static final int CONNECT_TIME_OUT = 6000;
    private static final int READ_TIME_OUT = 8000;
    @NotNull
    private static final String REQUEST_METHOD = "POST";
    @NotNull
    private static final String CONTENT_TYPE = "application/json";
    @NotNull
    private static final HashMap<String, String> supportLanguageMap;

    private MultiTextTranslator(String sourceLanguage, String targetLanguage, ArrayList<String> texts, String appKey, String secret) {
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.texts = texts;
        this.appKey = appKey;
        this.secret = secret;
    }

    @NotNull
    public final Result execute() {
        Result result = this.connect();
        return result;
    }

    private final Result connect() {
        URL url = new URL(BASE_URL);
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod(REQUEST_METHOD);
        connection.setRequestProperty("content-type", CONTENT_TYPE);
        connection.setConnectTimeout(6000);
        connection.setReadTimeout(8000);
        connection.setDefaultUseCaches(true);
        connection.setDoOutput(true);
        OutputStream outputStream = connection.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
        this.writeOutputStream(outputStream);
        outputStream.close();
        InputStream inputStream = connection.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
        Result result = this.readInputStream(inputStream);
        inputStream.close();
        connection.disconnect();
        return result;
    }

    private final void writeOutputStream(OutputStream outputStream) {
        String json;
        long timestamp = System.currentTimeMillis() / (long)1000;
        String nonce = this.generateNonce();
        String sig = this.generateSign(this.appKey, this.targetLanguage, timestamp, this.secret, nonce);
        JSONArray textsArray = new JSONArray((Collection)this.texts);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("app_key", (Object)this.appKey);
        jsonObj.put("to", (Object)this.targetLanguage);
        jsonObj.put("texts", (Object)textsArray);
        jsonObj.put("timestamp", timestamp);
        jsonObj.put("nonce", (Object)nonce);
        jsonObj.put("sig", (Object)sig);
        if (this.sourceLanguage != null) {
            jsonObj.put("from", (Object)this.sourceLanguage);
        }
        String string = jsonObj.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObj.toString()");
        string = json = string;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        outputStream.write(byArray);
        outputStream.flush();
    }

    private final String generateNonce() {
        Object[] objectArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
        Object[] charArray = objectArray;
        IntRange intRange = ArraysKt.getIndices((Object[])charArray);
        boolean bl = false;
        int index1 = RangesKt.random((IntRange)intRange, (Random)((Random)Random.Default));
        IntRange intRange2 = ArraysKt.getIndices((Object[])charArray);
        boolean bl2 = false;
        int index2 = RangesKt.random((IntRange)intRange2, (Random)((Random)Random.Default));
        IntRange intRange3 = ArraysKt.getIndices((Object[])charArray);
        boolean bl3 = false;
        int index3 = RangesKt.random((IntRange)intRange3, (Random)((Random)Random.Default));
        IntRange intRange4 = ArraysKt.getIndices((Object[])charArray);
        boolean bl4 = false;
        int index4 = RangesKt.random((IntRange)intRange4, (Random)((Random)Random.Default));
        return "" + ((Character)charArray[index1]).charValue() + ((Character)charArray[index2]).charValue() + ((Character)charArray[index3]).charValue() + ((Character)charArray[index4]).charValue();
    }

    private final String generateSign(String appKey, String targetLanguage, long timestamp, String secret, String nonce) {
        String value = appKey + '&' + targetLanguage + '&' + timestamp + '&' + secret + '&' + nonce;
        return this.md5(value);
    }

    private final String md5(String $this$md5) {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String string = $this$md5;
        Object object = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] data = digest.digest(byArray);
        char[] charArray = Hex.encodeHex(data);
        Intrinsics.checkNotNullExpressionValue((Object)charArray, (String)"charArray");
        object = charArray;
        bl = false;
        return new String((char[])object);
    }

    private final Result readInputStream(InputStream inputStream) {
        byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        boolean bl = false;
        String content = new String(bytes, Charsets.UTF_8);
        return this.parserJson(content);
    }

    private final Result parserJson(String json) {
        int n;
        JSONObject jsonObject = new JSONObject(json);
        String keyCode = "code";
        String keyMessage = "message";
        String keyResult = "result";
        String keyText = "texts";
        int valueCode = 0;
        String valueMessage = null;
        JSONArray valueTexts = null;
        if (jsonObject.has(keyCode)) {
            valueCode = jsonObject.getInt(keyCode);
        }
        if (jsonObject.has(keyMessage)) {
            valueMessage = jsonObject.getString(keyMessage);
        }
        if (jsonObject.has(keyResult)) {
            JSONObject valueResult = jsonObject.getJSONObject(keyResult);
            valueTexts = valueResult.getJSONArray(keyText);
        }
        boolean bl = false;
        ArrayList<String> translations = new ArrayList<String>();
        int n2 = 0;
        JSONArray jSONArray = valueTexts;
        int length = jSONArray == null ? 0 : (n = jSONArray.length());
        if (n2 < length) {
            do {
                String string;
                int index = n2++;
                JSONArray jSONArray2 = valueTexts;
                String string2 = string = jSONArray2 == null ? null : jSONArray2.getString(index);
                if (string == null) continue;
                String value = string;
                translations.add(value);
            } while (n2 < length);
        }
        return new Result(this.sourceLanguage, this.targetLanguage, this.texts, translations, valueCode, valueMessage, false, false, 192, null);
    }

    public /* synthetic */ MultiTextTranslator(String sourceLanguage, String targetLanguage, ArrayList texts, String appKey, String secret, DefaultConstructorMarker $constructor_marker) {
        this(sourceLanguage, targetLanguage, texts, appKey, secret);
    }

    static {
        boolean bl = false;
        HashMap hashMap = new HashMap();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap $this$supportLanguageMap_u24lambda_u2d0 = hashMap;
        boolean bl4 = false;
        Map map2 = $this$supportLanguageMap_u24lambda_u2d0;
        String string = "auto";
        String string2 = "auto";
        boolean bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "af";
        string2 = "af";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sq";
        string2 = "sq";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "am";
        string2 = "am";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ar";
        string2 = "ar";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "hy";
        string2 = "hy";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "az";
        string2 = "az";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "eu";
        string2 = "eu";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "be";
        string2 = "be";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "bn";
        string2 = "bn";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "bs";
        string2 = "bs";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "bg";
        string2 = "bg";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ca";
        string2 = "ca";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ceb";
        string2 = "ceb";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "zh";
        string2 = "zh";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "zh-TW";
        string2 = "zh-TW";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "co";
        string2 = "co";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "hr";
        string2 = "hr";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "cs";
        string2 = "cs";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "da";
        string2 = "da";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "nl";
        string2 = "nl";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "en";
        string2 = "en";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "eo";
        string2 = "eo";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "et";
        string2 = "et";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "fi";
        string2 = "fi";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "fr";
        string2 = "fr";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "fy";
        string2 = "fy";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "gl";
        string2 = "gl";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ka";
        string2 = "ka";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "de";
        string2 = "de";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "el";
        string2 = "el";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "gu";
        string2 = "gu";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ht";
        string2 = "ht";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ha";
        string2 = "ha";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "haw";
        string2 = "haw";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "he";
        string2 = "he";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "hi";
        string2 = "hi";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "hmn";
        string2 = "hmn";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "hu";
        string2 = "hu";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "is";
        string2 = "is";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ig";
        string2 = "ig";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "id";
        string2 = "id";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ga";
        string2 = "ga";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "it";
        string2 = "it";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ja";
        string2 = "ja";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "jv";
        string2 = "jv";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "kn";
        string2 = "kn";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "kk";
        string2 = "kk";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "km";
        string2 = "km";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "rw";
        string2 = "rw";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ko";
        string2 = "ko";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ku";
        string2 = "ku";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ky";
        string2 = "ky";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "lo";
        string2 = "lo";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "la";
        string2 = "la";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "lv";
        string2 = "lv";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "lt";
        string2 = "lt";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "lb";
        string2 = "lb";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "mk";
        string2 = "mk";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "mg";
        string2 = "mg";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ms";
        string2 = "ms";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ml";
        string2 = "ml";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "mt";
        string2 = "mt";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "mi";
        string2 = "mi";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "mr";
        string2 = "mr";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "mn";
        string2 = "mn";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "my";
        string2 = "my";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ne";
        string2 = "ne";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "no";
        string2 = "no";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ny";
        string2 = "ny";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "or";
        string2 = "or";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ps";
        string2 = "ps";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "fa";
        string2 = "fa";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "pl";
        string2 = "pl";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "pt";
        string2 = "pt";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "pa";
        string2 = "pa";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ro";
        string2 = "ro";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ru";
        string2 = "ru";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sm";
        string2 = "sm";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "gd";
        string2 = "gd";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sr";
        string2 = "sr";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "st";
        string2 = "st";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sn";
        string2 = "sn";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sd";
        string2 = "sd";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "si";
        string2 = "si";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sk";
        string2 = "sk";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sl";
        string2 = "sl";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "so";
        string2 = "so";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "es";
        string2 = "es";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "su";
        string2 = "su";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sw";
        string2 = "sw";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "sv";
        string2 = "sv";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "tl";
        string2 = "tl";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "tg";
        string2 = "tg";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ta";
        string2 = "ta";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "tt";
        string2 = "tt";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "te";
        string2 = "te";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "th";
        string2 = "th";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "tr";
        string2 = "tr";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "tk";
        string2 = "tk";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "uk";
        string2 = "uk";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ur";
        string2 = "ur";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "ug";
        string2 = "ug";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "uz";
        string2 = "uz";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "vi";
        string2 = "vi";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "cy";
        string2 = "cy";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "xh";
        string2 = "xh";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "yi";
        string2 = "yi";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "yo";
        string2 = "yo";
        bl5 = false;
        map2.put(string, string2);
        map2 = $this$supportLanguageMap_u24lambda_u2d0;
        string = "zu";
        string2 = "zu";
        bl5 = false;
        map2.put(string, string2);
        supportLanguageMap = hashMap;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u0011\u001a\u00020\u00002\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00040\tj\b\u0012\u0004\u0012\u00020\u0004`\nR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0018\u00010\tj\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/talpa/translate/MultiTextTranslator$Builder;", "", "()V", "appKey", "", "secret", "sourceLanguage", "targetLanguage", "texts", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "build", "Lcom/talpa/translate/MultiTextTranslator;", "setAppKey", "setSecret", "setSourceLanguage", "setTargetLanguage", "setTexts", "translator-link_release"})
    public static final class Builder {
        @Nullable
        private String sourceLanguage;
        @Nullable
        private String targetLanguage;
        @Nullable
        private ArrayList<String> texts;
        @Nullable
        private String appKey;
        @Nullable
        private String secret;

        @NotNull
        public final Builder setSourceLanguage(@Nullable String sourceLanguage) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setSourceLanguage_u24lambda_u2d0 = builder;
            boolean bl3 = false;
            $this$setSourceLanguage_u24lambda_u2d0.sourceLanguage = sourceLanguage;
            return builder;
        }

        @NotNull
        public final Builder setTargetLanguage(@NotNull String targetLanguage) {
            Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTargetLanguage_u24lambda_u2d1 = builder;
            boolean bl3 = false;
            $this$setTargetLanguage_u24lambda_u2d1.targetLanguage = targetLanguage;
            return builder;
        }

        @NotNull
        public final Builder setTexts(@NotNull ArrayList<String> texts) {
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTexts_u24lambda_u2d2 = builder;
            boolean bl3 = false;
            $this$setTexts_u24lambda_u2d2.texts = texts;
            return builder;
        }

        @NotNull
        public final Builder setAppKey(@NotNull String appKey) {
            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setAppKey_u24lambda_u2d3 = builder;
            boolean bl3 = false;
            $this$setAppKey_u24lambda_u2d3.appKey = appKey;
            return builder;
        }

        @NotNull
        public final Builder setSecret(@NotNull String secret) {
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setSecret_u24lambda_u2d4 = builder;
            boolean bl3 = false;
            $this$setSecret_u24lambda_u2d4.secret = secret;
            return builder;
        }

        @NotNull
        public final MultiTextTranslator build() {
            Object object = this.targetLanguage;
            if (object == null) {
                throw new NullPointerException("targetLanguage can`t null.");
            }
            object = this.texts;
            if (object == null) {
                throw new NullPointerException("text can`t null.");
            }
            object = this.appKey;
            if (object == null) {
                throw new NullPointerException("key can`t null.");
            }
            object = this.secret;
            if (object == null) {
                throw new NullPointerException("secret can`t null.");
            }
            String string = this.targetLanguage;
            Intrinsics.checkNotNull((Object)string);
            ArrayList<String> arrayList = this.texts;
            Intrinsics.checkNotNull(arrayList);
            String string2 = this.appKey;
            Intrinsics.checkNotNull((Object)string2);
            String string3 = this.secret;
            Intrinsics.checkNotNull((Object)string3);
            return new MultiTextTranslator(this.sourceLanguage, string, arrayList, string2, string3, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001b\b\u0086\b\u0018\u00002\u00020\u0001Bi\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u0019\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\t\u0010 \u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u000eH\u00c6\u0003J\t\u0010#\u001a\u00020\u000eH\u00c6\u0003Js\u0010$\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0018\b\u0002\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010%\u001a\u00020\u000e2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u000bH\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0011R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/talpa/translate/MultiTextTranslator$Result;", "", "sourceLanguage", "", "targetLanguage", "texts", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "translations", "", "valueCode", "", "valueMessage", "isCache", "", "isSuccess", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/ArrayList;Ljava/util/List;ILjava/lang/String;ZZ)V", "()Z", "getSourceLanguage", "()Ljava/lang/String;", "getTargetLanguage", "getTexts", "()Ljava/util/ArrayList;", "getTranslations", "()Ljava/util/List;", "getValueCode", "()I", "getValueMessage", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "translator-link_release"})
    public static final class Result {
        @Nullable
        private final String sourceLanguage;
        @NotNull
        private final String targetLanguage;
        @NotNull
        private final ArrayList<String> texts;
        @NotNull
        private final List<String> translations;
        private final int valueCode;
        @Nullable
        private final String valueMessage;
        private final boolean isCache;
        private final boolean isSuccess;

        public Result(@Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull ArrayList<String> texts, @NotNull List<String> translations, int valueCode, @Nullable String valueMessage, boolean isCache, boolean isSuccess) {
            Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            Intrinsics.checkNotNullParameter(translations, (String)"translations");
            this.sourceLanguage = sourceLanguage;
            this.targetLanguage = targetLanguage;
            this.texts = texts;
            this.translations = translations;
            this.valueCode = valueCode;
            this.valueMessage = valueMessage;
            this.isCache = isCache;
            this.isSuccess = isSuccess;
        }

        public /* synthetic */ Result(String string, String string2, ArrayList arrayList, List list, int n, String string3, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                string3 = null;
            }
            if ((n2 & 0x40) != 0) {
                bl = false;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = n == 1000;
            }
            this(string, string2, arrayList, list, n, string3, bl, bl2);
        }

        @Nullable
        public final String getSourceLanguage() {
            return this.sourceLanguage;
        }

        @NotNull
        public final String getTargetLanguage() {
            return this.targetLanguage;
        }

        @NotNull
        public final ArrayList<String> getTexts() {
            return this.texts;
        }

        @NotNull
        public final List<String> getTranslations() {
            return this.translations;
        }

        public final int getValueCode() {
            return this.valueCode;
        }

        @Nullable
        public final String getValueMessage() {
            return this.valueMessage;
        }

        public final boolean isCache() {
            return this.isCache;
        }

        public final boolean isSuccess() {
            return this.isSuccess;
        }

        @Nullable
        public final String component1() {
            return this.sourceLanguage;
        }

        @NotNull
        public final String component2() {
            return this.targetLanguage;
        }

        @NotNull
        public final ArrayList<String> component3() {
            return this.texts;
        }

        @NotNull
        public final List<String> component4() {
            return this.translations;
        }

        public final int component5() {
            return this.valueCode;
        }

        @Nullable
        public final String component6() {
            return this.valueMessage;
        }

        public final boolean component7() {
            return this.isCache;
        }

        public final boolean component8() {
            return this.isSuccess;
        }

        @NotNull
        public final Result copy(@Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull ArrayList<String> texts, @NotNull List<String> translations, int valueCode, @Nullable String valueMessage, boolean isCache, boolean isSuccess) {
            Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            Intrinsics.checkNotNullParameter(translations, (String)"translations");
            return new Result(sourceLanguage, targetLanguage, texts, translations, valueCode, valueMessage, isCache, isSuccess);
        }

        public static /* synthetic */ Result copy$default(Result result, String string, String string2, ArrayList arrayList, List list, int n, String string3, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = result.sourceLanguage;
            }
            if ((n2 & 2) != 0) {
                string2 = result.targetLanguage;
            }
            if ((n2 & 4) != 0) {
                arrayList = result.texts;
            }
            if ((n2 & 8) != 0) {
                list = result.translations;
            }
            if ((n2 & 0x10) != 0) {
                n = result.valueCode;
            }
            if ((n2 & 0x20) != 0) {
                string3 = result.valueMessage;
            }
            if ((n2 & 0x40) != 0) {
                bl = result.isCache;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = result.isSuccess;
            }
            return result.copy(string, string2, arrayList, list, n, string3, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Result(sourceLanguage=" + this.sourceLanguage + ", targetLanguage=" + this.targetLanguage + ", texts=" + this.texts + ", translations=" + this.translations + ", valueCode=" + this.valueCode + ", valueMessage=" + this.valueMessage + ", isCache=" + this.isCache + ", isSuccess=" + this.isSuccess + ')';
        }

        public int hashCode() {
            int result = this.sourceLanguage == null ? 0 : this.sourceLanguage.hashCode();
            result = result * 31 + this.targetLanguage.hashCode();
            result = result * 31 + this.texts.hashCode();
            result = result * 31 + ((Object)this.translations).hashCode();
            result = result * 31 + Integer.hashCode(this.valueCode);
            result = result * 31 + (this.valueMessage == null ? 0 : this.valueMessage.hashCode());
            int n = this.isCache ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.isSuccess ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (!Intrinsics.areEqual((Object)this.sourceLanguage, (Object)result.sourceLanguage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.targetLanguage, (Object)result.targetLanguage)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.texts, result.texts)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.translations, result.translations)) {
                return false;
            }
            if (this.valueCode != result.valueCode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.valueMessage, (Object)result.valueMessage)) {
                return false;
            }
            if (this.isCache != result.isCache) {
                return false;
            }
            return this.isSuccess == result.isSuccess;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R-\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/talpa/translate/MultiTextTranslator$Companion;", "", "()V", "BASE_URL", "", "CONNECT_TIME_OUT", "", "CONTENT_TYPE", "READ_TIME_OUT", "REQUEST_METHOD", "supportLanguageMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getSupportLanguageMap", "()Ljava/util/HashMap;", "translator-link_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashMap<String, String> getSupportLanguageMap() {
            return supportLanguageMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

