/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.text.TextUtils;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.conversation.Conversation;
import com.tencent.imsdk.conversation.ConversationKey;
import com.tencent.imsdk.conversation.ConversationListener;
import com.tencent.imsdk.conversation.ConversationManager;
import com.tencent.imsdk.conversation.ConversationOperationResult;
import com.tencent.imsdk.conversation.ConversationResult;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.message.DraftMessage;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMConversation;
import com.tencent.imsdk.v2.V2TIMConversationListFilter;
import com.tencent.imsdk.v2.V2TIMConversationListener;
import com.tencent.imsdk.v2.V2TIMConversationManager;
import com.tencent.imsdk.v2.V2TIMConversationOperationResult;
import com.tencent.imsdk.v2.V2TIMConversationResult;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class V2TIMConversationManagerImpl
extends V2TIMConversationManager {
    private ConversationListener mConversationListener;
    private V2TIMConversationListener mV2TIMConversationListener;
    private final List<V2TIMConversationListener> mV2TIMConversationListenerList = new ArrayList<V2TIMConversationListener>();

    static V2TIMConversationManagerImpl getInstance() {
        return V2TIMConversationManagerImplHolder.v2TIMConversationManagerImpl;
    }

    private V2TIMConversationManagerImpl() {
        this.initListener();
    }

    private void initListener() {
        if (this.mConversationListener == null) {
            this.mConversationListener = new ConversationListener(){

                @Override
                public void onSyncServerStart() {
                    for (V2TIMConversationListener listener : V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList) {
                        listener.onSyncServerStart();
                    }
                }

                @Override
                public void onSyncServerFinish() {
                    for (V2TIMConversationListener listener : V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList) {
                        listener.onSyncServerFinish();
                    }
                }

                @Override
                public void onSyncServerFailed() {
                    for (V2TIMConversationListener listener : V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList) {
                        listener.onSyncServerFailed();
                    }
                }

                @Override
                public void onNewConversation(List<Conversation> conversationList) {
                    ArrayList<V2TIMConversation> v2TIMConversationList = new ArrayList<V2TIMConversation>();
                    for (Conversation conversation : conversationList) {
                        V2TIMConversation v2TIMConversation = new V2TIMConversation();
                        v2TIMConversation.setConversation(conversation);
                        v2TIMConversationList.add(v2TIMConversation);
                    }
                    List<V2TIMConversation> unmodifiableList = Collections.unmodifiableList(v2TIMConversationList);
                    for (V2TIMConversationListener listener : V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList) {
                        listener.onNewConversation(unmodifiableList);
                    }
                }

                @Override
                public void onConversationChanged(List<Conversation> conversationList) {
                    ArrayList<V2TIMConversation> v2TIMConversationList = new ArrayList<V2TIMConversation>();
                    for (Conversation conversation : conversationList) {
                        V2TIMConversation v2TIMConversation = new V2TIMConversation();
                        v2TIMConversation.setConversation(conversation);
                        v2TIMConversationList.add(v2TIMConversation);
                    }
                    List<V2TIMConversation> unmodifiableList = Collections.unmodifiableList(v2TIMConversationList);
                    for (V2TIMConversationListener listener : V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList) {
                        listener.onConversationChanged(unmodifiableList);
                    }
                }

                @Override
                public void onTotalUnreadMessageCountChanged(long totalUnreadCount) {
                    for (V2TIMConversationListener listener : V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList) {
                        listener.onTotalUnreadMessageCountChanged(totalUnreadCount);
                    }
                }

                @Override
                public void onConversationGroupCreated(String groupName, List<Conversation> conversationList) {
                    ArrayList<V2TIMConversation> v2TIMConversationList = new ArrayList<V2TIMConversation>();
                    for (Conversation conversation : conversationList) {
                        V2TIMConversation v2TIMConversation = new V2TIMConversation();
                        v2TIMConversation.setConversation(conversation);
                        v2TIMConversationList.add(v2TIMConversation);
                    }
                    List<V2TIMConversation> unmodifiableList = Collections.unmodifiableList(v2TIMConversationList);
                    for (V2TIMConversationListener listener : V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList) {
                        listener.onConversationGroupCreated(groupName, unmodifiableList);
                    }
                }

                @Override
                public void onConversationGroupDeleted(String groupName) {
                    for (V2TIMConversationListener listener : V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList) {
                        listener.onConversationGroupDeleted(groupName);
                    }
                }

                @Override
                public void onConversationGroupNameChanged(String oldName, String newName) {
                    for (V2TIMConversationListener listener : V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList) {
                        listener.onConversationGroupNameChanged(oldName, newName);
                    }
                }

                @Override
                public void onConversationsAddedToGroup(String groupName, List<Conversation> conversationList) {
                    ArrayList<V2TIMConversation> v2TIMConversationList = new ArrayList<V2TIMConversation>();
                    for (Conversation conversation : conversationList) {
                        V2TIMConversation v2TIMConversation = new V2TIMConversation();
                        v2TIMConversation.setConversation(conversation);
                        v2TIMConversationList.add(v2TIMConversation);
                    }
                    List<V2TIMConversation> unmodifiableList = Collections.unmodifiableList(v2TIMConversationList);
                    for (V2TIMConversationListener listener : V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList) {
                        listener.onConversationsAddedToGroup(groupName, unmodifiableList);
                    }
                }

                @Override
                public void onConversationsDeletedFromGroup(String groupName, List<Conversation> conversationList) {
                    ArrayList<V2TIMConversation> v2TIMConversationList = new ArrayList<V2TIMConversation>();
                    for (Conversation conversation : conversationList) {
                        V2TIMConversation v2TIMConversation = new V2TIMConversation();
                        v2TIMConversation.setConversation(conversation);
                        v2TIMConversationList.add(v2TIMConversation);
                    }
                    List<V2TIMConversation> unmodifiableList = Collections.unmodifiableList(v2TIMConversationList);
                    for (V2TIMConversationListener listener : V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList) {
                        listener.onConversationsDeletedFromGroup(groupName, unmodifiableList);
                    }
                }
            };
        }
        ConversationManager.getInstance().setConversationListener(this.mConversationListener);
    }

    @Override
    public void setConversationListener(final V2TIMConversationListener listener) {
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (V2TIMConversationManagerImpl.this.mV2TIMConversationListener != null) {
                    V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList.remove(V2TIMConversationManagerImpl.this.mV2TIMConversationListener);
                }
                if (listener != null) {
                    V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList.add(listener);
                }
                V2TIMConversationManagerImpl.this.mV2TIMConversationListener = listener;
            }
        });
    }

    @Override
    public void addConversationListener(final V2TIMConversationListener listener) {
        if (listener == null) {
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList.contains(listener)) {
                    return;
                }
                V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList.add(listener);
            }
        });
    }

    @Override
    public void removeConversationListener(final V2TIMConversationListener listener) {
        if (listener == null) {
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                V2TIMConversationManagerImpl.this.mV2TIMConversationListenerList.remove(listener);
            }
        });
    }

    @Override
    public void getConversationList(long nextSeq, int count, final V2TIMValueCallback<V2TIMConversationResult> callback) {
        if (count <= 0) {
            if (callback != null) {
                callback.onError(6017, "count is invalid");
            }
            return;
        }
        V2TIMValueCallback<ConversationResult> v2callback = new V2TIMValueCallback<ConversationResult>(){

            @Override
            public void onSuccess(ConversationResult conversationResult) {
                if (callback != null) {
                    V2TIMConversationResult v2TIMConversationResult = new V2TIMConversationResult();
                    v2TIMConversationResult.setConversationResult(conversationResult);
                    callback.onSuccess(v2TIMConversationResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().getConversationList(nextSeq, count, new IMCallback<ConversationResult>((V2TIMValueCallback)v2callback){

            @Override
            public void success(ConversationResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        BaseManager.getInstance().checkTUIComponent(2);
    }

    @Override
    public void getConversationListByFilter(V2TIMConversationListFilter filter, final V2TIMValueCallback<V2TIMConversationResult> callback) {
        if (filter == null) {
            if (callback != null) {
                callback.onError(6017, "filter is null");
            }
            return;
        }
        if (filter.getCount() <= 0) {
            if (callback != null) {
                callback.onError(6017, "count is invalid");
            }
            return;
        }
        V2TIMValueCallback<ConversationResult> v2callback = new V2TIMValueCallback<ConversationResult>(){

            @Override
            public void onSuccess(ConversationResult conversationResult) {
                if (callback != null) {
                    V2TIMConversationResult v2TIMConversationResult = new V2TIMConversationResult();
                    v2TIMConversationResult.setConversationResult(conversationResult);
                    callback.onSuccess(v2TIMConversationResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().getConversationListByFilter(filter.getConversationFilter(), new IMCallback<ConversationResult>((V2TIMValueCallback)v2callback){

            @Override
            public void success(ConversationResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getConversationList(List<String> conversationIDList, final V2TIMValueCallback<List<V2TIMConversation>> callback) {
        if (conversationIDList == null || conversationIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "conversationIDList cannot be empty");
            }
            return;
        }
        ArrayList<ConversationKey> conversationKeyList = new ArrayList<ConversationKey>();
        for (String conversationID : conversationIDList) {
            ConversationKey conversationKey = this.getConversationKey(conversationID);
            conversationKeyList.add(conversationKey);
        }
        V2TIMValueCallback<List<Conversation>> v2callback = new V2TIMValueCallback<List<Conversation>>(){

            @Override
            public void onSuccess(List<Conversation> conversations) {
                ArrayList<V2TIMConversation> v2TIMConversationList = new ArrayList<V2TIMConversation>();
                for (Conversation conversation : conversations) {
                    V2TIMConversation v2TIMConversation = new V2TIMConversation();
                    v2TIMConversation.setConversation(conversation);
                    v2TIMConversationList.add(v2TIMConversation);
                }
                if (callback != null) {
                    callback.onSuccess(v2TIMConversationList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().getConversationList(conversationKeyList, new IMCallback<List<Conversation>>((V2TIMValueCallback)v2callback){

            @Override
            public void success(List<Conversation> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getConversation(String conversationID, final V2TIMValueCallback<V2TIMConversation> callback) {
        if (TextUtils.isEmpty((CharSequence)conversationID)) {
            if (callback != null) {
                callback.onError(6017, "conversationID is empty");
            }
            return;
        }
        ConversationKey conversationKey = this.getConversationKey(conversationID);
        V2TIMValueCallback<Conversation> v2TIMValueCallback = new V2TIMValueCallback<Conversation>(){

            @Override
            public void onSuccess(Conversation conversation) {
                if (callback != null) {
                    V2TIMConversation v2TIMConversation = new V2TIMConversation();
                    v2TIMConversation.setConversation(conversation);
                    callback.onSuccess(v2TIMConversation);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().getConversationInfo(conversationKey, new IMCallback<Conversation>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(Conversation data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteConversation(String conversationID, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)conversationID)) {
            if (callback != null) {
                callback.onError(6017, "conversationID is empty");
            }
            return;
        }
        ConversationKey conversationKey = this.getConversationKey(conversationID);
        ConversationManager.getInstance().deleteConversation(conversationKey, true, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setConversationDraft(String conversationID, String draftText, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)conversationID)) {
            if (callback != null) {
                callback.onError(6017, "conversationID is empty");
            }
            return;
        }
        ConversationKey conversationKey = this.getConversationKey(conversationID);
        DraftMessage draftMessage = new DraftMessage();
        if (draftText != null) {
            draftMessage.setUserDefinedData(draftText.getBytes());
        }
        ConversationManager.getInstance().setConversationDraft(conversationKey, draftMessage, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void pinConversation(String conversationID, boolean isPinned, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)conversationID)) {
            if (callback != null) {
                callback.onError(6017, "conversationID is empty");
            }
            return;
        }
        ConversationKey conversationKey = this.getConversationKey(conversationID);
        ConversationManager.getInstance().pinConversation(conversationKey, isPinned, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getTotalUnreadMessageCount(V2TIMValueCallback<Long> callback) {
        ConversationManager.getInstance().getTotalUnreadMessageCount(new IMCallback<Long>(callback){

            @Override
            public void success(Long data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void markConversation(List<String> conversationIDList, long markType, boolean enableMark, final V2TIMValueCallback<List<V2TIMConversationOperationResult>> callback) {
        if (conversationIDList == null || conversationIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "conversationIDList is empty");
            }
            return;
        }
        if (markType == 0L) {
            if (callback != null) {
                callback.onError(6017, "markType is invalid");
            }
            return;
        }
        ArrayList<ConversationKey> conversationKeyList = new ArrayList<ConversationKey>();
        for (String conversationID : conversationIDList) {
            ConversationKey conversationKey = this.getConversationKey(conversationID);
            conversationKeyList.add(conversationKey);
        }
        V2TIMValueCallback<List<ConversationOperationResult>> v2Callback = new V2TIMValueCallback<List<ConversationOperationResult>>(){

            @Override
            public void onSuccess(List<ConversationOperationResult> resultList) {
                ArrayList<V2TIMConversationOperationResult> v2ResultList = new ArrayList<V2TIMConversationOperationResult>();
                for (ConversationOperationResult result : resultList) {
                    V2TIMConversationOperationResult v2Result = new V2TIMConversationOperationResult();
                    v2Result.setConversationOperationResult(result);
                    v2ResultList.add(v2Result);
                }
                if (callback != null) {
                    callback.onSuccess(v2ResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().markConversation(conversationKeyList, markType, enableMark, new IMCallback(v2Callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setConversationCustomData(List<String> conversationIDList, String customData, final V2TIMValueCallback<List<V2TIMConversationOperationResult>> callback) {
        if (conversationIDList == null || conversationIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "conversationIDList is empty");
            }
            return;
        }
        ArrayList<ConversationKey> conversationKeyList = new ArrayList<ConversationKey>();
        for (String conversationID : conversationIDList) {
            ConversationKey conversationKey = this.getConversationKey(conversationID);
            conversationKeyList.add(conversationKey);
        }
        V2TIMValueCallback<List<ConversationOperationResult>> v2Callback = new V2TIMValueCallback<List<ConversationOperationResult>>(){

            @Override
            public void onSuccess(List<ConversationOperationResult> resultList) {
                ArrayList<V2TIMConversationOperationResult> v2ResultList = new ArrayList<V2TIMConversationOperationResult>();
                for (ConversationOperationResult result : resultList) {
                    V2TIMConversationOperationResult v2Result = new V2TIMConversationOperationResult();
                    v2Result.setConversationOperationResult(result);
                    v2ResultList.add(v2Result);
                }
                if (callback != null) {
                    callback.onSuccess(v2ResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().setConversationCustomData(conversationKeyList, customData, new IMCallback(v2Callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void createConversationGroup(String groupName, List<String> conversationIDList, final V2TIMValueCallback<List<V2TIMConversationOperationResult>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupName)) {
            if (callback != null) {
                callback.onError(6017, "group name is empty");
            }
            return;
        }
        ArrayList<ConversationKey> conversationKeyList = new ArrayList<ConversationKey>();
        for (String conversationID : conversationIDList) {
            ConversationKey conversationKey = this.getConversationKey(conversationID);
            conversationKeyList.add(conversationKey);
        }
        V2TIMValueCallback<List<ConversationOperationResult>> v2Callback = new V2TIMValueCallback<List<ConversationOperationResult>>(){

            @Override
            public void onSuccess(List<ConversationOperationResult> resultList) {
                ArrayList<V2TIMConversationOperationResult> v2ResultList = new ArrayList<V2TIMConversationOperationResult>();
                for (ConversationOperationResult result : resultList) {
                    V2TIMConversationOperationResult v2Result = new V2TIMConversationOperationResult();
                    v2Result.setConversationOperationResult(result);
                    v2ResultList.add(v2Result);
                }
                if (callback != null) {
                    callback.onSuccess(v2ResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().createConversationGroup(groupName, conversationKeyList, new IMCallback(v2Callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getConversationGroupList(V2TIMValueCallback<List<String>> callback) {
        ConversationManager.getInstance().getConversationGroupList(new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteConversationGroup(String groupName, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupName)) {
            if (callback != null) {
                callback.onError(6017, "group name is empty");
            }
            return;
        }
        ConversationManager.getInstance().deleteConversationGroup(groupName, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void renameConversationGroup(String oldName, String newName, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)oldName)) {
            if (callback != null) {
                callback.onError(6017, "oldName is empty");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)newName)) {
            if (callback != null) {
                callback.onError(6017, "newName is empty");
            }
            return;
        }
        ConversationManager.getInstance().renameConversationGroup(oldName, newName, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void addConversationsToGroup(String groupName, List<String> conversationIDList, final V2TIMValueCallback<List<V2TIMConversationOperationResult>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupName)) {
            if (callback != null) {
                callback.onError(6017, "groupName is empty");
            }
            return;
        }
        if (conversationIDList == null || conversationIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "conversationIDList is empty");
            }
            return;
        }
        ArrayList<ConversationKey> conversationKeyList = new ArrayList<ConversationKey>();
        for (String conversationID : conversationIDList) {
            ConversationKey conversationKey = this.getConversationKey(conversationID);
            conversationKeyList.add(conversationKey);
        }
        V2TIMValueCallback<List<ConversationOperationResult>> v2Callback = new V2TIMValueCallback<List<ConversationOperationResult>>(){

            @Override
            public void onSuccess(List<ConversationOperationResult> resultList) {
                ArrayList<V2TIMConversationOperationResult> v2ResultList = new ArrayList<V2TIMConversationOperationResult>();
                for (ConversationOperationResult result : resultList) {
                    V2TIMConversationOperationResult v2Result = new V2TIMConversationOperationResult();
                    v2Result.setConversationOperationResult(result);
                    v2ResultList.add(v2Result);
                }
                if (callback != null) {
                    callback.onSuccess(v2ResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().addConversationsToGroup(groupName, conversationKeyList, new IMCallback(v2Callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteConversationsFromGroup(String groupName, List<String> conversationIDList, final V2TIMValueCallback<List<V2TIMConversationOperationResult>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupName)) {
            if (callback != null) {
                callback.onError(6017, "groupName is empty");
            }
            return;
        }
        if (conversationIDList == null || conversationIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "conversationIDList is empty");
            }
            return;
        }
        ArrayList<ConversationKey> conversationKeyList = new ArrayList<ConversationKey>();
        for (String conversationID : conversationIDList) {
            ConversationKey conversationKey = this.getConversationKey(conversationID);
            conversationKeyList.add(conversationKey);
        }
        V2TIMValueCallback<List<ConversationOperationResult>> v2Callback = new V2TIMValueCallback<List<ConversationOperationResult>>(){

            @Override
            public void onSuccess(List<ConversationOperationResult> resultList) {
                ArrayList<V2TIMConversationOperationResult> v2ResultList = new ArrayList<V2TIMConversationOperationResult>();
                for (ConversationOperationResult result : resultList) {
                    V2TIMConversationOperationResult v2Result = new V2TIMConversationOperationResult();
                    v2Result.setConversationOperationResult(result);
                    v2ResultList.add(v2Result);
                }
                if (callback != null) {
                    callback.onSuccess(v2ResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().deleteConversationsFromGroup(groupName, conversationKeyList, new IMCallback(v2Callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    protected ConversationKey getConversationKey(String conversationID) {
        ConversationKey conversationKey = new ConversationKey();
        if (TextUtils.isEmpty((CharSequence)conversationID)) {
            return conversationKey;
        }
        String v1ConvID = "";
        int index = conversationID.indexOf("c2c_");
        if (index == 0) {
            v1ConvID = conversationID.substring("c2c_".length());
            conversationKey.setConversationType(1);
            conversationKey.setConversationID(v1ConvID);
        } else {
            index = conversationID.indexOf("group_");
            if (index == 0) {
                v1ConvID = conversationID.substring("group_".length());
                conversationKey.setConversationType(2);
                conversationKey.setConversationID(v1ConvID);
            }
        }
        return conversationKey;
    }

    private static class V2TIMConversationManagerImplHolder {
        private static final V2TIMConversationManagerImpl v2TIMConversationManagerImpl = new V2TIMConversationManagerImpl();

        private V2TIMConversationManagerImplHolder() {
        }
    }
}

