package com.tencent.imsdk.message;

import com.tencent.imsdk.group.GroupMemberInfo;
import com.tencent.imsdk.relationship.UserInfo;
import java.util.List;
import java.util.Map;

public abstract class MessageListener {
    public void onReceiveNewMessage(List<Message> messageList) {}

    public void onReceiveC2CMessageReceipt(List<C2CMessageReceipt> receiptList) {}

    public void onReceiveGroupMessageReceipt(List<GroupMessageReceipt> receiptList) {}

    public void onReceiveMessageRevoked(Map<MessageKey, Map<UserInfo, String>> revokeInfoMap, boolean isPushMessage) {}

    public void onReceiveMessageModified(List<Message> messageList) {}

    public void onReceiveMessageExtensionsChanged(MessageKey messageKey, List<MessageExtension> extensions) {}

    public void onReceiveMessageExtensionsDeleted(MessageKey messageKey, List<MessageExtension> extensions) {}

    public void onReceiveMessageReactionsChanged(List<MessageReactionChangeInfo> changeInfos) {}

    public void onGroupMessagePinned(String groupID, Message message, boolean isPinned, GroupMemberInfo opUser) {}
}
