package com.tencent.imsdk.manager;

import com.tencent.imsdk.relationship.ReceiveMessageOptInfo;
import com.tencent.imsdk.relationship.UserInfo;
import com.tencent.imsdk.relationship.UserStatus;
import java.util.List;

public interface SDKListener {
    /**
     * SDK 正在连接到腾讯云服务器
     */
    public void onConnecting();

    /**
     * SDK 已经成功连接到腾讯云服务器
     */
    public void onConnectSuccess();

    /**
     * SDK 连接腾讯云服务器失败
     */
    public void onConnectFailed(int code, String error);

    /**
     * 当前用户被踢下线，此时可以 UI 提示用户，并再次调用 V2TIMManager 的 login() 函数重新登录。
     */
    public void onKickedOffline();

    /**
     * 在线时票据过期：此时您需要生成新的 userSig 并再次调用 V2TIMManager 的 login() 函数重新登录。
     */
    public void onUserSigExpired();

    /**
     * 登录用户的资料发生了更新
     *
     */
    public void onSelfInfoUpdated(UserInfo info);

    /**
     * 日志回调
     */
    public void onLog(int logLevel, String logContent);

    /**
     * 用户状态变更通知
     *
     * @note 收到通知的情况：
     * 1. 订阅过的用户发生了状态变更（包括在线状态和自定义状态），会触发该回调
     * 2. 在 IM 控制台打开了好友状态通知开关，即使未主动订阅，当好友状态发生变更时，也会触发该回调
     * 3. 同一个账号多设备登录，当其中一台设备修改了自定义状态，所有设备都会收到该回调
     */
    public void onUserStatusChanged(List<UserStatus> userStatusList);

    /**
     * 订阅用户资料变更通知
     */
    public void onUserInfoChanged(List<UserInfo> userInfoList);

    /**
     * 全局消息接收选项变更通知
     *
     */
    public void onAllReceiveMessageOptChanged(ReceiveMessageOptInfo option);

    /**
     * 实验性事件通知
     */
    public void onExperimentalNotify(String key, Object param);
}
