/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.base;

import com.tencent.imsdk.base.ThreadUtils;
import com.tencent.imsdk.base.annotations.CalledByNative;
import com.tencent.imsdk.base.annotations.JNINamespace;
import com.tencent.imsdk.base.annotations.MainDex;

@JNINamespace(value="base::android")
@MainDex
public class JavaExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler mParent;
    private final boolean mCrashAfterReport;
    private boolean mHandlingException;

    private JavaExceptionReporter(Thread.UncaughtExceptionHandler parent, boolean crashAfterReport) {
        this.mParent = parent;
        this.mCrashAfterReport = crashAfterReport;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (!this.mHandlingException) {
            this.mHandlingException = true;
        }
        if (this.mParent != null) {
            this.mParent.uncaughtException(t, e);
        }
    }

    public static void reportStackTrace(String stackTrace) {
        assert (ThreadUtils.runningOnUiThread());
    }

    @CalledByNative
    private static void installHandler(boolean crashAfterReport) {
        Thread.setDefaultUncaughtExceptionHandler(new JavaExceptionReporter(Thread.getDefaultUncaughtExceptionHandler(), crashAfterReport));
    }

    static interface Natives {
        public void reportJavaException(boolean var1, Throwable var2);

        public void reportJavaStackTrace(String var1);
    }
}

