/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.community;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.community.CommunityListener;
import com.tencent.imsdk.community.PermissionGroupInfo;
import com.tencent.imsdk.community.PermissionGroupInfoGetResult;
import com.tencent.imsdk.community.PermissionGroupInfoModifyParam;
import com.tencent.imsdk.community.PermissionGroupMemberInfoResult;
import com.tencent.imsdk.community.PermissionGroupMemberOperationResult;
import com.tencent.imsdk.community.PermissionGroupOperationResult;
import com.tencent.imsdk.community.TopicInfo;
import com.tencent.imsdk.community.TopicInfoGetResult;
import com.tencent.imsdk.community.TopicInfoModifyParam;
import com.tencent.imsdk.community.TopicOperationResult;
import com.tencent.imsdk.community.TopicPermissionResult;
import com.tencent.imsdk.group.GroupManager;
import com.tencent.imsdk.manager.BaseManager;
import java.util.HashMap;
import java.util.List;

public class CommunityManager {
    private CommunityListener mInternalCommunityListener;
    private CommunityListener mCommunityListener;

    public static CommunityManager getInstance() {
        return CommunityManagerHolder.communityManager;
    }

    public void init() {
        this.initCommunityListener();
    }

    private void initCommunityListener() {
        if (this.mInternalCommunityListener == null) {
            this.mInternalCommunityListener = new CommunityListener(){

                @Override
                public void onCreateTopic(final String groupID, final String topicID) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CommunityManager.this.mCommunityListener != null) {
                                CommunityManager.this.mCommunityListener.onCreateTopic(groupID, topicID);
                            }
                            GroupManager.getInstance().notifyTopicCreated(groupID, topicID);
                        }
                    });
                }

                @Override
                public void onDeleteTopic(final String groupID, final List<String> topicIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CommunityManager.this.mCommunityListener != null) {
                                CommunityManager.this.mCommunityListener.onDeleteTopic(groupID, topicIDList);
                            }
                            GroupManager.getInstance().notifyTopicDeleted(groupID, topicIDList);
                        }
                    });
                }

                @Override
                public void onChangeTopicInfo(final String groupID, final TopicInfo topicInfo) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CommunityManager.this.mCommunityListener != null) {
                                CommunityManager.this.mCommunityListener.onChangeTopicInfo(groupID, topicInfo);
                            }
                            GroupManager.getInstance().notifyTopicInfoChanged(groupID, topicInfo);
                        }
                    });
                }

                @Override
                public void onReceiveTopicRESTCustomData(final String topicID, final byte[] customData) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CommunityManager.this.mCommunityListener != null) {
                                CommunityManager.this.mCommunityListener.onReceiveTopicRESTCustomData(topicID, customData);
                            }
                            GroupManager.getInstance().notifyReceiveRESTCustomData(topicID, customData);
                        }
                    });
                }

                @Override
                public void onCreatePermissionGroup(final String groupID, final PermissionGroupInfo permissionGroupInfo) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CommunityManager.this.mCommunityListener != null) {
                                CommunityManager.this.mCommunityListener.onCreatePermissionGroup(groupID, permissionGroupInfo);
                            }
                        }
                    });
                }

                @Override
                public void onDeletePermissionGroup(final String groupID, final List<String> permissionGroupIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CommunityManager.this.mCommunityListener != null) {
                                CommunityManager.this.mCommunityListener.onDeletePermissionGroup(groupID, permissionGroupIDList);
                            }
                        }
                    });
                }

                @Override
                public void onChangePermissionGroupInfo(final String groupID, final PermissionGroupInfo permissionGroupInfo) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CommunityManager.this.mCommunityListener != null) {
                                CommunityManager.this.mCommunityListener.onChangePermissionGroupInfo(groupID, permissionGroupInfo);
                            }
                        }
                    });
                }

                @Override
                public void onAddMembersToPermissionGroup(final String groupID, final String permissionGroupID, final List<String> memberIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CommunityManager.this.mCommunityListener != null) {
                                CommunityManager.this.mCommunityListener.onAddMembersToPermissionGroup(groupID, permissionGroupID, memberIDList);
                            }
                        }
                    });
                }

                @Override
                public void onRemoveMembersFromPermissionGroup(final String groupID, final String permissionGroupID, final List<String> memberIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CommunityManager.this.mCommunityListener != null) {
                                CommunityManager.this.mCommunityListener.onRemoveMembersFromPermissionGroup(groupID, permissionGroupID, memberIDList);
                            }
                        }
                    });
                }

                @Override
                public void onAddTopicPermission(final String groupID, final String permissionGroupID, final HashMap<String, Long> topicPermissionMap) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CommunityManager.this.mCommunityListener != null) {
                                CommunityManager.this.mCommunityListener.onAddTopicPermission(groupID, permissionGroupID, topicPermissionMap);
                            }
                        }
                    });
                }

                @Override
                public void onDeleteTopicPermission(final String groupID, final String permissionGroupID, final List<String> topicIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CommunityManager.this.mCommunityListener != null) {
                                CommunityManager.this.mCommunityListener.onDeleteTopicPermission(groupID, permissionGroupID, topicIDList);
                            }
                        }
                    });
                }

                @Override
                public void onModifyTopicPermission(final String groupID, final String permissionGroupID, final HashMap<String, Long> topicPermissionMap) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CommunityManager.this.mCommunityListener != null) {
                                CommunityManager.this.mCommunityListener.onModifyTopicPermission(groupID, permissionGroupID, topicPermissionMap);
                            }
                        }
                    });
                }
            };
        }
        this.nativeSetCommunityListener(this.mInternalCommunityListener);
    }

    public void setCommunityListener(CommunityListener communityListener) {
        this.mCommunityListener = communityListener;
    }

    public void createTopic(String groupID, TopicInfo topicInfo, IMCallback<String> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeCreateTopic(groupID, topicInfo, callback);
    }

    public void deleteTopic(String groupID, List<String> topicIDList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteTopic(groupID, topicIDList, callback);
    }

    public void setTopicInfo(TopicInfoModifyParam param, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetTopicInfo(param, callback);
    }

    public void getTopicList(String groupID, List<String> topicIdList, IMCallback<List<TopicInfoGetResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetTopicList(groupID, topicIdList, callback);
    }

    public void createPermissionGroupInCommunity(PermissionGroupInfo permissionGroupInfo, IMCallback<String> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeCreatePermissionGroupInCommunity(permissionGroupInfo, callback);
    }

    public void deletePermissionGroupFromCommunity(String groupID, List<String> permissionGroupIDList, IMCallback<List<PermissionGroupOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeletePermissionGroupFromCommunity(groupID, permissionGroupIDList, callback);
    }

    public void modifyPermissionGroupInfoOfCommunity(PermissionGroupInfoModifyParam param, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeModifyPermissionGroupInfoInCommunity(param, callback);
    }

    public void getJoinedPermissionGroupListOfCommunity(String groupID, IMCallback<List<PermissionGroupInfoGetResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetJoinedPermissionGroupListInCommunity(groupID, callback);
    }

    public void getPermissionGroupListOfCommunity(String groupID, List<String> permissionGroupIDList, IMCallback<List<PermissionGroupInfoGetResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetPermissionGroupListInCommunity(groupID, permissionGroupIDList, callback);
    }

    public void addCommunityMembersToPermissionGroup(String groupID, String permissionGroupID, List<String> memberIDList, IMCallback<List<PermissionGroupMemberOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeAddCommunityMembersToPermissionGroup(groupID, permissionGroupID, memberIDList, callback);
    }

    public void removeCommunityMembersFromPermissionGroup(String groupID, String permissionGroupID, List<String> memberIDList, IMCallback<List<PermissionGroupMemberOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeRemoveCommunityMembersFromPermissionGroup(groupID, permissionGroupID, memberIDList, callback);
    }

    public void getCommunityMemberListOfPermissionGroup(String groupID, String permissionGroupID, String nextCursor, IMCallback<PermissionGroupMemberInfoResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetCommunityMemberListInPermissionGroup(groupID, permissionGroupID, nextCursor, callback);
    }

    public void addTopicPermissionToPermissionGroup(String groupID, String permissionGroupID, HashMap<String, Long> topicPermissionMap, IMCallback<List<TopicOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeAddTopicPermissionToPermissionGroup(groupID, permissionGroupID, topicPermissionMap, callback);
    }

    public void deleteTopicPermissionToPermissionGroup(String groupID, String permissionGroupID, List<String> topicIDList, IMCallback<List<TopicOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteTopicPermissionFromPermissionGroup(groupID, permissionGroupID, topicIDList, callback);
    }

    public void modifyTopicPermissionOfPermissionGroup(String groupID, String permissionGroupID, HashMap<String, Long> topicPermissionMap, IMCallback<List<TopicOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeModifyTopicPermissionInPermissionGroup(groupID, permissionGroupID, topicPermissionMap, callback);
    }

    public void getTopicPermissionOfPermissionGroup(String groupID, String permissionGroupID, List<String> topicIDList, IMCallback<List<TopicPermissionResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetTopicPermissionInPermissionGroup(groupID, permissionGroupID, topicIDList, callback);
    }

    protected native void nativeSetCommunityListener(CommunityListener var1);

    protected native void nativeCreateTopic(String var1, TopicInfo var2, IMCallback var3);

    protected native void nativeDeleteTopic(String var1, List<String> var2, IMCallback var3);

    protected native void nativeSetTopicInfo(TopicInfoModifyParam var1, IMCallback var2);

    protected native void nativeGetTopicList(String var1, List<String> var2, IMCallback var3);

    protected native void nativeCreatePermissionGroupInCommunity(PermissionGroupInfo var1, IMCallback var2);

    protected native void nativeDeletePermissionGroupFromCommunity(String var1, List<String> var2, IMCallback var3);

    protected native void nativeModifyPermissionGroupInfoInCommunity(PermissionGroupInfoModifyParam var1, IMCallback var2);

    protected native void nativeGetJoinedPermissionGroupListInCommunity(String var1, IMCallback var2);

    protected native void nativeGetPermissionGroupListInCommunity(String var1, List<String> var2, IMCallback var3);

    protected native void nativeAddCommunityMembersToPermissionGroup(String var1, String var2, List<String> var3, IMCallback var4);

    protected native void nativeRemoveCommunityMembersFromPermissionGroup(String var1, String var2, List<String> var3, IMCallback var4);

    protected native void nativeGetCommunityMemberListInPermissionGroup(String var1, String var2, String var3, IMCallback var4);

    protected native void nativeAddTopicPermissionToPermissionGroup(String var1, String var2, HashMap<String, Long> var3, IMCallback var4);

    protected native void nativeDeleteTopicPermissionFromPermissionGroup(String var1, String var2, List<String> var3, IMCallback var4);

    protected native void nativeModifyTopicPermissionInPermissionGroup(String var1, String var2, HashMap<String, Long> var3, IMCallback var4);

    protected native void nativeGetTopicPermissionInPermissionGroup(String var1, String var2, List<String> var3, IMCallback var4);

    private static class CommunityManagerHolder {
        private static final CommunityManager communityManager = new CommunityManager();

        private CommunityManagerHolder() {
        }
    }
}

