/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.manager;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.SystemUtil;
import com.tencent.imsdk.manager.BaseManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

public class LibraryDownloader {
    private static final String TAG = "LibraryDownloader";
    private static final int ERROR_SUCCESS = 0;
    private static final int ERROR_DOWNLOAD_LIBRARY_FAILED = 101;
    private static final int ERROR_UNCOMPRESS_LIBRARY_FAILED = 102;
    private static final int ERROR_CHECK_LIBRARY_MD5_FAILED = 103;
    private static final int ERROR_LOAD_LIBRARY_FAILED = 104;
    private static final String LIBRARY_NAME = "libImSDK.so";
    private static final String LIBRARY_DIR_NAME = "imsdk-plus-";
    private static final String LIBRARY_VERSION = "8.8.7359";
    private static final String LIBRARY_MD5_ARM64 = "e5626c80a893f6506c0e733d23b2b97c";
    private static final String LIBRARY_MD5_ARM32 = "6169ff6597481ffa4b774beef7b8fa90";
    private boolean mIsLoading = false;
    private CopyOnWriteArrayList<IMCallback> mCallbackList = new CopyOnWriteArrayList();
    private String mLibraryPath = "";
    private HandlerThread mWorkerThread = null;
    private Handler mMainHandler = null;
    private Handler mWorkerHandler = null;

    public static LibraryDownloader getInstance() {
        return LibraryLoaderHolder.IM_LIBRARY_LOADER;
    }

    public void downloadLibrary(Context context, final IMCallback callback) {
        this.mLibraryPath = context.getFilesDir().toString() + File.separator + LIBRARY_DIR_NAME + LIBRARY_VERSION + File.separator;
        if (this.mWorkerThread == null) {
            this.mWorkerThread = new HandlerThread("libraryLoader");
            this.mWorkerThread.start();
        }
        if (this.mMainHandler == null) {
            this.mMainHandler = new Handler(context.getMainLooper());
        }
        if (this.mWorkerHandler == null) {
            this.mWorkerHandler = new Handler(this.mWorkerThread.getLooper());
        }
        this.mWorkerHandler.post(new Runnable(){

            @Override
            public void run() {
                LibraryDownloader.this.mCallbackList.add(callback);
                if (LibraryDownloader.this.mIsLoading) {
                    return;
                }
                LibraryDownloader.this.mIsLoading = true;
                if (0 == LibraryDownloader.this.loadLibrary()) {
                    Log.i((String)LibraryDownloader.TAG, (String)"check library md5 success and load library success");
                    LibraryDownloader.this.notifyResult(0, "SUCCESS");
                    return;
                }
                SystemUtil.deleteDirectory(LibraryDownloader.this.mLibraryPath);
                SystemUtil.createDirectory(LibraryDownloader.this.mLibraryPath);
                Log.i((String)LibraryDownloader.TAG, (String)"start download library");
                boolean result = false;
                String libraryName = "imsdk-plus-8.8.7359.aar";
                result = LibraryDownloader.this.fetchLibrary(libraryName);
                if (!result) {
                    Log.e((String)LibraryDownloader.TAG, (String)"download library failed");
                    LibraryDownloader.this.notifyResult(101, "download library failed");
                    return;
                }
                Log.i((String)LibraryDownloader.TAG, (String)"download library success");
                result = LibraryDownloader.this.uncompressLibrary(libraryName);
                if (!result) {
                    Log.e((String)LibraryDownloader.TAG, (String)"uncompress library failed");
                    LibraryDownloader.this.notifyResult(102, "uncompress library failed");
                    return;
                }
                Log.i((String)LibraryDownloader.TAG, (String)"uncompress library success");
                int error = LibraryDownloader.this.loadLibrary();
                if (0 != error) {
                    String message = error == 103 ? "check library md5 failed" : "load library failed";
                    Log.e((String)LibraryDownloader.TAG, (String)message);
                    LibraryDownloader.this.notifyResult(error, message);
                    return;
                }
                Log.i((String)LibraryDownloader.TAG, (String)"load library success");
                LibraryDownloader.this.notifyResult(0, "SUCCESS");
            }
        });
    }

    private int loadLibrary() {
        int error = 0;
        String arm64Path = this.mLibraryPath + "jni" + File.separator + "arm64-v8a";
        String arm64MD5 = SystemUtil.getFileMD5(arm64Path + File.separator + LIBRARY_NAME);
        error = arm64MD5.equalsIgnoreCase(LIBRARY_MD5_ARM64) ? (BaseManager.getInstance().setLibraryPath(arm64Path) ? 0 : 103) : 103;
        if (error != 0) {
            String arm32Path = this.mLibraryPath + "jni" + File.separator + "armeabi-v7a";
            String arm32MD5 = SystemUtil.getFileMD5(arm32Path + File.separator + LIBRARY_NAME);
            error = arm32MD5.equalsIgnoreCase(LIBRARY_MD5_ARM32) ? (BaseManager.getInstance().setLibraryPath(arm32Path) ? 0 : 103) : 103;
        }
        return error;
    }

    private boolean fetchLibrary(String libraryName) {
        ArrayList<String> urlList = new ArrayList<String>();
        urlList.add("https://im.sdk.qcloud.com/download/plus/8.8.7359/" + libraryName);
        urlList.add("https://sdk-im-1252463788.cos.accelerate.myqcloud.com/download/plus/8.8.7359/" + libraryName);
        urlList.add("https://sdk-im-1252463788.file.myqcloud.com/download/plus/8.8.7359/" + libraryName);
        urlList.add("https://sdk-im-1252463788.cos.ap-hongkong.myqcloud.com/download/plus/8.8.7359/" + libraryName);
        for (int i = 0; i < urlList.size(); ++i) {
            try {
                URL url = new URL((String)urlList.get(i));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.connect();
                if (connection.getResponseCode() == 200) {
                    int bytesRead;
                    File outputFile = new File(this.mLibraryPath, libraryName);
                    InputStream inputStream = connection.getInputStream();
                    FileOutputStream outputStream = new FileOutputStream(outputFile);
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                    inputStream.close();
                    outputStream.close();
                    return true;
                }
                Log.w((String)TAG, (String)("fetch library failed|url:" + (String)urlList.get(i)));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private boolean uncompressLibrary(String libraryName) {
        String fullPath = this.mLibraryPath + libraryName;
        File file = new File(fullPath);
        if (!file.exists()) {
            return false;
        }
        return SystemUtil.uncompressFile(fullPath, this.mLibraryPath);
    }

    private void notifyResult(final int errorCode, final String errorMessage) {
        if (errorCode != 0) {
            SystemUtil.deleteDirectory(this.mLibraryPath);
        }
        final CopyOnWriteArrayList<IMCallback> callbackList = new CopyOnWriteArrayList<IMCallback>();
        for (IMCallback callback : this.mCallbackList) {
            callbackList.add(callback);
        }
        this.mIsLoading = false;
        this.mCallbackList.clear();
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                for (IMCallback callback : callbackList) {
                    if (errorCode == 0) {
                        callback.success("OK");
                        continue;
                    }
                    callback.fail(errorCode, errorMessage);
                }
            }
        });
    }

    private static class LibraryLoaderHolder {
        private static final LibraryDownloader IM_LIBRARY_LOADER = new LibraryDownloader();

        private LibraryLoaderHolder() {
        }
    }
}

