/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.relationship;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.officialaccount.OfficialAccountInfo;
import com.tencent.imsdk.officialaccount.OfficialAccountInfoResult;
import com.tencent.imsdk.relationship.FollowInfo;
import com.tencent.imsdk.relationship.FollowOperationResult;
import com.tencent.imsdk.relationship.FollowTypeCheckResult;
import com.tencent.imsdk.relationship.FriendAddApplication;
import com.tencent.imsdk.relationship.FriendApplication;
import com.tencent.imsdk.relationship.FriendApplicationResult;
import com.tencent.imsdk.relationship.FriendCheckResult;
import com.tencent.imsdk.relationship.FriendGroup;
import com.tencent.imsdk.relationship.FriendInfo;
import com.tencent.imsdk.relationship.FriendInfoResult;
import com.tencent.imsdk.relationship.FriendOperationResult;
import com.tencent.imsdk.relationship.FriendResponse;
import com.tencent.imsdk.relationship.FriendshipListener;
import com.tencent.imsdk.relationship.ReceiveMessageOptInfo;
import com.tencent.imsdk.relationship.UserInfo;
import com.tencent.imsdk.relationship.UserInfoResult;
import com.tencent.imsdk.relationship.UserSearchParam;
import com.tencent.imsdk.relationship.UserSearchResult;
import com.tencent.imsdk.relationship.UserStatus;
import java.util.HashMap;
import java.util.List;

public class RelationshipManager {
    private FriendshipListener mFriendshipInternalListener;
    private FriendshipListener mFriendshipListener;

    public static RelationshipManager getInstance() {
        return RelationshipManagerHolder.relationshipManager;
    }

    public void init() {
        this.initFriendshipListener();
    }

    private void initFriendshipListener() {
        if (this.mFriendshipInternalListener == null) {
            this.mFriendshipInternalListener = new FriendshipListener(){

                @Override
                public void onSelfInfoUpdated(UserInfo userInfo) {
                    BaseManager.getInstance().notifySelfInfoUpdated(userInfo);
                }

                @Override
                public void onFriendInfoChanged(final List<FriendInfo> friendInfoList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onFriendInfoChanged(friendInfoList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendListAdded(final List<FriendInfo> friendInfoList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onFriendListAdded(friendInfoList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendListDeleted(final List<String> userIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onFriendListDeleted(userIDList);
                            }
                        }
                    });
                }

                @Override
                public void onBlackListAdded(final List<FriendInfo> friendInfoList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onBlackListAdded(friendInfoList);
                            }
                        }
                    });
                }

                @Override
                public void onBlackListDeleted(final List<String> userIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onBlackListDeleted(userIDList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendApplicationListAdded(final List<FriendApplication> applicationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onFriendApplicationListAdded(applicationList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendApplicationListDelete(final List<String> userIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onFriendApplicationListDelete(userIDList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendApplicationListRead() {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onFriendApplicationListRead();
                            }
                        }
                    });
                }

                @Override
                public void onFriendGroupCreated(final String groupName, final List<FriendInfo> friendInfoList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onFriendGroupCreated(groupName, friendInfoList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendGroupDeleted(final List<String> groupNameList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onFriendGroupDeleted(groupNameList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendGroupNameChanged(final String oldGroupName, final String newGroupName) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onFriendGroupNameChanged(oldGroupName, newGroupName);
                            }
                        }
                    });
                }

                @Override
                public void onFriendsAddedToGroup(final String groupName, final List<FriendInfo> friendInfoList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onFriendsAddedToGroup(groupName, friendInfoList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendsDeletedFromGroup(final String groupName, final List<String> friendIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onFriendsDeletedFromGroup(groupName, friendIDList);
                            }
                        }
                    });
                }

                @Override
                public void onUserStatusChanged(List<UserStatus> userStatusList) {
                    BaseManager.getInstance().notifyUserStatusChanged(userStatusList);
                }

                @Override
                public void onUserInfoChanged(List<UserInfo> userInfoList) {
                    BaseManager.getInstance().notifyUserInfoChanged(userInfoList);
                }

                @Override
                public void onAllReceiveMessageOptChanged(ReceiveMessageOptInfo option) {
                    BaseManager.getInstance().notifyAllReceiveMessageOptChanged(option);
                }

                @Override
                public void onMyFollowingListChanged(final List<UserInfo> userInfoList, final boolean isAdd) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onMyFollowingListChanged(userInfoList, isAdd);
                            }
                        }
                    });
                }

                @Override
                public void onMyFollowersListChanged(final List<UserInfo> userInfoList, final boolean isAdd) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onMyFollowersListChanged(userInfoList, isAdd);
                            }
                        }
                    });
                }

                @Override
                public void onMutualFollowersListChanged(final List<UserInfo> userInfoList, final boolean isAdd) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onMutualFollowersListChanged(userInfoList, isAdd);
                            }
                        }
                    });
                }

                @Override
                public void onOfficialAccountSubscribed(final OfficialAccountInfo officialAccountInfo) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onOfficialAccountSubscribed(officialAccountInfo);
                            }
                        }
                    });
                }

                @Override
                public void onOfficialAccountUnsubscribed(final String officialAccountID) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onOfficialAccountUnsubscribed(officialAccountID);
                            }
                        }
                    });
                }

                @Override
                public void onOfficialAccountDeleted(final String officialAccountID) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onOfficialAccountDeleted(officialAccountID);
                            }
                        }
                    });
                }

                @Override
                public void onOfficialAccountInfoChanged(final OfficialAccountInfo officialAccountInfo) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.onOfficialAccountInfoChanged(officialAccountInfo);
                            }
                        }
                    });
                }
            };
        }
        this.nativeSetFriendshipListener(this.mFriendshipInternalListener);
    }

    public void setFriendshipListener(FriendshipListener friendshipListener) {
        this.mFriendshipListener = friendshipListener;
    }

    public void getUsersInfo(List<String> userIDList, IMCallback<List<UserInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetUsersInfo(userIDList, callback);
    }

    public void setSelfInfo(HashMap<String, Object> modifyParams, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetSelfInfo(modifyParams, callback);
    }

    public void subscribeUserInfo(List<String> userIDList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSubscribeUserInfo(userIDList, callback);
    }

    public void unsubscribeUserInfo(List<String> userIDList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeUnsubscribeUserInfo(userIDList, callback);
    }

    public void searchUsers(UserSearchParam param, IMCallback<UserSearchResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSearchCloudUsers(param, callback);
    }

    public void getUserStatus(List<String> userIDList, IMCallback<List<UserStatus>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetUserStatus(userIDList, callback);
    }

    public void setSelfStatus(UserStatus userStatus, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetSelfStatus(userStatus, callback);
    }

    public void subscribeUserStatus(List<String> userIDList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSubscribeUserStatus(userIDList, callback);
    }

    public void unsubscribeUserStatus(List<String> userIDList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeUnsubscribeUserStatus(userIDList, callback);
    }

    public void setC2CReceiveMessageOpt(List<String> userIDList, int opt, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetC2CReceiveMessageOpt(userIDList, opt, callback);
    }

    public void getC2CReceiveMessageOpt(List<String> userIDList, IMCallback<List<ReceiveMessageOptInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetC2CReceiveMessageOpt(userIDList, callback);
    }

    public void setAllReceiveMessageOpt(int opt, int startHour, int startMinute, int startSecond, long duration, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetAllReceiveMessageOpt(opt, startHour, startMinute, startSecond, 0L, duration, callback);
    }

    public void setAllReceiveMessageOpt(int opt, long startTimeStamp, long duration, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetAllReceiveMessageOpt(opt, 0, 0, 0, startTimeStamp, duration, callback);
    }

    public void getAllReceiveMessageOpt(IMCallback<ReceiveMessageOptInfo> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetAllReceiveMessageOpt(callback);
    }

    public void getFriendList(IMCallback<List<FriendInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetFriendList(callback);
    }

    public void getFriendsInfo(List<String> userIDList, IMCallback<List<FriendInfoResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetFriendsInfo(userIDList, callback);
    }

    public void setFriendInfo(String userID, HashMap<String, Object> modifyParams, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetFriendInfo(userID, modifyParams, callback);
    }

    public void searchFriends(UserSearchParam searchParam, IMCallback<List<FriendInfoResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSearchLocalUsers(searchParam, callback);
    }

    public void addFriend(FriendAddApplication friendAddApplication, IMCallback<FriendOperationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeAddFriend(friendAddApplication, callback);
    }

    public void deleteFromFriendList(List<String> userIDList, int deleteType, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteFromFriendList(userIDList, deleteType, callback);
    }

    public void checkFriend(List<String> userIDList, int checkType, IMCallback<List<FriendCheckResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeCheckFriend(userIDList, checkType, callback);
    }

    public void getFriendApplicationList(IMCallback<FriendApplicationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetFriendApplicationList(callback);
    }

    public void responseFriendApplication(FriendResponse friendResponse, IMCallback<FriendOperationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeResponseFriendApplication(friendResponse, callback);
    }

    public void deleteFriendApplication(int applicationType, String userID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteFriendApplication(applicationType, userID, callback);
    }

    public void setFriendApplicationRead(IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetFriendApplicationRead(callback);
    }

    public void addToBlackList(List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeAddToBlackList(userIDList, callback);
    }

    public void deleteFromBlackList(List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteFromBlackList(userIDList, callback);
    }

    public void getBlackList(IMCallback<List<FriendInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetBlackList(callback);
    }

    public void createFriendGroup(String groupName, List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeCreateFriendGroup(groupName, userIDList, callback);
    }

    public void getFriendGroups(List<String> groupNameList, IMCallback<List<FriendGroup>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetFriendGroups(groupNameList, callback);
    }

    public void deleteFriendGroup(List<String> groupNameList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteFriendGroup(groupNameList, callback);
    }

    public void renameFriendGroup(String oldName, String newName, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeRenameFriendGroup(oldName, newName, callback);
    }

    public void addFriendsToFriendGroup(String groupName, List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeAddFriendsToFriendGroup(groupName, userIDList, callback);
    }

    public void deleteFriendsFromFriendGroup(String groupName, List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteFriendsFromFriendGroup(groupName, userIDList, callback);
    }

    public void followUser(List<String> userIDList, IMCallback<List<FollowOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeFollowUser(userIDList, callback);
    }

    public void unfollowUser(List<String> userIDList, IMCallback<List<FollowOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeUnfollowUser(userIDList, callback);
    }

    public void getMyFollowingList(String nextCursor, IMCallback<UserInfoResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetMyFollowingList(nextCursor, callback);
    }

    public void getMyFollowersList(String nextCursor, IMCallback<UserInfoResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetMyFollowersList(nextCursor, callback);
    }

    public void getMutualFollowersList(String nextCursor, IMCallback<UserInfoResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetMutualFollowersList(nextCursor, callback);
    }

    public void getUserFollowInfo(List<String> userIDList, IMCallback<List<FollowInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetUserFollowInfo(userIDList, callback);
    }

    public void checkFollowType(List<String> userIDList, IMCallback<List<FollowTypeCheckResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeCheckFollowType(userIDList, callback);
    }

    public void subscribeOfficialAccount(String officialAccountID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSubscribeOfficialAccount(officialAccountID, callback);
    }

    public void unsubscribeOfficialAccount(String officialAccountID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeUnsubscribeOfficialAccount(officialAccountID, callback);
    }

    public void getOfficialAccountsInfo(List<String> officialAccountIDList, IMCallback<List<OfficialAccountInfoResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetOfficialAccountsInfo(officialAccountIDList, callback);
    }

    public void getOfficialAccountList(int count, long offset, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetOfficialAccountList(count, offset, callback);
    }

    protected native void nativeSetFriendshipListener(FriendshipListener var1);

    protected native void nativeGetUsersInfo(List<String> var1, IMCallback<List<UserInfo>> var2);

    protected native void nativeSetSelfInfo(HashMap<String, Object> var1, IMCallback var2);

    protected native void nativeSubscribeUserInfo(List<String> var1, IMCallback var2);

    protected native void nativeUnsubscribeUserInfo(List<String> var1, IMCallback var2);

    protected native void nativeSearchLocalUsers(UserSearchParam var1, IMCallback var2);

    protected native void nativeSearchCloudUsers(UserSearchParam var1, IMCallback var2);

    protected native void nativeGetUserStatus(List<String> var1, IMCallback<List<UserStatus>> var2);

    protected native void nativeSetSelfStatus(UserStatus var1, IMCallback var2);

    protected native void nativeSubscribeUserStatus(List<String> var1, IMCallback var2);

    protected native void nativeUnsubscribeUserStatus(List<String> var1, IMCallback var2);

    protected native void nativeSetC2CReceiveMessageOpt(List<String> var1, int var2, IMCallback var3);

    protected native void nativeGetC2CReceiveMessageOpt(List<String> var1, IMCallback<List<ReceiveMessageOptInfo>> var2);

    protected native void nativeSetAllReceiveMessageOpt(int var1, int var2, int var3, int var4, long var5, long var7, IMCallback var9);

    protected native void nativeGetAllReceiveMessageOpt(IMCallback<ReceiveMessageOptInfo> var1);

    protected native void nativeGetFriendList(IMCallback var1);

    protected native void nativeGetFriendsInfo(List<String> var1, IMCallback var2);

    protected native void nativeSetFriendInfo(String var1, HashMap<String, Object> var2, IMCallback var3);

    protected native void nativeAddFriend(FriendAddApplication var1, IMCallback var2);

    protected native void nativeDeleteFromFriendList(List<String> var1, int var2, IMCallback var3);

    protected native void nativeCheckFriend(List<String> var1, int var2, IMCallback var3);

    protected native void nativeGetFriendApplicationList(IMCallback var1);

    protected native void nativeResponseFriendApplication(FriendResponse var1, IMCallback var2);

    protected native void nativeDeleteFriendApplication(int var1, String var2, IMCallback var3);

    protected native void nativeSetFriendApplicationRead(IMCallback var1);

    protected native void nativeAddToBlackList(List<String> var1, IMCallback var2);

    protected native void nativeDeleteFromBlackList(List<String> var1, IMCallback var2);

    protected native void nativeGetBlackList(IMCallback var1);

    protected native void nativeCreateFriendGroup(String var1, List<String> var2, IMCallback var3);

    protected native void nativeGetFriendGroups(List<String> var1, IMCallback var2);

    protected native void nativeDeleteFriendGroup(List<String> var1, IMCallback var2);

    protected native void nativeRenameFriendGroup(String var1, String var2, IMCallback var3);

    protected native void nativeAddFriendsToFriendGroup(String var1, List<String> var2, IMCallback var3);

    protected native void nativeDeleteFriendsFromFriendGroup(String var1, List<String> var2, IMCallback var3);

    protected native void nativeFollowUser(List<String> var1, IMCallback<List<FollowOperationResult>> var2);

    protected native void nativeUnfollowUser(List<String> var1, IMCallback<List<FollowOperationResult>> var2);

    protected native void nativeGetMyFollowingList(String var1, IMCallback<UserInfoResult> var2);

    protected native void nativeGetMyFollowersList(String var1, IMCallback<UserInfoResult> var2);

    protected native void nativeGetMutualFollowersList(String var1, IMCallback<UserInfoResult> var2);

    protected native void nativeGetUserFollowInfo(List<String> var1, IMCallback<List<FollowInfo>> var2);

    protected native void nativeCheckFollowType(List<String> var1, IMCallback<List<FollowTypeCheckResult>> var2);

    protected native void nativeSubscribeOfficialAccount(String var1, IMCallback var2);

    protected native void nativeUnsubscribeOfficialAccount(String var1, IMCallback var2);

    protected native void nativeGetOfficialAccountsInfo(List<String> var1, IMCallback var2);

    protected native void nativeGetOfficialAccountList(int var1, long var2, IMCallback var4);

    private static class RelationshipManagerHolder {
        private static final RelationshipManager relationshipManager = new RelationshipManager();

        private RelationshipManagerHolder() {
        }
    }
}

