/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.community.TopicInfo;
import com.tencent.imsdk.group.GroupApplication;
import com.tencent.imsdk.group.GroupInfoChangeItem;
import com.tencent.imsdk.group.GroupListener;
import com.tencent.imsdk.group.GroupManager;
import com.tencent.imsdk.group.GroupMemberInfo;
import com.tencent.imsdk.group.GroupMemberInfoChangeItem;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.manager.SDKConfig;
import com.tencent.imsdk.manager.SDKListener;
import com.tencent.imsdk.message.C2CMessageReceipt;
import com.tencent.imsdk.message.GroupMessageReceipt;
import com.tencent.imsdk.message.Message;
import com.tencent.imsdk.message.MessageCenter;
import com.tencent.imsdk.message.MessageKey;
import com.tencent.imsdk.message.MessageListener;
import com.tencent.imsdk.relationship.ReceiveMessageOptInfo;
import com.tencent.imsdk.relationship.RelationshipManager;
import com.tencent.imsdk.relationship.UserInfo;
import com.tencent.imsdk.relationship.UserSearchResult;
import com.tencent.imsdk.relationship.UserStatus;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMCustomElem;
import com.tencent.imsdk.v2.V2TIMGroupChangeInfo;
import com.tencent.imsdk.v2.V2TIMGroupListener;
import com.tencent.imsdk.v2.V2TIMGroupMemberChangeInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberInfo;
import com.tencent.imsdk.v2.V2TIMLogListener;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMManagerExperimentImpl;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMMessageManager;
import com.tencent.imsdk.v2.V2TIMMessageManagerImpl;
import com.tencent.imsdk.v2.V2TIMOfflinePushInfo;
import com.tencent.imsdk.v2.V2TIMReceiveMessageOptInfo;
import com.tencent.imsdk.v2.V2TIMSDKConfig;
import com.tencent.imsdk.v2.V2TIMSDKListener;
import com.tencent.imsdk.v2.V2TIMSendCallback;
import com.tencent.imsdk.v2.V2TIMSignalingManagerImpl;
import com.tencent.imsdk.v2.V2TIMSimpleMsgListener;
import com.tencent.imsdk.v2.V2TIMTextElem;
import com.tencent.imsdk.v2.V2TIMTopicInfo;
import com.tencent.imsdk.v2.V2TIMUserFullInfo;
import com.tencent.imsdk.v2.V2TIMUserInfo;
import com.tencent.imsdk.v2.V2TIMUserSearchParam;
import com.tencent.imsdk.v2.V2TIMUserSearchResult;
import com.tencent.imsdk.v2.V2TIMUserStatus;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class V2TIMManagerImpl
extends V2TIMManager {
    private static final String TAG = V2TIMManagerImpl.class.getSimpleName();
    private Object mLockObject = new Object();
    private SDKListener mSDKListener;
    private V2TIMLogListener mLogListener;
    private MessageListener mMessageInternalListener;
    private List<V2TIMSimpleMsgListener> mV2TIMSimpleMsgListenerList;
    private GroupListener mGroupInternalListener;
    private V2TIMSDKListener mIMSDKListener;
    private V2TIMGroupListener mV2TIMGroupListener;
    private final List<V2TIMSDKListener> mIMSDKListenerList = new ArrayList<V2TIMSDKListener>();
    private final List<V2TIMGroupListener> mGroupListenerList = new ArrayList<V2TIMGroupListener>();

    public static V2TIMManagerImpl getInstance() {
        return V2TIMManagerImplHolder.v2TIMManagerImpl;
    }

    protected V2TIMManagerImpl() {
        this.mV2TIMSimpleMsgListenerList = new CopyOnWriteArrayList<V2TIMSimpleMsgListener>();
        this.initSDKListener();
        this.initMessageListener();
        this.initGroupListener();
        V2TIMMessageManagerImpl.getInstance().initListener();
    }

    @Override
    public boolean initSDK(Context context, int sdkAppID, V2TIMSDKConfig config) {
        return this.initSDK(context, sdkAppID, config, null);
    }

    @Override
    public boolean initSDK(Context context, int sdkAppID, V2TIMSDKConfig config, V2TIMSDKListener listener) {
        if (null == config) {
            config = new V2TIMSDKConfig();
        }
        this.mLogListener = config.getLogListener();
        boolean needLogCallback = this.mLogListener != null;
        SDKConfig sdkConfig = new SDKConfig();
        sdkConfig.sdkAppId = sdkAppID;
        sdkConfig.logSetting.logLevel = config.getLogLevel();
        this.setSDKListener(listener);
        return BaseManager.getInstance().initSDK(context, sdkConfig, needLogCallback, this.mSDKListener);
    }

    @Override
    public void unInitSDK() {
        this.mIMSDKListener = null;
        BaseManager.getInstance().unInitSDK(true);
        V2TIMSignalingManagerImpl.getInstance().unInit();
    }

    private void setSDKListener(final V2TIMSDKListener listener) {
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (V2TIMManagerImpl.this.mIMSDKListener != null) {
                    V2TIMManagerImpl.this.mIMSDKListenerList.remove(V2TIMManagerImpl.this.mIMSDKListener);
                }
                if (listener != null) {
                    V2TIMManagerImpl.this.mIMSDKListenerList.add(listener);
                }
                V2TIMManagerImpl.this.mIMSDKListener = listener;
            }
        });
    }

    @Override
    public void addIMSDKListener(final V2TIMSDKListener listener) {
        if (listener == null) {
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (V2TIMManagerImpl.this.mIMSDKListenerList.contains(listener)) {
                    return;
                }
                V2TIMManagerImpl.this.mIMSDKListenerList.add(listener);
            }
        });
    }

    @Override
    public void removeIMSDKListener(final V2TIMSDKListener listener) {
        if (listener == null) {
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                V2TIMManagerImpl.this.mIMSDKListenerList.remove(listener);
            }
        });
    }

    @Override
    public String getVersion() {
        return BaseManager.getInstance().getVersion();
    }

    @Override
    public long getServerTime() {
        return BaseManager.getInstance().getServerTime();
    }

    @Override
    public void login(String userID, String userSig, final V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)userID) || TextUtils.isEmpty((CharSequence)userSig)) {
            callback.onError(6017, "userID or userSig is empty");
            return;
        }
        V2TIMCallback v2TIMCallback = new V2TIMCallback(){

            @Override
            public void onSuccess() {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        BaseManager.getInstance().login(userID, userSig, new IMCallback(v2TIMCallback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        }, 1);
    }

    @Override
    public void logout(V2TIMCallback callback) {
        BaseManager.getInstance().logout(new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public String getLoginUser() {
        return BaseManager.getInstance().getLoginUser();
    }

    @Override
    public int getLoginStatus() {
        return BaseManager.getInstance().getLoginStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSimpleMsgListener(V2TIMSimpleMsgListener v2TIMSimpleMsgListener) {
        if (v2TIMSimpleMsgListener == null) {
            return;
        }
        Object object = this.mLockObject;
        synchronized (object) {
            if (this.mV2TIMSimpleMsgListenerList.contains(v2TIMSimpleMsgListener)) {
                return;
            }
            this.mV2TIMSimpleMsgListenerList.add(v2TIMSimpleMsgListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSimpleMsgListener(V2TIMSimpleMsgListener v2TIMSimpleMsgListener) {
        if (v2TIMSimpleMsgListener == null) {
            return;
        }
        Object object = this.mLockObject;
        synchronized (object) {
            this.mV2TIMSimpleMsgListenerList.remove(v2TIMSimpleMsgListener);
        }
    }

    @Override
    public String sendC2CTextMessage(String text, String userID, final V2TIMValueCallback<V2TIMMessage> callback) {
        if (text == null) {
            if (callback != null) {
                callback.onError(6017, "text is null");
            }
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)userID)) {
            if (callback != null) {
                callback.onError(6017, "userID is empty");
            }
            return null;
        }
        V2TIMMessage v2TIMMessage = V2TIMMessageManagerImpl.getInstance().createTextMessage(text);
        V2TIMSendCallback<V2TIMMessage> sendCallback = new V2TIMSendCallback<V2TIMMessage>(){

            @Override
            public void onProgress(int progress) {
            }

            @Override
            public void onSuccess(V2TIMMessage v2TIMMessage) {
                if (callback != null) {
                    callback.onSuccess(v2TIMMessage);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        V2TIMMessageManager.getInstance().sendMessage(v2TIMMessage, userID, null, 2, false, new V2TIMOfflinePushInfo(), sendCallback);
        return v2TIMMessage.getMsgID();
    }

    @Override
    public String sendC2CCustomMessage(byte[] customData, String userID, final V2TIMValueCallback<V2TIMMessage> callback) {
        if (customData == null) {
            if (callback != null) {
                callback.onError(6017, "customData is null");
            }
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)userID)) {
            if (callback != null) {
                callback.onError(6017, "userID is empty");
            }
            return null;
        }
        V2TIMMessage v2TIMMessage = V2TIMMessageManagerImpl.getInstance().createCustomMessage(customData);
        V2TIMSendCallback<V2TIMMessage> sendCallback = new V2TIMSendCallback<V2TIMMessage>(){

            @Override
            public void onProgress(int progress) {
            }

            @Override
            public void onSuccess(V2TIMMessage v2TIMMessage) {
                if (callback != null) {
                    callback.onSuccess(v2TIMMessage);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        V2TIMMessageManager.getInstance().sendMessage(v2TIMMessage, userID, null, 2, false, new V2TIMOfflinePushInfo(), sendCallback);
        return v2TIMMessage.getMsgID();
    }

    @Override
    public String sendGroupTextMessage(String text, String groupID, int priority, final V2TIMValueCallback<V2TIMMessage> callback) {
        if (text == null) {
            if (callback != null) {
                callback.onError(6017, "text is null");
            }
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return "";
        }
        V2TIMMessage v2TIMMessage = V2TIMMessageManagerImpl.getInstance().createTextMessage(text);
        int priorityInternal = 2;
        if (priority == 0) {
            priorityInternal = 2;
        } else if (priority == 1 || priority == 3) {
            priorityInternal = priority;
        }
        V2TIMSendCallback<V2TIMMessage> sendCallback = new V2TIMSendCallback<V2TIMMessage>(){

            @Override
            public void onProgress(int progress) {
            }

            @Override
            public void onSuccess(V2TIMMessage v2TIMMessage) {
                if (callback != null) {
                    callback.onSuccess(v2TIMMessage);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        V2TIMMessageManager.getInstance().sendMessage(v2TIMMessage, null, groupID, priorityInternal, false, new V2TIMOfflinePushInfo(), sendCallback);
        return v2TIMMessage.getMsgID();
    }

    @Override
    public String sendGroupCustomMessage(byte[] customData, String groupID, int priority, final V2TIMValueCallback<V2TIMMessage> callback) {
        if (customData == null) {
            if (callback != null) {
                callback.onError(6017, "customData is null");
            }
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return "";
        }
        V2TIMMessage v2TIMMessage = V2TIMMessageManagerImpl.getInstance().createCustomMessage(customData);
        int priorityInternal = 2;
        if (priority == 0) {
            priorityInternal = 2;
        } else if (priority == 1 || priority == 3) {
            priorityInternal = priority;
        }
        V2TIMSendCallback<V2TIMMessage> sendCallback = new V2TIMSendCallback<V2TIMMessage>(){

            @Override
            public void onProgress(int progress) {
            }

            @Override
            public void onSuccess(V2TIMMessage v2TIMMessage) {
                if (callback != null) {
                    callback.onSuccess(v2TIMMessage);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        V2TIMMessageManager.getInstance().sendMessage(v2TIMMessage, null, groupID, priorityInternal, false, new V2TIMOfflinePushInfo(), sendCallback);
        return v2TIMMessage.getMsgID();
    }

    @Override
    public void setGroupListener(final V2TIMGroupListener listener) {
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (V2TIMManagerImpl.this.mV2TIMGroupListener != null) {
                    V2TIMManagerImpl.this.mGroupListenerList.remove(V2TIMManagerImpl.this.mV2TIMGroupListener);
                }
                if (listener != null) {
                    V2TIMManagerImpl.this.mGroupListenerList.add(listener);
                }
                V2TIMManagerImpl.this.mV2TIMGroupListener = listener;
            }
        });
    }

    @Override
    public void addGroupListener(final V2TIMGroupListener listener) {
        if (listener == null) {
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (V2TIMManagerImpl.this.mGroupListenerList.contains(listener)) {
                    return;
                }
                V2TIMManagerImpl.this.mGroupListenerList.add(listener);
            }
        });
    }

    @Override
    public void removeGroupListener(final V2TIMGroupListener listener) {
        if (listener == null) {
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                V2TIMManagerImpl.this.mGroupListenerList.remove(listener);
            }
        });
    }

    @Override
    public void createGroup(String groupType, String groupID, String groupName, V2TIMValueCallback<String> callback) {
        if (TextUtils.isEmpty((CharSequence)groupType)) {
            if (callback != null) {
                callback.onError(6017, "groupType is empty");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)groupName)) {
            if (callback != null) {
                callback.onError(6017, "groupName is empty");
            }
            return;
        }
        if (groupType.equalsIgnoreCase("Work")) {
            groupType = "Private";
        } else if (groupType.equalsIgnoreCase("Meeting")) {
            groupType = "ChatRoom";
        } else if (groupType.equalsIgnoreCase("Private")) {
            groupType = "Private";
        } else if (groupType.equalsIgnoreCase("ChatRoom")) {
            groupType = "ChatRoom";
        } else if (groupType.equalsIgnoreCase("Public")) {
            groupType = "Public";
        } else if (groupType.equalsIgnoreCase("AVChatRoom")) {
            groupType = "AVChatRoom";
        }
        GroupManager.getInstance().createGroup(groupType, groupID, groupName, new IMCallback<String>(callback){

            @Override
            public void success(String data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void joinGroup(String groupID, String message, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            if (callback != null) {
                callback.onError(6017, "invalid groupID");
            }
            return;
        }
        GroupManager.getInstance().joinGroup(groupID, message, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void quitGroup(String groupID, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            if (callback != null) {
                callback.onError(6017, "invalid groupID");
            }
            return;
        }
        GroupManager.getInstance().quitGroup(groupID, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void dismissGroup(String groupID, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            if (callback != null) {
                callback.onError(6017, "invalid groupID");
            }
            return;
        }
        GroupManager.getInstance().dismissGroup(groupID, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getUsersInfo(List<String> userIDList, final V2TIMValueCallback<List<V2TIMUserFullInfo>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "invalid userIDList");
            }
            return;
        }
        V2TIMValueCallback<List<UserInfo>> v2Callback = new V2TIMValueCallback<List<UserInfo>>(){

            @Override
            public void onSuccess(List<UserInfo> userInfos) {
                if (callback != null) {
                    ArrayList<V2TIMUserFullInfo> v2UserInfoList = new ArrayList<V2TIMUserFullInfo>();
                    for (UserInfo item : userInfos) {
                        V2TIMUserFullInfo v2UserInfo = new V2TIMUserFullInfo();
                        v2UserInfo.setUserInfo(item);
                        v2UserInfoList.add(v2UserInfo);
                    }
                    callback.onSuccess(v2UserInfoList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getUsersInfo(userIDList, new IMCallback<List<UserInfo>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<UserInfo> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setSelfInfo(V2TIMUserFullInfo v2TIMUserFullInfo, V2TIMCallback callback) {
        if (v2TIMUserFullInfo == null) {
            if (callback != null) {
                callback.onError(6017, "invalid params");
            }
            return;
        }
        HashMap<String, Object> modifyParams = v2TIMUserFullInfo.getModifyParams();
        if (modifyParams == null || modifyParams.isEmpty()) {
            if (callback != null) {
                callback.onError(6017, "no changed info");
            }
            return;
        }
        RelationshipManager.getInstance().setSelfInfo(v2TIMUserFullInfo.getModifyParams(), new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void subscribeUserInfo(List<String> userIDList, V2TIMCallback callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "invalid userIDList");
            }
            return;
        }
        RelationshipManager.getInstance().subscribeUserInfo(userIDList, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void searchUsers(V2TIMUserSearchParam searchParam, final V2TIMValueCallback<V2TIMUserSearchResult> callback) {
        if (searchParam == null) {
            if (callback != null) {
                callback.onError(6017, "searchParam is null");
            }
            return;
        }
        if (searchParam.getKeywordList() == null || searchParam.getKeywordList().size() == 0) {
            if (callback != null) {
                callback.onError(6017, "empty keywordList");
            }
            return;
        }
        V2TIMValueCallback<UserSearchResult> v2Callback = new V2TIMValueCallback<UserSearchResult>(){

            @Override
            public void onSuccess(UserSearchResult searchResult) {
                V2TIMUserSearchResult v2TIMUserSearchResult = new V2TIMUserSearchResult();
                v2TIMUserSearchResult.setUserSearchResult(searchResult);
                callback.onSuccess(v2TIMUserSearchResult);
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().searchUsers(searchParam.getUserSearchParam(), new IMCallback<UserSearchResult>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(UserSearchResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        BaseManager.getInstance().reportTUIComponentUsage(6L);
    }

    @Override
    public void unsubscribeUserInfo(List<String> userIDList, V2TIMCallback callback) {
        RelationshipManager.getInstance().unsubscribeUserInfo(userIDList, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getUserStatus(List<String> userIDList, final V2TIMValueCallback<List<V2TIMUserStatus>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "invalid userIDList");
            }
            return;
        }
        V2TIMValueCallback<List<UserStatus>> v2Callback = new V2TIMValueCallback<List<UserStatus>>(){

            @Override
            public void onSuccess(List<UserStatus> userStatusList) {
                if (callback != null) {
                    ArrayList<V2TIMUserStatus> v2TIMUserStatusList = new ArrayList<V2TIMUserStatus>();
                    for (UserStatus item : userStatusList) {
                        V2TIMUserStatus v2TIMUserStatus = new V2TIMUserStatus();
                        v2TIMUserStatus.setUserStatus(item);
                        v2TIMUserStatusList.add(v2TIMUserStatus);
                    }
                    callback.onSuccess(v2TIMUserStatusList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getUserStatus(userIDList, new IMCallback<List<UserStatus>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<UserStatus> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setSelfStatus(V2TIMUserStatus v2TIMUserStatus, V2TIMCallback callback) {
        if (v2TIMUserStatus == null) {
            if (callback != null) {
                callback.onError(6017, "invalid params");
            }
            return;
        }
        UserStatus userStatus = v2TIMUserStatus.getUserStatus();
        if (userStatus == null && callback != null) {
            callback.onError(6017, "no userStatus");
        }
        RelationshipManager.getInstance().setSelfStatus(userStatus, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void subscribeUserStatus(List<String> userIDList, V2TIMCallback callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "invalid userIDList");
            }
            return;
        }
        RelationshipManager.getInstance().subscribeUserStatus(userIDList, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void unsubscribeUserStatus(List<String> userIDList, V2TIMCallback callback) {
        RelationshipManager.getInstance().unsubscribeUserStatus(userIDList, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void callExperimentalAPI(String api, Object param, V2TIMValueCallback<Object> callback) {
        V2TIMManagerExperimentImpl.getInstance().callExperimentalAPI(api, param, callback);
    }

    @Override
    public Object callExperimentalAPI(String api, Object param) {
        return V2TIMManagerExperimentImpl.getInstance().callExperimentalAPI(api, param);
    }

    private void initSDKListener() {
        this.mSDKListener = new SDKListener(){

            @Override
            public void onConnecting() {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                            v2TIMSDKListener.onConnecting();
                        }
                    }
                });
            }

            @Override
            public void onConnectSuccess() {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                            v2TIMSDKListener.onConnectSuccess();
                        }
                    }
                });
            }

            @Override
            public void onConnectFailed(final int code, final String error) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                            v2TIMSDKListener.onConnectFailed(code, error);
                        }
                    }
                });
            }

            @Override
            public void onKickedOffline() {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                            v2TIMSDKListener.onKickedOffline();
                        }
                    }
                });
            }

            @Override
            public void onUserSigExpired() {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                            v2TIMSDKListener.onUserSigExpired();
                        }
                    }
                });
            }

            public void onUninited() {
                BaseManager.getInstance().unInitSDK(false);
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                            v2TIMSDKListener.onExperimentalNotify("onUninited", "");
                        }
                    }
                });
            }

            public void onLogout() {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                            v2TIMSDKListener.onExperimentalNotify("onLogout", "");
                        }
                    }
                });
            }

            @Override
            public void onSelfInfoUpdated(final UserInfo info) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                            V2TIMUserFullInfo v2UserInfo = new V2TIMUserFullInfo();
                            v2UserInfo.setUserInfo(info);
                            v2TIMSDKListener.onSelfInfoUpdated(v2UserInfo);
                        }
                    }
                });
            }

            @Override
            public void onLog(final int logLevel, final String logContent) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (V2TIMManagerImpl.this.mLogListener != null) {
                            V2TIMManagerImpl.this.mLogListener.onLog(logLevel, logContent);
                        }
                    }
                });
            }

            @Override
            public void onUserStatusChanged(final List<UserStatus> userStatusList) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                            ArrayList<V2TIMUserStatus> v2TIMUserStatusList = new ArrayList<V2TIMUserStatus>();
                            for (UserStatus item : userStatusList) {
                                V2TIMUserStatus v2TIMUserStatus = new V2TIMUserStatus();
                                v2TIMUserStatus.setUserStatus(item);
                                v2TIMUserStatusList.add(v2TIMUserStatus);
                            }
                            v2TIMSDKListener.onUserStatusChanged(v2TIMUserStatusList);
                        }
                    }
                });
            }

            @Override
            public void onUserInfoChanged(final List<UserInfo> userInfoList) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                            ArrayList<V2TIMUserFullInfo> v2TIMUserInfoList = new ArrayList<V2TIMUserFullInfo>();
                            for (UserInfo item : userInfoList) {
                                V2TIMUserFullInfo v2TIMUserInfo = new V2TIMUserFullInfo();
                                v2TIMUserInfo.setUserInfo(item);
                                v2TIMUserInfoList.add(v2TIMUserInfo);
                            }
                            v2TIMSDKListener.onUserInfoChanged(v2TIMUserInfoList);
                        }
                    }
                });
            }

            @Override
            public void onAllReceiveMessageOptChanged(final ReceiveMessageOptInfo option) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                            V2TIMReceiveMessageOptInfo v2TIMReceiveMessageOptInfo = new V2TIMReceiveMessageOptInfo();
                            v2TIMReceiveMessageOptInfo.setReceiveMessageOptInfo(option);
                            v2TIMSDKListener.onAllReceiveMessageOptChanged(v2TIMReceiveMessageOptInfo);
                        }
                    }
                });
            }

            @Override
            public void onExperimentalNotify(final String key, final Object param) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                            v2TIMSDKListener.onExperimentalNotify(key, param);
                        }
                    }
                });
            }
        };
    }

    private void initMessageListener() {
        this.mMessageInternalListener = new MessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceiveNewMessage(List<Message> messageList) {
                if (messageList == null || messageList.isEmpty()) {
                    return;
                }
                for (Message message : messageList) {
                    Object object;
                    int messageType = message.getMessageType();
                    V2TIMMessage v2TIMMessage = new V2TIMMessage();
                    v2TIMMessage.setMessage(message);
                    int elementType = v2TIMMessage.getElemType();
                    V2TIMUserInfo v2TIMUserInfo = null;
                    V2TIMGroupMemberInfo v2TIMGroupMemberInfo = null;
                    if (messageType == Message.MESSAGE_TYPE_C2C) {
                        v2TIMUserInfo = new V2TIMUserInfo();
                        v2TIMUserInfo.setUserID(v2TIMMessage.getSender());
                        v2TIMUserInfo.setNickName(v2TIMMessage.getNickName());
                        v2TIMUserInfo.setFaceUrl(v2TIMMessage.getFaceUrl());
                    } else if (messageType == Message.MESSAGE_TYPE_GROUP) {
                        v2TIMGroupMemberInfo = new V2TIMGroupMemberInfo();
                        GroupMemberInfo groupMemberInfo = new GroupMemberInfo();
                        groupMemberInfo.setGroupID(message.getGroupID());
                        groupMemberInfo.setUserID(message.getSenderUserID());
                        groupMemberInfo.setNickname(message.getNickName());
                        groupMemberInfo.setNameCard(message.getNameCard());
                        groupMemberInfo.setFaceUrl(message.getFaceUrl());
                        groupMemberInfo.setFriendRemark(message.getFriendRemark());
                        v2TIMGroupMemberInfo.setGroupMemberInfo(groupMemberInfo);
                    }
                    if (elementType == 1) {
                        V2TIMTextElem v2TIMTextElem = v2TIMMessage.getTextElem();
                        object = V2TIMManagerImpl.this.mLockObject;
                        synchronized (object) {
                            for (V2TIMSimpleMsgListener v2TIMSimpleMsgListener : V2TIMManagerImpl.this.mV2TIMSimpleMsgListenerList) {
                                if (messageType == Message.MESSAGE_TYPE_C2C) {
                                    v2TIMSimpleMsgListener.onRecvC2CTextMessage(v2TIMMessage.getMsgID(), v2TIMUserInfo, v2TIMTextElem.getText());
                                    continue;
                                }
                                if (messageType != Message.MESSAGE_TYPE_GROUP) continue;
                                v2TIMSimpleMsgListener.onRecvGroupTextMessage(v2TIMMessage.getMsgID(), message.getGroupID(), v2TIMGroupMemberInfo, v2TIMTextElem.getText());
                            }
                            continue;
                        }
                    }
                    if (elementType != 2) continue;
                    V2TIMCustomElem v2TIMCustomElem = v2TIMMessage.getCustomElem();
                    object = V2TIMManagerImpl.this.mLockObject;
                    synchronized (object) {
                        for (V2TIMSimpleMsgListener v2TIMSimpleMsgListener : V2TIMManagerImpl.this.mV2TIMSimpleMsgListenerList) {
                            if (messageType == Message.MESSAGE_TYPE_C2C) {
                                v2TIMSimpleMsgListener.onRecvC2CCustomMessage(v2TIMMessage.getMsgID(), v2TIMUserInfo, v2TIMCustomElem.getData());
                                continue;
                            }
                            if (messageType != Message.MESSAGE_TYPE_GROUP) continue;
                            v2TIMSimpleMsgListener.onRecvGroupCustomMessage(v2TIMMessage.getMsgID(), v2TIMMessage.getGroupID(), v2TIMGroupMemberInfo, v2TIMCustomElem.getData());
                        }
                    }
                }
            }

            @Override
            public void onReceiveC2CMessageReceipt(List<C2CMessageReceipt> receiptList) {
            }

            @Override
            public void onReceiveGroupMessageReceipt(List<GroupMessageReceipt> receiptList) {
            }

            @Override
            public void onReceiveMessageRevoked(Map<MessageKey, Map<UserInfo, String>> revokeInfoMap, boolean isPushMessage) {
            }

            @Override
            public void onReceiveMessageModified(List<Message> messageList) {
            }
        };
        MessageCenter.getInstance().addMessageListener(this.mMessageInternalListener);
    }

    private void initGroupListener() {
        this.mGroupInternalListener = new GroupListener(){

            V2TIMGroupMemberInfo convertToV2GroupMemberInfo(GroupMemberInfo memberInfo) {
                V2TIMGroupMemberInfo v2MemberInfo = new V2TIMGroupMemberInfo();
                if (memberInfo != null) {
                    v2MemberInfo.setGroupMemberInfo(memberInfo);
                }
                return v2MemberInfo;
            }

            List<V2TIMGroupMemberInfo> convertToV2GroupMemberInfoList(List<GroupMemberInfo> memberList) {
                ArrayList<V2TIMGroupMemberInfo> v2MemberList = new ArrayList<V2TIMGroupMemberInfo>();
                if (memberList != null) {
                    for (GroupMemberInfo item : memberList) {
                        v2MemberList.add(this.convertToV2GroupMemberInfo(item));
                    }
                }
                return v2MemberList;
            }

            @Override
            public void onMemberEnter(String groupID, List<GroupMemberInfo> memberList) {
                List<V2TIMGroupMemberInfo> groupMemberInfoList = this.convertToV2GroupMemberInfoList(memberList);
                List<V2TIMGroupMemberInfo> unmodifiableList = Collections.unmodifiableList(groupMemberInfoList);
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onMemberEnter(groupID, unmodifiableList);
                }
            }

            @Override
            public void onMemberLeave(String groupID, GroupMemberInfo member) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onMemberLeave(groupID, this.convertToV2GroupMemberInfo(member));
                }
            }

            @Override
            public void onMemberInvited(String groupID, GroupMemberInfo opUser, List<GroupMemberInfo> memberList) {
                List<V2TIMGroupMemberInfo> groupMemberInfoList = this.convertToV2GroupMemberInfoList(memberList);
                List<V2TIMGroupMemberInfo> unmodifiableList = Collections.unmodifiableList(groupMemberInfoList);
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onMemberInvited(groupID, this.convertToV2GroupMemberInfo(opUser), unmodifiableList);
                }
            }

            @Override
            public void onMemberKicked(String groupID, GroupMemberInfo opUser, List<GroupMemberInfo> memberList, String reason) {
                V2TIMGroupMemberInfo opUserInfo = this.convertToV2GroupMemberInfo(opUser);
                List<V2TIMGroupMemberInfo> groupMemberInfoList = this.convertToV2GroupMemberInfoList(memberList);
                List<V2TIMGroupMemberInfo> unmodifiableList = Collections.unmodifiableList(groupMemberInfoList);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("groupID", groupID);
                result.put("opUser", opUserInfo);
                result.put("memberList", unmodifiableList);
                result.put("reason", reason);
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onMemberKicked(groupID, opUserInfo, unmodifiableList);
                }
                for (V2TIMSDKListener v2TIMSDKListener : V2TIMManagerImpl.this.mIMSDKListenerList) {
                    v2TIMSDKListener.onExperimentalNotify("onMemberKicked", result);
                }
            }

            @Override
            public void onMemberInfoChanged(String groupID, List<GroupMemberInfoChangeItem> groupMemberChangeInfoList) {
                ArrayList<V2TIMGroupMemberChangeInfo> v2GroupMemberChangeInfoList = new ArrayList<V2TIMGroupMemberChangeInfo>();
                for (GroupMemberInfoChangeItem item : groupMemberChangeInfoList) {
                    V2TIMGroupMemberChangeInfo v2GroupMemberChangeInfo = new V2TIMGroupMemberChangeInfo();
                    v2GroupMemberChangeInfo.setGroupMemberInfoChangeItem(item);
                    v2GroupMemberChangeInfoList.add(v2GroupMemberChangeInfo);
                }
                List<V2TIMGroupMemberChangeInfo> unmodifiableList = Collections.unmodifiableList(v2GroupMemberChangeInfoList);
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onMemberInfoChanged(groupID, unmodifiableList);
                }
            }

            @Override
            public void onAllGroupMembersMuted(String groupID, boolean isMute) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onAllGroupMembersMuted(groupID, isMute);
                }
            }

            @Override
            public void onMemberMarkChanged(String groupID, List<String> memberIDList, int markType, boolean enableMark) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onMemberMarkChanged(groupID, memberIDList, markType, enableMark);
                }
            }

            @Override
            public void onGroupCreated(String groupID) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onGroupCreated(groupID);
                }
            }

            @Override
            public void onGroupDismissed(String groupID, GroupMemberInfo opUser) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onGroupDismissed(groupID, this.convertToV2GroupMemberInfo(opUser));
                }
            }

            @Override
            public void onGroupRecycled(String groupID, GroupMemberInfo opUser) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onGroupRecycled(groupID, this.convertToV2GroupMemberInfo(opUser));
                }
            }

            @Override
            public void onGroupInfoChanged(String groupID, List<GroupInfoChangeItem> changeInfos) {
                ArrayList<V2TIMGroupChangeInfo> v2GroupChangeInfoList = new ArrayList<V2TIMGroupChangeInfo>();
                for (GroupInfoChangeItem item : changeInfos) {
                    V2TIMGroupChangeInfo v2GroupChangeInfo = new V2TIMGroupChangeInfo();
                    v2GroupChangeInfo.setGroupInfoChangeItem(item);
                    v2GroupChangeInfoList.add(v2GroupChangeInfo);
                }
                List<V2TIMGroupChangeInfo> unmodifiableList = Collections.unmodifiableList(v2GroupChangeInfoList);
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onGroupInfoChanged(groupID, unmodifiableList);
                }
            }

            @Override
            public void onReceiveJoinApplication(String groupID, GroupMemberInfo member, String opReason) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onReceiveJoinApplication(groupID, this.convertToV2GroupMemberInfo(member), opReason);
                }
            }

            @Override
            public void onApplicationProcessed(String groupID, GroupMemberInfo opUser, boolean isAgreeJoin, String opReason) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onApplicationProcessed(groupID, this.convertToV2GroupMemberInfo(opUser), isAgreeJoin, opReason);
                }
            }

            @Override
            public void onReceiveInviteApplication(String groupID, int applicationType, GroupMemberInfo inviter, List<GroupMemberInfo> inviteeList, String opReason) {
                if (GroupApplication.REQUEST_TYPE_INVITE_TO_ADMIN == applicationType) {
                    for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                        for (GroupMemberInfo invitee : inviteeList) {
                            groupListener.onReceiveJoinApplication(groupID, this.convertToV2GroupMemberInfo(invitee), opReason);
                        }
                    }
                }
            }

            @Override
            public void onGrantAdministrator(String groupID, GroupMemberInfo opUser, List<GroupMemberInfo> memberList) {
                List<V2TIMGroupMemberInfo> groupMemberInfoList = this.convertToV2GroupMemberInfoList(memberList);
                List<V2TIMGroupMemberInfo> unmodifiableList = Collections.unmodifiableList(groupMemberInfoList);
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onGrantAdministrator(groupID, this.convertToV2GroupMemberInfo(opUser), unmodifiableList);
                }
            }

            @Override
            public void onRevokeAdministrator(String groupID, GroupMemberInfo opUser, List<GroupMemberInfo> memberList) {
                List<V2TIMGroupMemberInfo> groupMemberInfoList = this.convertToV2GroupMemberInfoList(memberList);
                List<V2TIMGroupMemberInfo> unmodifiableList = Collections.unmodifiableList(groupMemberInfoList);
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onRevokeAdministrator(groupID, this.convertToV2GroupMemberInfo(opUser), unmodifiableList);
                }
            }

            @Override
            public void onQuitFromGroup(String groupID) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onQuitFromGroup(groupID);
                }
            }

            @Override
            public void onReceiveRESTCustomData(String groupID, byte[] customData) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onReceiveRESTCustomData(groupID, (byte[])customData.clone());
                }
            }

            @Override
            public void onGroupAttributeChanged(String groupID, Map<String, String> groupAttributeMap) {
                Map<String, String> unmodifiableMap = Collections.unmodifiableMap(groupAttributeMap);
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onGroupAttributeChanged(groupID, unmodifiableMap);
                }
            }

            @Override
            public void onTopicCreated(String groupID, String topicID) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onTopicCreated(groupID, topicID);
                }
            }

            @Override
            public void onTopicDeleted(String groupID, List<String> topicIDList) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onTopicDeleted(groupID, topicIDList);
                }
            }

            @Override
            public void onTopicInfoChanged(String groupID, TopicInfo topicInfo) {
                V2TIMTopicInfo v2TIMTopicInfo = new V2TIMTopicInfo();
                v2TIMTopicInfo.setTopicInfo(topicInfo);
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    groupListener.onTopicInfoChanged(groupID, v2TIMTopicInfo);
                }
            }

            @Override
            public void onGroupCounterChanged(String groupID, Map<String, Long> counters) {
                for (V2TIMGroupListener groupListener : V2TIMManagerImpl.this.mGroupListenerList) {
                    for (Map.Entry<String, Long> item : counters.entrySet()) {
                        groupListener.onGroupCounterChanged(groupID, item.getKey(), item.getValue());
                    }
                }
            }

            @Override
            public void onGroupCounterDeleted(String groupID, List<String> keys) {
            }
        };
        GroupManager.getInstance().setGroupListener(this.mGroupInternalListener);
    }

    private static class V2TIMManagerImplHolder {
        private static final V2TIMManagerImpl v2TIMManagerImpl = new V2TIMManagerImpl();

        private V2TIMManagerImplHolder() {
        }
    }
}

