package com.tencent.imsdk.community;

import android.text.TextUtils;
import com.tencent.imsdk.conversation.ConversationAtInfo;
import com.tencent.imsdk.group.GroupMemberInfo;
import com.tencent.imsdk.message.DraftMessage;
import com.tencent.imsdk.message.Message;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class TopicInfo implements Serializable {
    public static int TOPIC_ADD_OPTION_FORBID_ANY = 1;
    public static int TOPIC_ADD_OPTION_NEED_AUTHENTICATION = 2;
    public static int TOPIC_ADD_OPTION_ALLOW_ANY = 3;

    public static long TOPIC_INFO_MODIFY_FLAG_NONE = 0;
    public static long TOPIC_INFO_MODIFY_FLAG_NAME = 0x1;
    public static long TOPIC_INFO_MODIFY_FLAG_NOTIFICATION = (0x1 << 1);
    public static long TOPIC_INFO_MODIFY_FLAG_INTRODUCTION = (0x1 << 2);
    public static long TOPIC_INFO_MODIFY_FLAG_FACE_URL = (0x1 << 3);
    public static long TOPIC_INFO_MODIFY_FLAG_MUTE_ALL = (0x1 << 8);
    public static long TOPIC_INFO_MODIFY_FLAG_TOPIC_CUSTOM_STRING = (0x1 << 11);
    public static long TOPIC_INFO_MODIFY_FLAG_DRAFT = (0x1 << 14);
    public static long TOPIC_INFO_MODIFY_FLAG_DEFAULT_PERMISSIONS = (0x1 << 15);
    public static long TOPIC_INFO_MODIFY_FLAG_TOPIC_TYPE = (0x1 << 24);
    public static long TOPIC_INFO_MODIFY_FLAG_TOPIC_ADD_OPT = (0x1 << 25);
    public static long TOPIC_INFO_MODIFY_FLAG_TOPIC_APPROVE_OPT = (0x1 << 26);

    private String topicID;
    private String topicType;
    private byte[] topicNameBytes;
    private byte[] introductionBytes;
    private byte[] notificationBytes;
    private String faceUrl;
    private String topicCustomString;
    private boolean isAllMute;
    private int messageReceiveOption;
    private long selfMuteTime;
    private long unreadCount;
    private Message lastMessage;
    private long readSequence;
    private List<ConversationAtInfo> conversationAtInfoList = new ArrayList<>();
    private DraftMessage draftMessage;
    private long createTime;
    private int topicAddOpt = TOPIC_ADD_OPTION_ALLOW_ANY;
    private int topicApproveOpt = TOPIC_ADD_OPTION_ALLOW_ANY;
    private List<GroupMemberInfo> memberList;
    private long memberMaxCount;
    private long defaultPermissions;
    private boolean inheritMessageReceiveOptionFromCommunity;

    public String getTopicID() {
        return topicID;
    }

    public void setTopicID(String topicID) {
        this.topicID = topicID;
    }

    public String getTopicType() {
        return topicType;
    }

    public void setTopicType(String topicType) {
        this.topicType = topicType;
    }

    public String getTopicName() {
        String topicName = "";
        if (topicNameBytes != null && topicNameBytes.length > 0) {
            try {
                topicName = new String(topicNameBytes, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return topicName;
    }

    public void setTopicName(String topicName) {
        if (!TextUtils.isEmpty(topicName)) {
            try {
                this.topicNameBytes = topicName.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public String getFaceUrl() {
        return faceUrl;
    }

    public void setFaceUrl(String faceUrl) {
        this.faceUrl = faceUrl;
    }

    public String getIntroduction() {
        String introduction = "";
        if (introductionBytes != null && introductionBytes.length > 0) {
            try {
                introduction = new String(introductionBytes, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return introduction;
    }

    public void setIntroduction(String introduction) {
        if (!TextUtils.isEmpty(introduction)) {
            try {
                this.introductionBytes = introduction.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public String getNotification() {
        String notification = "";
        if (notificationBytes != null && notificationBytes.length > 0) {
            try {
                notification = new String(notificationBytes, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return notification;
    }

    public void setNotification(String notification) {
        if (!TextUtils.isEmpty(notification)) {
            try {
                this.notificationBytes = notification.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public String getTopicCustomString() {
        return topicCustomString;
    }

    public void setTopicCustomString(String topicCustomString) {
        this.topicCustomString = topicCustomString;
    }

    public boolean isAllMute() {
        return isAllMute;
    }

    public void setAllMute(boolean allMute) {
        isAllMute = allMute;
    }

    public long getSelfMuteTime() {
        return selfMuteTime;
    }

    public void setSelfMuteTime(long selfMuteTime) {
        this.selfMuteTime = selfMuteTime;
    }

    public int getMessageReceiveOption() {
        return messageReceiveOption;
    }

    public void setMessageReceiveOption(int messageReceiveOption) {
        this.messageReceiveOption = messageReceiveOption;
    }

    public long getUnreadCount() {
        return unreadCount;
    }

    public void setUnreadCount(long unreadCount) {
        this.unreadCount = unreadCount;
    }

    public Message getLastMessage() {
        return lastMessage;
    }

    public void setLastMessage(Message lastMessage) {
        this.lastMessage = lastMessage;
    }

    public long getReadSequence() {
        return readSequence;
    }

    public List<ConversationAtInfo> getConversationAtInfoList() {
        return conversationAtInfoList;
    }

    protected void addConversationAtInfoList(ConversationAtInfo conversationAtInfo) {
        this.conversationAtInfoList.add(conversationAtInfo);
    }

    public DraftMessage getDraftMessage() {
        return draftMessage;
    }

    public void setDraftMessage(DraftMessage draftMessage) {
        this.draftMessage = draftMessage;
    }

    public long getCreateTime() {
        return createTime;
    }

    public void setTopicAddOpt(int topicAddOpt) {
        this.topicAddOpt = topicAddOpt;
    }

    public int getTopicAddOpt() {
        return this.topicAddOpt;
    }

    public void setTopicApproveOpt(int approveOpt) {
        this.topicApproveOpt = approveOpt;
    }

    public int getTopicApproveOpt() {
        return this.topicApproveOpt;
    }

    public void setMemberList(List<GroupMemberInfo> memberList) {
        this.memberList = memberList;
    }

    public void setMemberMaxCount(long memberMaxCount) {
        this.memberMaxCount = memberMaxCount;
    }

    public long getMemberMaxCount() {
        return this.memberMaxCount;
    }

    public long getDefaultPermissions() {
        return defaultPermissions;
    }

    public void setDefaultPermissions(long defaultPermissions) {
        this.defaultPermissions = defaultPermissions;
    }

    public boolean isInheritMessageReceiveOptionFromCommunity() {
        return inheritMessageReceiveOptionFromCommunity;
    }

    public void setInheritMessageReceiveOptionFromCommunity(boolean inheritMessageReceiveOptionFromCommunity) {
        this.inheritMessageReceiveOptionFromCommunity = inheritMessageReceiveOptionFromCommunity;
    }
}
