package com.tencent.imsdk.message;

import android.text.TextUtils;
import com.tencent.imsdk.v2.V2TIMMessage;

public class FileElement extends MessageBaseElement {
    private String fileUUID;
    private String fileName;
    private String filePath;
    private int fileSize;
    private String fileDownloadUrl;
    private int fileBusinessID;

    public FileElement() {
        setElementType(V2TIMMessage.V2TIM_ELEM_TYPE_FILE);
    }

    public String getFileUUID() {
        return fileUUID;
    }

    public void setFileUUID(String fileUUID) {
        this.fileUUID = fileUUID;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getFileSize() {
        return fileSize;
    }

    public void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileDownloadUrl() {
        return fileDownloadUrl;
    }

    public void setFileDownloadUrl(String fileDownloadUrl) {
        this.fileDownloadUrl = fileDownloadUrl;
    }

    public int getFileBusinessID() {
        return fileBusinessID;
    }

    @Override
    public boolean update(MessageBaseElement element) {
        if (elementType == element.elementType) {
            FileElement fileElement = (FileElement) element;
            if (!TextUtils.isEmpty(filePath) && filePath.equals(fileElement.filePath)) {
                fileUUID = fileElement.fileUUID;
                fileName = fileElement.fileName;
                fileSize = fileElement.fileSize;
                fileDownloadUrl = fileElement.fileDownloadUrl;
                fileBusinessID = fileElement.fileBusinessID;

                return true;
            }
        }

        return false;
    }
}
