package com.tencent.imsdk.message;

import java.io.Serializable;

public class MessageOfflinePushInfo implements Serializable {
    public static final int OFFLINE_PUSH_FLAG_DEFAULT = 0;
    public static final int OFFLINE_PUSH_FLAG_NO_PUSH = 1;

    public static final int OFFLINE_APNS_BADGE_MODE_DEFAULT = 0;
    public static final int OFFLINE_APNS_BADGE_MODE_IGNORE = 1;

    public static final int OFFLINE_HARMONY_BADGE_MODE_DEFAULT = 0;
    public static final int OFFLINE_HARMONY_BADGE_MODE_IGNORE = 1;

    private String title;
    private String description;
    private byte[] extension;
    private String soundFilePath;
    private int pushFlag;
    private String vendorParams;
    private APNSOfflinePushInfo apnsConfig = new APNSOfflinePushInfo();
    private AndroidOfflinePushInfo androidConfig = new AndroidOfflinePushInfo();
    private HarmonyOfflinePushInfo harmonyConfig = new HarmonyOfflinePushInfo();

    public class APNSOfflinePushInfo implements Serializable {
        private String title;
        private String description;
        private String soundFilePath;
        private int badgeMode;
        private int iOSPushType = 0;
        private String iOSImageUrl;
        private String interruptionLevel;
        private int backgroundNotification;

        public void setSoundFilePath(String soundFilePath) {
            this.soundFilePath = soundFilePath;
        }

        public void setBadgeMode(int badgeMode) {
            this.badgeMode = badgeMode;
        }

        public void setIOSPushType(int iOSPushType) {
            this.iOSPushType = iOSPushType;
        }

        public void setIOSImageUrl(String iOSImageUrl) {
            this.iOSImageUrl = iOSImageUrl;
        }

        public void setInterruptionLevel(String level) {
            this.interruptionLevel = level;
        }

        public void setBackgroundNotification(int backgroundNotification) {
            this.backgroundNotification = backgroundNotification;
        }
    }

    public class AndroidOfflinePushInfo implements Serializable {
        private String title;
        private String description;
        private String soundFilePath;
        private int notifyMode;
        private String oppoChannelID;
        private String fcmChannelID;
        private String xiaomiChannelID;
        private int vivoClassification = 1;
        private String vivoCategory;
        private String huaweiCategory;
        private String oppoCategory;
        private int oppoNotifyLevel;
        private String honorImportance;
        private String huaweiImageUrl;
        private String honorImageUrl;
        private String fcmImageUrl;
        private int meizuNotifyType = -1;

        public void setOppoChannelID(String oppoChannelID) {
            this.oppoChannelID = oppoChannelID;
        }

        public void setFCMChannelID(String fcmChannelID) {
            this.fcmChannelID = fcmChannelID;
        }

        public void setXiaoMiChannelID(String xiaomiChannelID) {
            this.xiaomiChannelID = xiaomiChannelID;
        }

        public void setVivoClassification(int vivoClassification) {
            this.vivoClassification = vivoClassification;
        }

        public void setVivoCategory(String vivoCategory) {
            this.vivoCategory = vivoCategory;
        }

        public void setSoundFilePath(String soundFilePath) {
            this.soundFilePath = soundFilePath;
        }

        public void setHuaWeiCategory(String huaweiCategory) {
            this.huaweiCategory = huaweiCategory;
        }

        public void setHuaWeiImageUrl(String huaweiImageUrl) {
            this.huaweiImageUrl = huaweiImageUrl;
        }

        public void setHonorImageUrl(String honorImageUrl) {
            this.honorImageUrl = honorImageUrl;
        }

        public void setFCMImageUrl(String fcmImageUrl) {
            this.fcmImageUrl = fcmImageUrl;
        }

        public String getSoundFilePath() {
            return this.soundFilePath;
        }

        public void setOppoCategory(String oppoCategory) {
            this.oppoCategory = oppoCategory;
        }

        public void setOppoNotifyLevel(int level) {
            this.oppoNotifyLevel = level;
        }

        public void setHonorImportance(String importance) {
            this.honorImportance = importance;
        }

        public void setMeizuNotifyType(int type) {
            this.meizuNotifyType = type;
        }
    }

    public class HarmonyOfflinePushInfo implements Serializable {
        private String title;
        private String description;
        private String category;
        private String imageUrl;
        private int badgeMode = 0;

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public void setBadgeMode(int badgeMode) {
            this.badgeMode = badgeMode;
        }
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public byte[] getExtension() {
        return extension;
    }

    public void setExtension(byte[] extension) {
        this.extension = extension;
    }

    public String getSoundFilePath() {
        return soundFilePath;
    }

    public void setSoundFilePath(String soundFilePath) {
        this.soundFilePath = soundFilePath;
    }

    public int getPushFlag() {
        return pushFlag;
    }

    public void setPushFlag(int pushFlag) {
        this.pushFlag = pushFlag;
    }

    public APNSOfflinePushInfo getApnsConfig() {
        return apnsConfig;
    }

    public void setApnsConfig(APNSOfflinePushInfo apnsConfig) {
        this.apnsConfig = apnsConfig;
    }

    public AndroidOfflinePushInfo getAndroidConfig() {
        return androidConfig;
    }

    public void setAndroidConfig(AndroidOfflinePushInfo androidConfig) {
        this.androidConfig = androidConfig;
    }

    public HarmonyOfflinePushInfo getHarmonyConfig() {
        return harmonyConfig;
    }

    public void setHarmonyConfig(HarmonyOfflinePushInfo harmonyConfig) {
        this.harmonyConfig = harmonyConfig;
    }

    public void setVendorParams(String vendorParams) {
        this.vendorParams = vendorParams;
    }

    public String getVendorParams() {
        return this.vendorParams;
    }
}
