package com.tencent.imsdk.message;

import android.text.TextUtils;
import com.tencent.imsdk.v2.V2TIMMessage;
import java.io.UnsupportedEncodingException;

public class TextElement extends MessageBaseElement {
    private byte[] textContentBytes;

    public TextElement() {
        setElementType(V2TIMMessage.V2TIM_ELEM_TYPE_TEXT);
    }

    public String getTextContent() {
        String textContent = "";
        if (textContentBytes != null && textContentBytes.length > 0) {
            try {
                textContent = new String(textContentBytes, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return textContent;
    }

    public void setTextContent(String textContent) {
        if (!TextUtils.isEmpty(textContent)) {
            try {
                this.textContentBytes = textContent.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }
}
