package com.tencent.imsdk.message;

import android.text.TextUtils;
import com.tencent.imsdk.v2.V2TIMMessage;

public class VideoElement extends MessageBaseElement {
    private String videoUUID;
    private String videoType;
    private String videoFilePath;
    private int videoFileSize;
    private int videoDuration;
    private String videoDownloadUrl;
    private int videoBusinessID;

    private String snapshotUUID;
    private String snapshotType;
    private String snapshotFilePath;
    private int snapshotFileSize;
    private int snapshotWidth;
    private int snapshotHeight;
    private String snapshotDownloadUrl;

    public VideoElement() {
        setElementType(V2TIMMessage.V2TIM_ELEM_TYPE_VIDEO);
    }

    public String getVideoUUID() {
        return videoUUID;
    }

    public void setVideoUUID(String videoUUID) {
        this.videoUUID = videoUUID;
    }

    public String getVideoType() {
        return videoType;
    }

    public void setVideoType(String videoType) {
        this.videoType = videoType;
    }

    public String getVideoFilePath() {
        return videoFilePath;
    }

    public void setVideoFilePath(String videoFilePath) {
        this.videoFilePath = videoFilePath;
    }

    public int getVideoFileSize() {
        return videoFileSize;
    }

    public void setVideoFileSize(int videoFileSize) {
        this.videoFileSize = videoFileSize;
    }

    public int getVideoDuration() {
        return videoDuration;
    }

    public void setVideoDuration(int duration) {
        this.videoDuration = duration;
    }

    public String getVideoDownloadUrl() {
        return videoDownloadUrl;
    }

    public void setVideoDownloadUrl(String videoDownloadUrl) {
        this.videoDownloadUrl = videoDownloadUrl;
    }

    public int getVideoBusinessID() {
        return videoBusinessID;
    }

    public String getSnapshotUUID() {
        return snapshotUUID;
    }

    public void setSnapshotUUID(String snapshotUUID) {
        this.snapshotUUID = snapshotUUID;
    }

    public String getSnapshotType() {
        return snapshotType;
    }

    public String getSnapshotFilePath() {
        return snapshotFilePath;
    }

    public void setSnapshotFilePath(String snapshotFilePath) {
        this.snapshotFilePath = snapshotFilePath;
    }

    public int getSnapshotFileSize() {
        return snapshotFileSize;
    }

    public void setSnapshotFileSize(int snapshotFileSize) {
        this.snapshotFileSize = snapshotFileSize;
    }

    public int getSnapshotWidth() {
        return snapshotWidth;
    }

    public void setSnapshotWidth(int snapshotWidth) {
        this.snapshotWidth = snapshotWidth;
    }

    public int getSnapshotHeight() {
        return snapshotHeight;
    }

    public void setSnapshotHeight(int snapshotHeight) {
        this.snapshotHeight = snapshotHeight;
    }

    public String getSnapshotDownloadUrl() {
        return snapshotDownloadUrl;
    }

    public void setSnapshotDownloadUrl(String snapshotDownloadUrl) {
        this.snapshotDownloadUrl = snapshotDownloadUrl;
    }

    @Override
    public boolean update(MessageBaseElement element) {
        if (elementType == element.elementType) {
            VideoElement videoElement = (VideoElement) element;
            if (!TextUtils.isEmpty(videoFilePath) && !TextUtils.isEmpty(snapshotFilePath)
                && videoFilePath.equals(videoElement.videoFilePath)
                && snapshotFilePath.equals(videoElement.snapshotFilePath)) {
                videoUUID = videoElement.videoUUID;
                videoType = videoElement.videoType;
                videoFileSize = videoElement.videoFileSize;
                videoDuration = videoElement.videoDuration;
                videoDownloadUrl = videoElement.videoDownloadUrl;
                videoBusinessID = videoElement.videoBusinessID;

                snapshotUUID = videoElement.snapshotUUID;
                snapshotType = videoElement.snapshotType;
                snapshotFileSize = videoElement.snapshotFileSize;
                snapshotWidth = videoElement.snapshotWidth;
                snapshotHeight = videoElement.snapshotHeight;
                snapshotDownloadUrl = videoElement.snapshotDownloadUrl;

                return true;
            }
        }

        return false;
    }
}
