/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.plugin.task;

import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.builder.model.SigningConfig;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Pair;
import com.tencent.matrix.javalib.util.Util;
import com.tencent.matrix.plugin.compat.AgpCompat;
import com.tencent.matrix.plugin.compat.CreationConfig;
import com.tencent.matrix.plugin.extension.MatrixRemoveUnusedResExtension;
import com.tencent.matrix.plugin.task.BaseCreationAction;
import com.tencent.matrix.shrinker.RemoveUnusedResourceHelper;
import com.tencent.mm.arscutil.ArscUtil;
import com.tencent.mm.arscutil.data.ResTable;
import com.tencent.mm.arscutil.io.ArscReader;
import com.tencent.mm.arscutil.io.ArscWriter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\"\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00040\bj\b\u0012\u0004\u0012\u00020\u0004`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/tencent/matrix/plugin/task/RemoveUnusedResourcesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "apksigner", "", "ignoreRes", "", "ignoreResources", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "needSign", "", "shrinkArsc", "unusedResources", "", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "entryToResouceName", "entry", "ignoreResource", "name", "removeResources", "", "removeUnusedResources", "originalApk", "rTxtFile", "signingConfig", "Lcom/android/builder/model/SigningConfig;", "Companion", "CreationAction", "matrix-gradle-plugin"})
public abstract class RemoveUnusedResourcesTask
extends DefaultTask {
    private BaseVariant variant;
    private boolean needSign;
    private boolean shrinkArsc;
    private String apksigner = "";
    private Set<String> ignoreRes = new HashSet();
    private Set<String> unusedResources = new HashSet();
    private final HashSet<String> ignoreResources = new HashSet();
    @NotNull
    public static final String TAG = "Matrix.RemoveUnusedResourcesTask";
    public static final Companion Companion = new Companion(null);

    @TaskAction
    public final void removeResources() {
        String symbolDirName = (String)AgpCompat.getIntermediatesSymbolDirName.invoke();
        BaseVariant baseVariant = this.variant;
        if (baseVariant == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variant");
        }
        SigningConfig signingConfig = AgpCompat.Companion.getSigningConfig(baseVariant);
        StringBuilder stringBuilder = new StringBuilder();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
        StringBuilder stringBuilder2 = stringBuilder.append(file.getAbsolutePath()).append("/intermediates/").append(symbolDirName).append('/');
        BaseVariant baseVariant2 = this.variant;
        if (baseVariant2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variant");
        }
        String rTxtPath = stringBuilder2.append(baseVariant2.getName()).append("/R.txt").toString();
        BaseVariant baseVariant3 = this.variant;
        if (baseVariant3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variant");
        }
        DomainObjectCollection domainObjectCollection = baseVariant3.getOutputs();
        Intrinsics.checkExpressionValueIsNotNull((Object)domainObjectCollection, (String)"variant.outputs");
        Iterable $this$forEach$iv = (Iterable)domainObjectCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseVariantOutput output = (BaseVariantOutput)element$iv;
            boolean bl = false;
            BaseVariantOutput baseVariantOutput = output;
            Intrinsics.checkExpressionValueIsNotNull((Object)baseVariantOutput, (String)"output");
            File file2 = baseVariantOutput.getOutputFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"output.outputFile");
            String unsignedApkPath = file2.getAbsolutePath();
            long startTime = System.currentTimeMillis();
            String string = unsignedApkPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unsignedApkPath");
            this.removeUnusedResources(string, rTxtPath, signingConfig);
            Log.i((String)TAG, (String)"cost time %f s", (Object[])new Object[]{Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f)});
        }
    }

    private final boolean ignoreResource(String name) {
        for (String path : this.ignoreResources) {
            CharSequence charSequence = name;
            String string = path;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            String string2 = string;
            boolean bl = false;
            string2 = new Regex(string2);
            bl = false;
            if (!string2.matches(charSequence)) continue;
            return true;
        }
        return false;
    }

    private final String entryToResouceName(String entry) {
        String resourceName = "";
        if (!Util.isNullOrNil((String)entry)) {
            String string = entry;
            int n = 4;
            int n2 = StringsKt.lastIndexOf$default((CharSequence)entry, (char)'/', (int)0, (boolean)false, (int)6, null);
            int n3 = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String typeName = string3;
            String string4 = entry;
            n2 = StringsKt.lastIndexOf$default((CharSequence)entry, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
            n3 = StringsKt.indexOf$default((CharSequence)entry, (char)'.', (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n2, n3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String resName = string6;
            if (!Util.isNullOrNil((String)typeName) && !Util.isNullOrNil((String)resName)) {
                int index = StringsKt.indexOf$default((CharSequence)typeName, (char)'-', (int)0, (boolean)false, (int)6, null);
                if (index >= 0) {
                    String string7 = typeName;
                    n3 = 0;
                    bl = false;
                    String string8 = string7;
                    if (string8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.substring(n3, index);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    typeName = string9;
                }
                resourceName = "R." + typeName + '.' + resName;
            }
        }
        return resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void removeUnusedResources(String originalApk, String rTxtFile, SigningConfig signingConfig) {
        if (this.needSign) {
            if (Util.isNullOrNil((String)this.apksigner)) {
                throw (Throwable)new GradleException("need sign apk but apksigner not found!");
            }
            if (!new File(this.apksigner).exists()) {
                throw (Throwable)new GradleException("need sign apk but apksigner " + this.apksigner + " was not exist!");
            }
            if (signingConfig == null) {
                throw (Throwable)new GradleException("need sign apk but signingConfig not found!");
            }
        }
        ZipOutputStream zipOutputStream = null;
        try {
            block32: {
                try {
                    Object process;
                    Object resTable2;
                    Comparable<File> destArscFile2;
                    Object srcArscFile2;
                    File inputFile = new File(originalApk);
                    for (String res : this.ignoreRes) {
                        this.ignoreResources.add(Util.globToRegexp((String)res));
                    }
                    Iterator<String> iterator = this.unusedResources.iterator();
                    while (iterator.hasNext()) {
                        String res = iterator.next();
                        if (!this.ignoreResource(res)) continue;
                        iterator.remove();
                        Log.i((String)TAG, (String)"ignore unused resources %s", (Object[])new Object[]{res});
                    }
                    Log.i((String)TAG, (String)"unused resources count:%d", (Object[])new Object[]{this.unusedResources.size()});
                    StringBuilder stringBuilder = new StringBuilder();
                    File file = inputFile.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputFile.parentFile");
                    StringBuilder stringBuilder2 = stringBuilder.append(file.getAbsolutePath()).append("/");
                    String string = inputFile.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inputFile.name");
                    String string2 = string;
                    int n = 0;
                    String string3 = inputFile.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"inputFile.name");
                    int n2 = StringsKt.indexOf$default((CharSequence)string3, (char)'.', (int)0, (boolean)false, (int)6, null);
                    StringBuilder stringBuilder3 = stringBuilder2;
                    boolean bl = false;
                    String string4 = string2;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string6 = string5;
                    String outputApk = stringBuilder3.append(string6).append("_shrinked.apk").toString();
                    File outputFile = new File(outputApk);
                    if (outputFile.exists()) {
                        Log.w((String)TAG, (String)"output apk file %s is already exists! It will be deleted anyway!", (Object[])new Object[]{outputApk});
                        outputFile.delete();
                        outputFile.createNewFile();
                    }
                    ZipFile zipInputFile = new ZipFile(inputFile);
                    File file2 = outputFile;
                    bl = false;
                    Closeable closeable = new FileOutputStream(file2);
                    OutputStream outputStream = closeable;
                    zipOutputStream = new ZipOutputStream(outputStream);
                    HashMap<String, Integer> resourceMap = new HashMap<String, Integer>();
                    HashMap<String, Pair<String, Integer>[]> styleableMap = new HashMap<String, Pair<String, Integer>[]>();
                    File resTxtFile = new File(rTxtFile);
                    RemoveUnusedResourceHelper.readResourceTxtFile(resTxtFile, resourceMap, styleableMap);
                    HashMap removeResources = new HashMap();
                    for (String resName : this.unusedResources) {
                        Integer removed;
                        if (this.ignoreResource(resName) || (removed = resourceMap.remove(resName)) == null) continue;
                        ((Map)removeResources).put(resName, removed);
                    }
                    Enumeration<? extends ZipEntry> enumeration = zipInputFile.entries();
                    Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"zipInputFile.entries()");
                    Iterator iterator2 = CollectionsKt.iterator(enumeration);
                    while (iterator2.hasNext()) {
                        ZipEntry zipEntry;
                        ZipEntry zipEntry2 = zipEntry = (ZipEntry)iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry2, (String)"zipEntry");
                        String string7 = zipEntry2.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"zipEntry.name");
                        if (StringsKt.startsWith$default((String)string7, (String)"res/", (boolean)false, (int)2, null)) {
                            String string8 = zipEntry.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"zipEntry.name");
                            String resourceName = this.entryToResouceName(string8);
                            if (!Util.isNullOrNil((String)resourceName)) {
                                if (removeResources.containsKey(resourceName)) {
                                    Log.i((String)TAG, (String)"remove unused resource %s", (Object[])new Object[]{resourceName});
                                    continue;
                                }
                                RemoveUnusedResourceHelper.addZipEntry(zipOutputStream, zipEntry, zipInputFile);
                                continue;
                            }
                            RemoveUnusedResourceHelper.addZipEntry(zipOutputStream, zipEntry, zipInputFile);
                            continue;
                        }
                        if (this.needSign) {
                            String string9 = zipEntry.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"zipEntry.name");
                            if (StringsKt.startsWith$default((String)string9, (String)"META-INF/", (boolean)false, (int)2, null)) continue;
                        }
                        if (this.shrinkArsc && StringsKt.equals((String)zipEntry.getName(), (String)"resources.arsc", (boolean)true) && this.unusedResources.size() > 0) {
                            StringBuilder stringBuilder4 = new StringBuilder();
                            File file3 = inputFile.getParentFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"inputFile.parentFile");
                            srcArscFile2 = new File(stringBuilder4.append(file3.getAbsolutePath()).append("/resources.arsc").toString());
                            StringBuilder stringBuilder5 = new StringBuilder();
                            File file4 = inputFile.getParentFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"inputFile.parentFile");
                            destArscFile2 = new File(stringBuilder5.append(file4.getAbsolutePath()).append("/resources_shrinked.arsc").toString());
                            if (((File)srcArscFile2).exists()) {
                                ((File)srcArscFile2).delete();
                                ((File)srcArscFile2).createNewFile();
                            }
                            RemoveUnusedResourceHelper.unzipEntry(zipInputFile, zipEntry, (File)srcArscFile2);
                            ArscReader reader = new ArscReader(((File)srcArscFile2).getAbsolutePath());
                            resTable2 = reader.readResourceTable();
                            for (String resName : removeResources.keySet()) {
                                Object v = removeResources.get(resName);
                                if (v == null) {
                                    Intrinsics.throwNpe();
                                }
                                Intrinsics.checkExpressionValueIsNotNull(v, (String)"removeResources[resName]!!");
                                ArscUtil.removeResource((ResTable)resTable2, (int)((Number)v).intValue(), (String)resName);
                            }
                            ArscWriter writer = new ArscWriter(destArscFile2.getAbsolutePath());
                            writer.writeResTable(resTable2);
                            Log.i((String)TAG, (String)"Shrink resources.arsc size %f KB", (Object[])new Object[]{(double)(((File)srcArscFile2).length() - destArscFile2.length()) / 1024.0});
                            RemoveUnusedResourceHelper.addZipEntry(zipOutputStream, zipEntry, destArscFile2);
                            continue;
                        }
                        RemoveUnusedResourceHelper.addZipEntry(zipOutputStream, zipEntry, zipInputFile);
                    }
                    zipOutputStream.close();
                    Log.i((String)TAG, (String)"shrink apk size %f KB", (Object[])new Object[]{(double)(inputFile.length() - outputFile.length()) / 1024.0});
                    if (this.needSign) {
                        Log.i((String)TAG, (String)"Sign apk...", (Object[])new Object[0]);
                        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                        String[] stringArray = new String[12];
                        stringArray[0] = this.apksigner;
                        stringArray[1] = "sign";
                        stringArray[2] = "-v";
                        stringArray[3] = "--ks";
                        SigningConfig signingConfig2 = signingConfig;
                        if (signingConfig2 == null) {
                            Intrinsics.throwNpe();
                        }
                        File file5 = signingConfig2.getStoreFile();
                        stringArray[4] = file5 != null ? file5.getAbsolutePath() : null;
                        stringArray[5] = "--ks-pass";
                        stringArray[6] = "pass:" + signingConfig.getStorePassword();
                        stringArray[7] = "--key-pass";
                        stringArray[8] = "pass:" + signingConfig.getKeyPassword();
                        stringArray[9] = "--ks-key-alias";
                        stringArray[10] = signingConfig.getKeyAlias();
                        stringArray[11] = outputFile.getAbsolutePath();
                        processBuilder.command(stringArray);
                        process = processBuilder.start();
                        ((Process)process).waitFor();
                        if (((Process)process).exitValue() != 0) {
                            Object object = process;
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"process");
                            InputStream inputStream = ((Process)object).getErrorStream();
                            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.errorStream");
                            srcArscFile2 = inputStream;
                            destArscFile2 = Charsets.UTF_8;
                            boolean reader = false;
                            resTable2 = srcArscFile2;
                            int n3 = 0;
                            resTable2 = new InputStreamReader((InputStream)resTable2, (Charset)destArscFile2);
                            n3 = 8192;
                            boolean bl2 = false;
                            closeable = resTable2 instanceof BufferedReader ? (BufferedReader)resTable2 : new BufferedReader((Reader)resTable2, n3);
                            String string10 = ((StringBuilder)CollectionsKt.joinTo$default((Iterable)TextStreamsKt.readLines((Reader)((Reader)closeable)), (Appendable)new StringBuilder(), (CharSequence)"\n", null, null, (int)0, null, null, (int)124, null)).toString();
                            throw (Throwable)new GradleException(string10);
                        }
                    }
                    StringBuilder stringBuilder6 = new StringBuilder();
                    File file6 = inputFile.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"inputFile.parentFile");
                    StringBuilder stringBuilder7 = stringBuilder6.append(file6.getAbsolutePath()).append("/");
                    String string11 = inputFile.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"inputFile.name");
                    process = string11;
                    int srcArscFile2 = 0;
                    String string12 = inputFile.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"inputFile.name");
                    int destArscFile2 = StringsKt.indexOf$default((CharSequence)string12, (char)'.', (int)0, (boolean)false, (int)6, null);
                    stringBuilder3 = stringBuilder7;
                    boolean reader = false;
                    String string13 = process;
                    if (string13 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string14 = string13.substring(srcArscFile2, destArscFile2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string6 = string14;
                    String backApk = stringBuilder3.append(string6).append("_back.apk").toString();
                    inputFile.renameTo(new File(backApk));
                    outputFile.renameTo(new File(originalApk));
                    process = removeResources;
                    srcArscFile2 = 0;
                    if (!(!process.isEmpty())) break block32;
                    Iterator<String> styleableItera = styleableMap.keySet().iterator();
                    while (styleableItera.hasNext()) {
                        String styleable;
                        Intrinsics.checkExpressionValueIsNotNull((Object)styleableItera.next(), (String)"styleableItera.next()");
                        Pair<String, Integer>[] attrs = styleableMap.get(styleable);
                        int j = 0;
                        int resTable2 = 0;
                        if (attrs == null) {
                            Intrinsics.throwNpe();
                        }
                        int n4 = attrs.length;
                        while (resTable2 < n4) {
                            void i;
                            j = i;
                            if (!removeResources.containsValue(attrs[i].right)) break;
                            ++i;
                        }
                        if (attrs.length <= 0 || j != attrs.length) continue;
                        Log.i((String)TAG, (String)("removed styleable " + styleable), (Object[])new Object[0]);
                        styleableItera.remove();
                    }
                    StringBuilder stringBuilder8 = new StringBuilder();
                    File file7 = resTxtFile.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"resTxtFile.parentFile");
                    StringBuilder stringBuilder9 = stringBuilder8.append(file7.getAbsolutePath()).append("/");
                    String string15 = resTxtFile.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"resTxtFile.name");
                    String string16 = string15;
                    int n5 = 0;
                    String string17 = resTxtFile.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string17, (String)"resTxtFile.name");
                    int n6 = StringsKt.indexOf$default((CharSequence)string17, (char)'.', (int)0, (boolean)false, (int)6, null);
                    stringBuilder3 = stringBuilder9;
                    boolean bl3 = false;
                    String string18 = string16;
                    if (string18 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string19 = string18.substring(n5, n6);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string6 = string19;
                    String newResTxtFile = stringBuilder3.append(string6).append("_shrinked.txt").toString();
                    RemoveUnusedResourceHelper.shrinkResourceTxtFile(newResTxtFile, resourceMap, styleableMap);
                }
                catch (Throwable inputFile) {
                    Unit unit;
                    ZipOutputStream zipOutputStream2 = zipOutputStream;
                    if (zipOutputStream2 != null) {
                        zipOutputStream2.close();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    throw inputFile;
                }
            }
            zipOutputStream.close();
        }
        catch (Exception e) {
            Log.printErrStackTrace((String)TAG, (Throwable)e, (String)"remove unused resources occur error!", (Object[])new Object[0]);
        }
    }

    public static final /* synthetic */ boolean access$getNeedSign$p(RemoveUnusedResourcesTask $this) {
        return $this.needSign;
    }

    public static final /* synthetic */ boolean access$getShrinkArsc$p(RemoveUnusedResourcesTask $this) {
        return $this.shrinkArsc;
    }

    public static final /* synthetic */ String access$getApksigner$p(RemoveUnusedResourcesTask $this) {
        return $this.apksigner;
    }

    public static final /* synthetic */ Set access$getIgnoreRes$p(RemoveUnusedResourcesTask $this) {
        return $this.ignoreRes;
    }

    public static final /* synthetic */ Set access$getUnusedResources$p(RemoveUnusedResourcesTask $this) {
        return $this.unusedResources;
    }

    public static final /* synthetic */ BaseVariant access$getVariant$p(RemoveUnusedResourcesTask $this) {
        BaseVariant baseVariant = $this.variant;
        if (baseVariant == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variant");
        }
        return baseVariant;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/tencent/matrix/plugin/task/RemoveUnusedResourcesTask$CreationAction;", "Lorg/gradle/api/Action;", "Lcom/tencent/matrix/plugin/task/RemoveUnusedResourcesTask;", "Lcom/tencent/matrix/plugin/task/BaseCreationAction;", "creationConfig", "Lcom/tencent/matrix/plugin/compat/CreationConfig;", "removeUnusedResources", "Lcom/tencent/matrix/plugin/extension/MatrixRemoveUnusedResExtension;", "(Lcom/tencent/matrix/plugin/compat/CreationConfig;Lcom/tencent/matrix/plugin/extension/MatrixRemoveUnusedResExtension;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "execute", "", "task", "matrix-gradle-plugin"})
    public static final class CreationAction
    extends BaseCreationAction<RemoveUnusedResourcesTask>
    implements Action<RemoveUnusedResourcesTask> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<RemoveUnusedResourcesTask> type;
        private final CreationConfig creationConfig;
        private final MatrixRemoveUnusedResExtension removeUnusedResources;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<RemoveUnusedResourcesTask> getType() {
            return this.type;
        }

        public void execute(@NotNull RemoveUnusedResourcesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            task.needSign = this.removeUnusedResources.getNeedSign();
            task.shrinkArsc = this.removeUnusedResources.getShrinkArsc();
            task.apksigner = this.removeUnusedResources.getApksignerPath();
            task.ignoreRes = this.removeUnusedResources.getIgnoreResources();
            task.unusedResources = this.removeUnusedResources.getUnusedResources();
            task.variant = this.creationConfig.getVariant();
        }

        public CreationAction(@NotNull CreationConfig creationConfig, @NotNull MatrixRemoveUnusedResExtension removeUnusedResources) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkParameterIsNotNull((Object)removeUnusedResources, (String)"removeUnusedResources");
            super(creationConfig);
            this.creationConfig = creationConfig;
            this.removeUnusedResources = removeUnusedResources;
            this.name = this.computeTaskName("remove", "UnusedResources");
            this.type = RemoveUnusedResourcesTask.class;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/matrix/plugin/task/RemoveUnusedResourcesTask$Companion;", "", "()V", "TAG", "", "matrix-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

