/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.plugin.trace;

import com.android.build.api.transform.Status;
import com.android.utils.FileUtils;
import com.google.common.hash.Hashing;
import com.tencent.matrix.javalib.util.IOUtil;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import com.tencent.matrix.trace.Configuration;
import com.tencent.matrix.trace.MethodCollector;
import com.tencent.matrix.trace.MethodTracer;
import com.tencent.matrix.trace.item.TraceMethod;
import com.tencent.matrix.trace.retrace.MappingCollector;
import com.tencent.matrix.trace.retrace.MappingReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001b2\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0090\u0001\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2&\u0010\u0015\u001a\"\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u001a\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/tencent/matrix/plugin/trace/MatrixTrace;", "", "ignoreMethodMapFilePath", "", "methodMapFilePath", "baseMethodMapPath", "blockListFilePath", "mappingDir", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "doTransform", "", "classInputs", "", "Ljava/io/File;", "changedFiles", "", "Lcom/android/build/api/transform/Status;", "inputToOutput", "isIncremental", "", "traceClassDirectoryOutput", "legacyReplaceChangedFile", "Lkotlin/Function2;", "Ljava/lang/Object;", "legacyReplaceFile", "CollectDirectoryInputTask", "CollectJarInputTask", "Companion", "ParseMappingTask", "matrix-gradle-plugin"})
public final class MatrixTrace {
    private final String ignoreMethodMapFilePath;
    private final String methodMapFilePath;
    private final String baseMethodMapPath;
    private final String blockListFilePath;
    private final String mappingDir;
    private static final String TAG = "Matrix.Trace";
    public static final Companion Companion = new Companion(null);

    public final void doTransform(@NotNull Collection<? extends File> classInputs, @NotNull Map<File, ? extends Status> changedFiles, @NotNull Map<File, ? extends File> inputToOutput, boolean isIncremental, @NotNull File traceClassDirectoryOutput, @Nullable Function2<? super File, ? super Map<File, ? extends Status>, ? extends Object> legacyReplaceChangedFile2, @Nullable Function2<? super File, ? super File, ? extends Object> legacyReplaceFile2) {
        Intrinsics.checkParameterIsNotNull(classInputs, (String)"classInputs");
        Intrinsics.checkParameterIsNotNull(changedFiles, (String)"changedFiles");
        Intrinsics.checkParameterIsNotNull(inputToOutput, (String)"inputToOutput");
        Intrinsics.checkParameterIsNotNull((Object)traceClassDirectoryOutput, (String)"traceClassDirectoryOutput");
        ExecutorService executorService = Executors.newFixedThreadPool(16);
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newFixedThreadPool(16)");
        ExecutorService executor = executorService;
        Configuration config = new Configuration.Builder().setIgnoreMethodMapFilePath(this.ignoreMethodMapFilePath).setMethodMapFilePath(this.methodMapFilePath).setBaseMethodMap(this.baseMethodMapPath).setBlockListFile(this.blockListFilePath).setMappingPath(this.mappingDir).build();
        long start = System.currentTimeMillis();
        LinkedList futures = new LinkedList();
        MappingCollector mappingCollector = new MappingCollector();
        AtomicInteger methodId = new AtomicInteger(0);
        ConcurrentHashMap<String, TraceMethod> collectedMethodMap = new ConcurrentHashMap<String, TraceMethod>();
        Configuration configuration = config;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
        futures.add(executor.submit(new ParseMappingTask(mappingCollector, collectedMethodMap, methodId, configuration)));
        ConcurrentHashMap dirInputOutMap = new ConcurrentHashMap();
        ConcurrentHashMap jarInputOutMap = new ConcurrentHashMap();
        for (File file : classInputs) {
            if (file.isDirectory()) {
                futures.add(executor.submit(new CollectDirectoryInputTask(file, changedFiles, inputToOutput, isIncremental, traceClassDirectoryOutput, legacyReplaceChangedFile2, legacyReplaceFile2, dirInputOutMap)));
                continue;
            }
            Status status = Status.CHANGED;
            futures.add(executor.submit(new CollectJarInputTask(file, status, inputToOutput, isIncremental, traceClassDirectoryOutput, legacyReplaceFile2, dirInputOutMap, jarInputOutMap)));
        }
        for (Future future : futures) {
            future.get();
        }
        futures.clear();
        Log.i((String)TAG, (String)"[doTransform] Step(1)[Parse]... cost:%sms", (Object[])new Object[]{System.currentTimeMillis() - start});
        start = System.currentTimeMillis();
        MethodCollector methodCollector = new MethodCollector(executor, mappingCollector, methodId, config, collectedMethodMap);
        methodCollector.collect(dirInputOutMap.keySet(), jarInputOutMap.keySet());
        Log.i((String)TAG, (String)"[doTransform] Step(2)[Collection]... cost:%sms", (Object[])new Object[]{System.currentTimeMillis() - start});
        start = System.currentTimeMillis();
        MethodTracer methodTracer = new MethodTracer(executor, mappingCollector, config, methodCollector.getCollectedMethodMap(), methodCollector.getCollectedClassExtendMap());
        methodTracer.trace(dirInputOutMap, jarInputOutMap);
        Log.i((String)TAG, (String)"[doTransform] Step(3)[Trace]... cost:%sms", (Object[])new Object[]{System.currentTimeMillis() - start});
    }

    public MatrixTrace(@NotNull String ignoreMethodMapFilePath, @NotNull String methodMapFilePath, @Nullable String baseMethodMapPath, @Nullable String blockListFilePath, @NotNull String mappingDir) {
        Intrinsics.checkParameterIsNotNull((Object)ignoreMethodMapFilePath, (String)"ignoreMethodMapFilePath");
        Intrinsics.checkParameterIsNotNull((Object)methodMapFilePath, (String)"methodMapFilePath");
        Intrinsics.checkParameterIsNotNull((Object)mappingDir, (String)"mappingDir");
        this.ignoreMethodMapFilePath = ignoreMethodMapFilePath;
        this.methodMapFilePath = methodMapFilePath;
        this.baseMethodMapPath = baseMethodMapPath;
        this.blockListFilePath = blockListFilePath;
        this.mappingDir = mappingDir;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J$\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00032\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/tencent/matrix/plugin/trace/MatrixTrace$ParseMappingTask;", "Ljava/lang/Runnable;", "mappingCollector", "Lcom/tencent/matrix/trace/retrace/MappingCollector;", "collectedMethodMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/tencent/matrix/trace/item/TraceMethod;", "methodId", "Ljava/util/concurrent/atomic/AtomicInteger;", "config", "Lcom/tencent/matrix/trace/Configuration;", "(Lcom/tencent/matrix/trace/retrace/MappingCollector;Ljava/util/concurrent/ConcurrentHashMap;Ljava/util/concurrent/atomic/AtomicInteger;Lcom/tencent/matrix/trace/Configuration;)V", "getMethodFromBaseMethod", "", "baseMethodFile", "Ljava/io/File;", "retraceMethodMap", "processor", "methodMap", "run", "matrix-gradle-plugin"})
    public static final class ParseMappingTask
    implements Runnable {
        private final MappingCollector mappingCollector;
        private final ConcurrentHashMap<String, TraceMethod> collectedMethodMap;
        private final AtomicInteger methodId;
        private final Configuration config;

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            File mappingFile = new File(this.config.mappingDir, "mapping.txt");
            if (mappingFile.isFile()) {
                MappingReader mappingReader = new MappingReader(mappingFile);
                mappingReader.read(this.mappingCollector);
            }
            int size = this.config.parseBlockFile(this.mappingCollector);
            File baseMethodMapFile = new File(this.config.baseMethodMapPath);
            this.getMethodFromBaseMethod(baseMethodMapFile, this.collectedMethodMap);
            this.retraceMethodMap(this.mappingCollector, this.collectedMethodMap);
            Log.i((String)MatrixTrace.TAG, (String)"[ParseMappingTask#run] cost:%sms, black size:%s, collect %s method from %s", (Object[])new Object[]{System.currentTimeMillis() - start, size, this.collectedMethodMap.size(), this.config.baseMethodMapPath});
        }

        private final void retraceMethodMap(MappingCollector processor, ConcurrentHashMap<String, TraceMethod> methodMap) {
            HashMap retraceMethodMap = new HashMap(methodMap.size());
            for (TraceMethod traceMethod : methodMap.values()) {
                traceMethod.proguard(processor);
                Map map = retraceMethodMap;
                String string = traceMethod.getMethodName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"traceMethod.getMethodName()");
                TraceMethod traceMethod2 = traceMethod;
                Intrinsics.checkExpressionValueIsNotNull((Object)traceMethod2, (String)"traceMethod");
                map.put(string, traceMethod2);
            }
            methodMap.clear();
            methodMap.putAll(retraceMethodMap);
            retraceMethodMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void getMethodFromBaseMethod(File baseMethodFile, ConcurrentHashMap<String, TraceMethod> collectedMethodMap) {
            if (!baseMethodFile.exists()) {
                Log.w((String)MatrixTrace.TAG, (String)"[getMethodFromBaseMethod] not exist!%s", (Object[])new Object[]{baseMethodFile.getAbsolutePath()});
                return;
            }
            try {
                Closeable closeable = new Scanner(baseMethodFile, "UTF-8");
                boolean bl = false;
                Throwable throwable = null;
                try {
                    Scanner fileReader = (Scanner)closeable;
                    boolean bl2 = false;
                    while (fileReader.hasNext()) {
                        String string;
                        String nextLine = fileReader.nextLine();
                        if (Util.isNullOrNil((String)nextLine)) continue;
                        Intrinsics.checkExpressionValueIsNotNull((Object)nextLine, (String)"nextLine");
                        boolean bl3 = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        nextLine = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                        if (StringsKt.startsWith$default((String)nextLine, (String)"#", (boolean)false, (int)2, null)) {
                            Log.i((String)"[getMethodFromBaseMethod] comment %s", (String)nextLine, (Object[])new Object[0]);
                            continue;
                        }
                        List fields = StringsKt.split$default((CharSequence)nextLine, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                        TraceMethod traceMethod = new TraceMethod();
                        traceMethod.id = Integer.parseInt((String)fields.get(0));
                        traceMethod.accessFlag = Integer.parseInt((String)fields.get(1));
                        List methodField = StringsKt.split$default((CharSequence)((CharSequence)fields.get(2)), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
                        traceMethod.className = StringsKt.replace$default((String)((String)methodField.get(0)), (String)"/", (String)".", (boolean)false, (int)4, null);
                        traceMethod.methodName = (String)methodField.get(1);
                        if (methodField.size() > 2) {
                            traceMethod.desc = StringsKt.replace$default((String)((String)methodField.get(2)), (String)"/", (String)".", (boolean)false, (int)4, null);
                        }
                        Map map = collectedMethodMap;
                        String string3 = traceMethod.getMethodName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"traceMethod.getMethodName()");
                        map.put(string3, traceMethod);
                        if (this.methodId.get() >= traceMethod.id || traceMethod.id == 1048574) continue;
                        this.methodId.set(traceMethod.id);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable e) {
                Log.printErrStackTrace((String)MatrixTrace.TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
            }
        }

        public ParseMappingTask(@NotNull MappingCollector mappingCollector, @NotNull ConcurrentHashMap<String, TraceMethod> collectedMethodMap, @NotNull AtomicInteger methodId, @NotNull Configuration config) {
            Intrinsics.checkParameterIsNotNull((Object)mappingCollector, (String)"mappingCollector");
            Intrinsics.checkParameterIsNotNull(collectedMethodMap, (String)"collectedMethodMap");
            Intrinsics.checkParameterIsNotNull((Object)methodId, (String)"methodId");
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            this.mappingCollector = mappingCollector;
            this.collectedMethodMap = collectedMethodMap;
            this.methodId = methodId;
            this.config = config;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u009d\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012&\u0010\u000b\u001a\"\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u0012\u001a\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000b\u001a\"\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/tencent/matrix/plugin/trace/MatrixTrace$CollectDirectoryInputTask;", "Ljava/lang/Runnable;", "directoryInput", "Ljava/io/File;", "mapOfChangedFiles", "", "Lcom/android/build/api/transform/Status;", "mapOfInputToOutput", "isIncremental", "", "traceClassDirectoryOutput", "legacyReplaceChangedFile", "Lkotlin/Function2;", "Ljava/lang/Object;", "legacyReplaceFile", "resultOfDirInputToOut", "", "(Ljava/io/File;Ljava/util/Map;Ljava/util/Map;ZLjava/io/File;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Ljava/util/Map;)V", "handle", "", "run", "matrix-gradle-plugin"})
    public static final class CollectDirectoryInputTask
    implements Runnable {
        private final File directoryInput;
        private final Map<File, Status> mapOfChangedFiles;
        private final Map<File, File> mapOfInputToOutput;
        private final boolean isIncremental;
        private final File traceClassDirectoryOutput;
        private final Function2<File, Map<File, ? extends Status>, Object> legacyReplaceChangedFile;
        private final Function2<File, File, Object> legacyReplaceFile;
        private final Map<File, File> resultOfDirInputToOut;

        @Override
        public void run() {
            try {
                this.handle();
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)MatrixTrace.TAG, (String)"%s", (Object[])new Object[]{e.toString()});
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void handle() {
            block14: {
                File file;
                File dirInput = this.directoryInput;
                if (this.mapOfInputToOutput.containsKey(dirInput)) {
                    File file2 = this.mapOfInputToOutput.get(dirInput);
                    if (file2 == null) {
                        Intrinsics.throwNpe();
                    }
                    file = file2;
                } else {
                    file = new File(this.traceClassDirectoryOutput, dirInput.getName());
                }
                File dirOutput = file;
                String inputFullPath = dirInput.getAbsolutePath();
                String outputFullPath = dirOutput.getAbsolutePath();
                if (!dirOutput.exists()) {
                    dirOutput.mkdirs();
                }
                if (!dirInput.exists() && dirOutput.exists()) {
                    if (dirOutput.isDirectory()) {
                        FileUtils.deletePath((File)dirOutput);
                    } else {
                        FileUtils.delete((File)dirOutput);
                    }
                }
                if (this.isIncremental) {
                    HashMap outChangedFiles = new HashMap();
                    Object object = this.mapOfChangedFiles;
                    boolean bl = false;
                    Iterator<Map.Entry<File, Status>> iterator = object.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void changedFileInput;
                        String changedFileInputFullPath;
                        Map.Entry<File, Status> entry;
                        Map.Entry<File, Status> entry2 = entry = iterator.next();
                        boolean bl2 = false;
                        object = entry2.getKey();
                        entry2 = entry;
                        bl2 = false;
                        Status status = entry2.getValue();
                        String string = changedFileInputFullPath = changedFileInput.getAbsolutePath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"changedFileInputFullPath");
                        String string2 = inputFullPath;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"inputFullPath");
                        String string3 = outputFullPath;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"outputFullPath");
                        File changedFileOutput = new File(StringsKt.replace$default((String)string, (String)string2, (String)string3, (boolean)false, (int)4, null));
                        if (status == Status.ADDED || status == Status.CHANGED) {
                            this.resultOfDirInputToOut.put((File)changedFileInput, changedFileOutput);
                        } else if (status == Status.REMOVED) {
                            changedFileOutput.delete();
                        }
                        ((Map)outChangedFiles).put(changedFileOutput, status);
                    }
                    Function2<File, Map<File, ? extends Status>, Object> function2 = this.legacyReplaceChangedFile;
                    if (function2 != null) {
                        function2.invoke((Object)dirInput, outChangedFiles);
                    }
                } else {
                    this.resultOfDirInputToOut.put(dirInput, dirOutput);
                }
                Function2<File, File, Object> function2 = this.legacyReplaceFile;
                if (function2 == null) break block14;
                function2.invoke((Object)dirInput, (Object)dirOutput);
            }
        }

        public CollectDirectoryInputTask(@NotNull File directoryInput, @NotNull Map<File, ? extends Status> mapOfChangedFiles, @NotNull Map<File, ? extends File> mapOfInputToOutput, boolean isIncremental, @NotNull File traceClassDirectoryOutput, @Nullable Function2<? super File, ? super Map<File, ? extends Status>, ? extends Object> legacyReplaceChangedFile2, @Nullable Function2<? super File, ? super File, ? extends Object> legacyReplaceFile2, @NotNull Map<File, File> resultOfDirInputToOut) {
            Intrinsics.checkParameterIsNotNull((Object)directoryInput, (String)"directoryInput");
            Intrinsics.checkParameterIsNotNull(mapOfChangedFiles, (String)"mapOfChangedFiles");
            Intrinsics.checkParameterIsNotNull(mapOfInputToOutput, (String)"mapOfInputToOutput");
            Intrinsics.checkParameterIsNotNull((Object)traceClassDirectoryOutput, (String)"traceClassDirectoryOutput");
            Intrinsics.checkParameterIsNotNull(resultOfDirInputToOut, (String)"resultOfDirInputToOut");
            this.directoryInput = directoryInput;
            this.mapOfChangedFiles = mapOfChangedFiles;
            this.mapOfInputToOutput = mapOfInputToOutput;
            this.isIncremental = isIncremental;
            this.traceClassDirectoryOutput = traceClassDirectoryOutput;
            this.legacyReplaceChangedFile = legacyReplaceChangedFile2;
            this.legacyReplaceFile = legacyReplaceFile2;
            this.resultOfDirInputToOut = resultOfDirInputToOut;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u001a\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/tencent/matrix/plugin/trace/MatrixTrace$CollectJarInputTask;", "Ljava/lang/Runnable;", "inputJar", "Ljava/io/File;", "inputJarStatus", "Lcom/android/build/api/transform/Status;", "inputToOutput", "", "isIncremental", "", "traceClassFileOutput", "legacyReplaceFile", "Lkotlin/Function2;", "Ljava/lang/Object;", "resultOfDirInputToOut", "", "resultOfJarInputToOut", "(Ljava/io/File;Lcom/android/build/api/transform/Status;Ljava/util/Map;ZLjava/io/File;Lkotlin/jvm/functions/Function2;Ljava/util/Map;Ljava/util/Map;)V", "handle", "", "run", "matrix-gradle-plugin"})
    public static final class CollectJarInputTask
    implements Runnable {
        private final File inputJar;
        private final Status inputJarStatus;
        private final Map<File, File> inputToOutput;
        private final boolean isIncremental;
        private final File traceClassFileOutput;
        private final Function2<File, File, Object> legacyReplaceFile;
        private final Map<File, File> resultOfDirInputToOut;
        private final Map<File, File> resultOfJarInputToOut;

        @Override
        public void run() {
            try {
                this.handle();
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)MatrixTrace.TAG, (String)"%s", (Object[])new Object[]{e.toString()});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handle() {
            block28: {
                File file;
                File jarInput = this.inputJar;
                if (this.inputToOutput.containsKey(jarInput)) {
                    File file2 = this.inputToOutput.get(jarInput);
                    if (file2 == null) {
                        Intrinsics.throwNpe();
                    }
                    file = file2;
                } else {
                    file = new File(this.traceClassFileOutput, Companion.getUniqueJarName(jarInput));
                }
                File jarOutput = file;
                Log.d((String)MatrixTrace.TAG, (String)"CollectJarInputTask input %s -> output %s", (Object[])new Object[]{jarInput, jarOutput});
                if (!this.isIncremental && jarOutput.exists()) {
                    jarOutput.delete();
                }
                if (!jarOutput.getParentFile().exists()) {
                    jarOutput.getParentFile().mkdirs();
                }
                if (IOUtil.isRealZipOrJar((File)jarInput)) {
                    if (this.isIncremental) {
                        if (this.inputJarStatus == Status.ADDED || this.inputJarStatus == Status.CHANGED) {
                            this.resultOfJarInputToOut.put(jarInput, jarOutput);
                        } else if (this.inputJarStatus == Status.REMOVED) {
                            jarOutput.delete();
                        }
                    } else {
                        this.resultOfJarInputToOut.put(jarInput, jarOutput);
                    }
                } else {
                    Log.i((String)MatrixTrace.TAG, (String)"Special case for WeChat AutoDex. Its rootInput jar file is actually a txt file contains path list.", (Object[])new Object[0]);
                    Object object = jarInput;
                    boolean bl = false;
                    object = new FileInputStream((File)object);
                    Charset charset = Charsets.UTF_8;
                    boolean bl2 = false;
                    Object object2 = object;
                    int n = 0;
                    object2 = new InputStreamReader((InputStream)object2, charset);
                    n = 8192;
                    boolean bl3 = false;
                    Reader $this$useLines$iv = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                    boolean $i$f$useLines = false;
                    Closeable closeable = $this$useLines$iv;
                    int n2 = 8192;
                    n = 0;
                    closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
                    n2 = 0;
                    Throwable throwable = null;
                    try {
                        BufferedReader it$iv = (BufferedReader)closeable;
                        boolean bl4 = false;
                        Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                        boolean bl5 = false;
                        Sequence $this$forEach$iv = lines;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            String realJarInputFullPath = (String)element$iv;
                            boolean bl6 = false;
                            File realJarInput = new File(realJarInputFullPath);
                            File realJarOutput = new File(this.traceClassFileOutput, Companion.getUniqueJarName(realJarInput));
                            if (realJarInput.exists() && IOUtil.isRealZipOrJar((File)realJarInput)) {
                                this.resultOfJarInputToOut.put(realJarInput, realJarOutput);
                            } else {
                                realJarOutput.delete();
                                if (realJarInput.exists() && realJarInput.isDirectory()) {
                                    File realJarOutputDir = new File(this.traceClassFileOutput, realJarInput.getName());
                                    if (!realJarOutput.exists()) {
                                        realJarOutput.mkdirs();
                                    }
                                    this.resultOfDirInputToOut.put(realJarInput, realJarOutputDir);
                                }
                            }
                            Object object3 = jarOutput;
                            boolean bl7 = false;
                            object3 = new FileOutputStream((File)object3);
                            Charset charset2 = Charsets.UTF_8;
                            boolean bl8 = false;
                            Object object4 = object3;
                            int n3 = 0;
                            object4 = new OutputStreamWriter((OutputStream)object4, charset2);
                            n3 = 8192;
                            boolean bl9 = false;
                            object3 = object4 instanceof BufferedWriter ? (BufferedWriter)object4 : new BufferedWriter((Writer)object4, n3);
                            bl7 = false;
                            Throwable throwable2 = null;
                            try {
                                BufferedWriter bw = (BufferedWriter)object3;
                                boolean bl10 = false;
                                bw.write(realJarOutput.getAbsolutePath());
                                bw.newLine();
                                object4 = Unit.INSTANCE;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable2);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    jarInput.delete();
                }
                Function2<File, File, Object> function2 = this.legacyReplaceFile;
                if (function2 == null) break block28;
                function2.invoke((Object)jarInput, (Object)jarOutput);
            }
        }

        public CollectJarInputTask(@NotNull File inputJar, @NotNull Status inputJarStatus, @NotNull Map<File, ? extends File> inputToOutput, boolean isIncremental, @NotNull File traceClassFileOutput, @Nullable Function2<? super File, ? super File, ? extends Object> legacyReplaceFile2, @NotNull Map<File, File> resultOfDirInputToOut, @NotNull Map<File, File> resultOfJarInputToOut) {
            Intrinsics.checkParameterIsNotNull((Object)inputJar, (String)"inputJar");
            Intrinsics.checkParameterIsNotNull((Object)inputJarStatus, (String)"inputJarStatus");
            Intrinsics.checkParameterIsNotNull(inputToOutput, (String)"inputToOutput");
            Intrinsics.checkParameterIsNotNull((Object)traceClassFileOutput, (String)"traceClassFileOutput");
            Intrinsics.checkParameterIsNotNull(resultOfDirInputToOut, (String)"resultOfDirInputToOut");
            Intrinsics.checkParameterIsNotNull(resultOfJarInputToOut, (String)"resultOfJarInputToOut");
            this.inputJar = inputJar;
            this.inputJarStatus = inputJarStatus;
            this.inputToOutput = inputToOutput;
            this.isIncremental = isIncremental;
            this.traceClassFileOutput = traceClassFileOutput;
            this.legacyReplaceFile = legacyReplaceFile2;
            this.resultOfDirInputToOut = resultOfDirInputToOut;
            this.resultOfJarInputToOut = resultOfJarInputToOut;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/tencent/matrix/plugin/trace/MatrixTrace$Companion;", "", "()V", "TAG", "", "getUniqueJarName", "jarFile", "Ljava/io/File;", "matrix-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String getUniqueJarName(@NotNull File jarFile) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)jarFile, (String)"jarFile");
            String origJarName = jarFile.getName();
            String string2 = Hashing.sha1().hashString((CharSequence)jarFile.getPath(), Charsets.UTF_16LE).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Hashing.sha1().hashStrin\u2026sets.UTF_16LE).toString()");
            String hashing = string2;
            String string3 = origJarName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"origJarName");
            int dotPos = StringsKt.lastIndexOf$default((CharSequence)string3, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotPos < 0) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string4 = "%s_%s";
                Object[] objectArray = new Object[]{origJarName, hashing};
                boolean bl = false;
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                string = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
            } else {
                String string6 = origJarName;
                int n = 0;
                boolean bl = false;
                String string7 = string6.substring(n, dotPos);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String nameWithoutDotExt = string7;
                String string8 = origJarName;
                bl = false;
                String string9 = string8.substring(dotPos);
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                String dotExt = string9;
                string8 = StringCompanionObject.INSTANCE;
                String string10 = "%s_%s%s";
                Object[] objectArray = new Object[]{nameWithoutDotExt, hashing, dotExt};
                boolean bl2 = false;
                String string11 = String.format(string10, Arrays.copyOf(objectArray, objectArray.length));
                string = string11;
                Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"java.lang.String.format(format, *args)");
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

