/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.plugin.transform;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.plugin.trace.MatrixTrace;
import com.tencent.matrix.plugin.transform.MatrixTraceTransform$WhenMappings;
import com.tencent.matrix.trace.Configuration;
import com.tencent.matrix.trace.extension.MatrixTraceExtension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0006\u0010\u0012\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u001b\u0018\u00010\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J \u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\fH\u0002J\u0010\u0010\u0006\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/tencent/matrix/plugin/transform/MatrixTraceTransform;", "Lcom/android/build/api/transform/Transform;", "project", "Lorg/gradle/api/Project;", "extension", "Lcom/tencent/matrix/trace/extension/MatrixTraceExtension;", "transparent", "", "(Lorg/gradle/api/Project;Lcom/tencent/matrix/trace/extension/MatrixTraceExtension;Z)V", "configure", "Lcom/tencent/matrix/trace/Configuration;", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "copyFileAndMkdirsAsNeed", "", "from", "Ljava/io/File;", "to", "disable", "enable", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "isIncremental", "toOutputFile", "outputDir", "inputDir", "inputFile", "transform", "transforming", "invocation", "Companion", "matrix-gradle-plugin"})
public final class MatrixTraceTransform
extends Transform {
    private final Project project;
    private final MatrixTraceExtension extension;
    private boolean transparent;
    @NotNull
    public static final String TAG = "Matrix.TraceTransform";
    public static final Companion Companion = new Companion(null);

    public final void enable() {
        this.transparent = false;
    }

    public final void disable() {
        this.transparent = true;
    }

    @NotNull
    public String getName() {
        return "MatrixTraceTransform";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set set = TransformManager.CONTENT_CLASS;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"TransformManager.CONTENT_CLASS");
        return set;
    }

    @Nullable
    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
        super.transform(transformInvocation);
        if (this.transparent) {
            this.transparent(transformInvocation);
        } else {
            this.transforming(transformInvocation);
        }
    }

    private final void transparent(TransformInvocation invocation) {
        TransformOutputProvider transformOutputProvider = invocation.getOutputProvider();
        if (transformOutputProvider == null) {
            Intrinsics.throwNpe();
        }
        TransformOutputProvider outputProvider = transformOutputProvider;
        if (!invocation.isIncremental()) {
            outputProvider.deleteAll();
        }
        Iterator iterator = invocation.getInputs().iterator();
        while (iterator.hasNext()) {
            TransformInput ti;
            TransformInput transformInput = ti = (TransformInput)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"ti");
            Iterator iterator2 = transformInput.getJarInputs().iterator();
            block11: while (iterator2.hasNext()) {
                JarInput jarInput;
                JarInput jarInput2 = jarInput = (JarInput)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jarInput2, (String)"jarInput");
                File inputJar = jarInput2.getFile();
                File outputJar = outputProvider.getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                if (invocation.isIncremental()) {
                    Status status = jarInput.getStatus();
                    if (status == null) continue;
                    switch (MatrixTraceTransform$WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                        case 1: {
                            continue block11;
                        }
                        case 2: 
                        case 3: {
                            File file = inputJar;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputJar");
                            File file2 = outputJar;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outputJar");
                            this.copyFileAndMkdirsAsNeed(file, file2);
                            continue block11;
                        }
                        case 4: {
                            FileUtils.delete((File)outputJar);
                            continue block11;
                        }
                    }
                    continue;
                }
                File file = inputJar;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputJar");
                File file3 = outputJar;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"outputJar");
                this.copyFileAndMkdirsAsNeed(file, file3);
            }
            iterator2 = ti.getDirectoryInputs().iterator();
            while (iterator2.hasNext()) {
                DirectoryInput directoryInput;
                DirectoryInput directoryInput2 = directoryInput = (DirectoryInput)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput2, (String)"directoryInput");
                File inputDir = directoryInput2.getFile();
                File outputDir = outputProvider.getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
                if (invocation.isIncremental()) {
                    for (Map.Entry entry : directoryInput.getChangedFiles().entrySet()) {
                        File inputFile = (File)entry.getKey();
                        Status status = (Status)entry.getValue();
                        if (status == null) continue;
                        switch (MatrixTraceTransform$WhenMappings.$EnumSwitchMapping$1[status.ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: 
                            case 3: {
                                File file = inputFile;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputFile");
                                if (file.isDirectory()) break;
                                File file4 = outputDir;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"outputDir");
                                File file5 = inputDir;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"inputDir");
                                File outputFile = this.toOutputFile(file4, file5, inputFile);
                                this.copyFileAndMkdirsAsNeed(inputFile, outputFile);
                                break;
                            }
                            case 4: {
                                File file = outputDir;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
                                File file6 = inputDir;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"inputDir");
                                File file7 = inputFile;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"inputFile");
                                File outputFile = this.toOutputFile(file, file6, file7);
                                FileUtils.deleteIfExists((File)outputFile);
                                break;
                            }
                        }
                    }
                    continue;
                }
                for (File in : FileUtils.getAllFiles((File)inputDir)) {
                    File file = outputDir;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
                    File file8 = inputDir;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file8, (String)"inputDir");
                    File file9 = in;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file9, (String)"`in`");
                    File out = this.toOutputFile(file, file8, file9);
                    this.copyFileAndMkdirsAsNeed(in, out);
                }
            }
        }
    }

    private final void copyFileAndMkdirsAsNeed(File from, File to) {
        if (from.exists()) {
            to.getParentFile().mkdirs();
            FileUtils.copyFile((File)from, (File)to);
        }
    }

    private final File toOutputFile(File outputDir, File inputDir, File inputFile) {
        return new File(outputDir, FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir));
    }

    private final Configuration configure(TransformInvocation transformInvocation) {
        File file = this.project.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
        String buildDir = file.getAbsolutePath();
        Context context = transformInvocation.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"transformInvocation.context");
        String dirName = context.getVariantName();
        String mappingOut = Joiner.on((char)File.separatorChar).join((Object)buildDir, (Object)"outputs", new Object[]{"mapping", dirName});
        Configuration configuration = new Configuration.Builder().setBaseMethodMap(this.extension.getBaseMethodMapFile()).setBlockListFile(this.extension.getBlackListFile()).setMethodMapFilePath(mappingOut + "/methodMapping.txt").setIgnoreMethodMapFilePath(mappingOut + "/ignoreMethodMapping.txt").setMappingPath(mappingOut).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"Configuration.Builder()\n\u2026\n                .build()");
        return configuration;
    }

    private final void transforming(TransformInvocation invocation) {
        Object object;
        boolean isIncremental;
        long start = System.currentTimeMillis();
        TransformOutputProvider transformOutputProvider = invocation.getOutputProvider();
        if (transformOutputProvider == null) {
            Intrinsics.throwNpe();
        }
        TransformOutputProvider outputProvider = transformOutputProvider;
        boolean bl = isIncremental = invocation.isIncremental() && this.isIncremental();
        if (!isIncremental) {
            outputProvider.deleteAll();
        }
        Configuration config = this.configure(invocation);
        ConcurrentHashMap changedFiles = new ConcurrentHashMap();
        ConcurrentHashMap inputToOutput = new ConcurrentHashMap();
        ArrayList<File> inputFiles = new ArrayList<File>();
        File transformDirectory = null;
        Iterator iterator = invocation.getInputs().iterator();
        while (iterator.hasNext()) {
            TransformInput input;
            TransformInput transformInput = input = (TransformInput)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"input");
            object = transformInput.getDirectoryInputs().iterator();
            while (object.hasNext()) {
                DirectoryInput directoryInput;
                DirectoryInput directoryInput2 = directoryInput = (DirectoryInput)object.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput2, (String)"directoryInput");
                changedFiles.putAll(directoryInput2.getChangedFiles());
                File inputDir = directoryInput.getFile();
                inputFiles.add(inputDir);
                File outputDirectory = outputProvider.getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
                Map map = inputToOutput;
                File file = inputDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputDir");
                File file2 = outputDirectory;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outputDirectory");
                map.put(file, file2);
                if (transformDirectory != null) continue;
                transformDirectory = outputDirectory.getParentFile();
            }
            object = input.getJarInputs().iterator();
            while (object.hasNext()) {
                JarInput jarInput;
                JarInput jarInput2 = jarInput = (JarInput)object.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jarInput2, (String)"jarInput");
                File inputFile = jarInput2.getFile();
                Map map = changedFiles;
                File file = inputFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputFile");
                Status status = jarInput.getStatus();
                Intrinsics.checkExpressionValueIsNotNull((Object)status, (String)"jarInput.status");
                map.put(file, status);
                inputFiles.add(inputFile);
                File outputJar = outputProvider.getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                Map map2 = inputToOutput;
                File file3 = outputJar;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"outputJar");
                map2.put(inputFile, file3);
                if (transformDirectory != null) continue;
                transformDirectory = outputJar.getParentFile();
            }
        }
        if (inputFiles.size() == 0 || transformDirectory == null) {
            Log.i((String)TAG, (String)"Matrix trace do not find any input files", (Object[])new Object[0]);
            return;
        }
        File outputDirectory = transformDirectory;
        String string = config.ignoreMethodMapFilePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"config.ignoreMethodMapFilePath");
        String string2 = config.methodMapFilePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"config.methodMapFilePath");
        String string3 = config.baseMethodMapPath;
        String string4 = config.blockListFilePath;
        String string5 = config.mappingDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"config.mappingDir");
        iterator = null;
        Function2<? super File, ? super Map<File, ? extends Status>, ? extends Object> function2 = null;
        object = inputToOutput;
        File file = outputDirectory;
        boolean bl2 = isIncremental;
        new MatrixTrace(string, string2, string3, string4, string5).doTransform((Collection<? extends File>)inputFiles, changedFiles, (Map<File, ? extends File>)object, bl2, file, function2, (Function2<? super File, ? super File, ? extends Object>)iterator);
        long cost = System.currentTimeMillis() - start;
        Log.i((String)TAG, (String)" Insert matrix trace instrumentations cost time: %sms.", (Object[])new Object[]{cost});
    }

    public MatrixTraceTransform(@NotNull Project project, @NotNull MatrixTraceExtension extension, boolean transparent) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        this.project = project;
        this.extension = extension;
        this.transparent = transparent;
    }

    public /* synthetic */ MatrixTraceTransform(Project project, MatrixTraceExtension matrixTraceExtension, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(project, matrixTraceExtension, bl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/matrix/plugin/transform/MatrixTraceTransform$Companion;", "", "()V", "TAG", "", "matrix-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

