/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.shrinker;

import com.android.builder.model.SigningConfig;
import com.tencent.matrix.javalib.util.Pair;
import com.tencent.matrix.javalib.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.gradle.api.GradleException;

public class ApkUtil {
    public static String parseResourceId(String resId) {
        if (!Util.isNullOrNil((String)resId) && resId.startsWith("0x")) {
            if (resId.length() == 10) {
                return resId;
            }
            if (resId.length() < 10) {
                StringBuilder strBuilder = new StringBuilder(resId);
                for (int i = 0; i < 10 - resId.length(); ++i) {
                    strBuilder.append('0');
                }
                return strBuilder.toString();
            }
        }
        return "";
    }

    public static String entryToResourceName(String entry) {
        String resourceName = "";
        if (!Util.isNullOrNil((String)entry)) {
            String typeName = ApkUtil.parseEntryResourceType(entry);
            String resName = entry.substring(entry.lastIndexOf(47) + 1, entry.indexOf(46));
            if (!Util.isNullOrNil((String)typeName) && !Util.isNullOrNil((String)resName)) {
                resourceName = "R." + typeName + "." + resName;
            }
        }
        return resourceName;
    }

    public static String parseEntryResourceType(String entry) {
        String typeName;
        if (!Util.isNullOrNil((String)entry) && entry.length() > 4 && !Util.isNullOrNil((String)(typeName = entry.substring(4, entry.lastIndexOf(47))))) {
            int index = typeName.indexOf(45);
            if (index >= 0) {
                typeName = typeName.substring(0, index);
            }
            return typeName;
        }
        return "";
    }

    public static boolean isSameResourceType(Set<String> entries) {
        String resType = "";
        for (String entry : entries) {
            if (!Util.isNullOrNil((String)entry)) {
                if (Util.isNullOrNil((String)resType)) {
                    resType = ApkUtil.parseEntryResourceType(entry);
                    continue;
                }
                if (resType.equals(ApkUtil.parseEntryResourceType(entry))) continue;
                return false;
            }
            return false;
        }
        return !Util.isNullOrNil((String)resType);
    }

    public static String parseResourceType(String resource) {
        return resource.substring(resource.indexOf(46) + 1, resource.lastIndexOf(46));
    }

    public static String parseResourceName(String resource) {
        return resource.substring(resource.lastIndexOf(46) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileContent(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int len;
            BufferedInputStream bufferedInput = new BufferedInputStream(inputStream);
            byte[] buffer = new byte[4096];
            while ((len = bufferedInput.read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
            bufferedInput.close();
        }
        return output.toByteArray();
    }

    public static void unzipEntry(ZipFile zipFile, ZipEntry zipEntry, String destFile) throws IOException {
        File file = new File(destFile);
        file.getParentFile().mkdirs();
        file.createNewFile();
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        outputStream.write(ApkUtil.readFileContent(inputStream));
        outputStream.close();
    }

    public static void addZipEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, File file) throws IOException {
        ZipEntry writeEntry = new ZipEntry(zipEntry.getName());
        FileInputStream inputStream = new FileInputStream(file);
        byte[] content = ApkUtil.readFileContent(inputStream);
        if (zipEntry.getMethod() == 8) {
            writeEntry.setMethod(8);
        } else {
            writeEntry.setMethod(0);
            CRC32 crc32 = new CRC32();
            crc32.update(content);
            writeEntry.setCrc(crc32.getValue());
        }
        writeEntry.setSize(content.length);
        zipOutputStream.putNextEntry(writeEntry);
        zipOutputStream.write(content);
        zipOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    public static void addZipEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, ZipFile zipFile) throws IOException {
        ZipEntry writeEntry = new ZipEntry(zipEntry.getName());
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        byte[] content = ApkUtil.readFileContent(inputStream);
        if (zipEntry.getMethod() == 8) {
            writeEntry.setMethod(8);
        } else {
            writeEntry.setMethod(0);
            writeEntry.setCrc(zipEntry.getCrc());
            writeEntry.setSize(zipEntry.getSize());
        }
        zipOutputStream.putNextEntry(writeEntry);
        zipOutputStream.write(content);
        zipOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    public static void addZipEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, String newName, ZipFile zipFile) throws IOException {
        ZipEntry writeEntry = new ZipEntry(newName);
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        byte[] content = ApkUtil.readFileContent(inputStream);
        if (zipEntry.getMethod() == 8) {
            writeEntry.setMethod(8);
        } else {
            writeEntry.setMethod(0);
            writeEntry.setCrc(zipEntry.getCrc());
            writeEntry.setSize(zipEntry.getSize());
        }
        zipOutputStream.putNextEntry(writeEntry);
        zipOutputStream.write(content);
        zipOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    public static void sevenZipFile(String sevenZipPath, String inputFile, String outputFile, boolean deflated) throws GradleException, IOException, InterruptedException {
        if (!new File(sevenZipPath).canExecute()) {
            new File(sevenZipPath).setExecutable(true);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(sevenZipPath, "a", "-tzip", outputFile, inputFile, deflated ? "-mx9" : "-mx0");
        Process process = processBuilder.start();
        ApkUtil.waitForProcessOutput(process);
        if (process.exitValue() != 0) {
            throw new GradleException("7zip apk occur error!");
        }
    }

    public static void waitForProcessOutput(Process process) throws InterruptedException, IOException {
        process.waitFor();
        byte[] bytes = new byte[1024];
        while (process.getInputStream().read(bytes) > 0) {
            System.out.write(bytes);
        }
        while (process.getErrorStream().read(bytes) > 0) {
            System.err.write(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readResourceTxtFile(File resTxtFile, Map<String, Integer> resourceMap, Map<String, Pair<String, Integer>[]> styleableMap) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(resTxtFile));
        String line = bufferedReader.readLine();
        boolean styleable = false;
        String styleableName = "";
        ArrayList<String> styleableAttrs = new ArrayList<String>();
        try {
            while (line != null) {
                String[] columns = line.split(" ");
                if (columns.length >= 4) {
                    String resourceName = "R." + columns[1] + "." + columns[2];
                    if (!columns[0].endsWith("[]") && columns[3].startsWith("0x")) {
                        String resId;
                        if (styleable) {
                            styleable = false;
                            styleableName = "";
                        }
                        if (!Util.isNullOrNil((String)(resId = ApkUtil.parseResourceId(columns[3])))) {
                            resourceMap.put(resourceName, Integer.decode(resId));
                        }
                    } else if (columns[1].equals("styleable")) {
                        if (columns[0].endsWith("[]")) {
                            if (columns.length > 5) {
                                styleableAttrs.clear();
                                styleable = true;
                                styleableName = "R." + columns[1] + "." + columns[2];
                                for (int i = 4; i < columns.length - 1; ++i) {
                                    if (columns[i].endsWith(",")) {
                                        styleableAttrs.add(columns[i].substring(0, columns[i].length() - 1));
                                        continue;
                                    }
                                    styleableAttrs.add(columns[i]);
                                }
                                styleableMap.put(styleableName, (Pair[])Array.newInstance(Pair.class, styleableAttrs.size()));
                            }
                        } else if (styleable && !Util.isNullOrNil((String)styleableName)) {
                            int index = Integer.parseInt(columns[3]);
                            String name = "R." + columns[1] + "." + columns[2];
                            styleableMap.get((Object)styleableName)[index] = new Pair((Object)name, (Object)Integer.decode(ApkUtil.parseResourceId((String)styleableAttrs.get(index))));
                        }
                    } else if (styleable) {
                        styleable = false;
                        styleableName = "";
                    }
                }
                line = bufferedReader.readLine();
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shrinkResourceTxtFile(String resourceTxt, Map<String, Integer> resourceMap, Map<String, Pair<String, Integer>[]> styleableMap) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(resourceTxt));){
            StringBuilder strBuilder;
            for (String res : resourceMap.keySet()) {
                strBuilder = new StringBuilder();
                strBuilder.append("int").append(" ").append(res.substring(2, res.indexOf(46, 2))).append(" ").append(res.substring(res.indexOf(46, 2) + 1)).append(" ").append("0x" + Integer.toHexString(resourceMap.get(res)));
                bufferedWriter.write(strBuilder.toString());
                bufferedWriter.newLine();
            }
            for (String styleable : styleableMap.keySet()) {
                int i;
                strBuilder = new StringBuilder();
                Pair<String, Integer>[] styleableAttrs = styleableMap.get(styleable);
                strBuilder.append("int[]").append(" ").append("styleable").append(" ").append(styleable.substring(styleable.indexOf(46, 2) + 1)).append(" ").append("{ ");
                for (i = 0; i < styleableAttrs.length; ++i) {
                    if (i != styleableAttrs.length - 1) {
                        strBuilder.append("0x" + Integer.toHexString((Integer)styleableAttrs[i].right)).append(", ");
                        continue;
                    }
                    strBuilder.append("0x" + Integer.toHexString((Integer)styleableAttrs[i].right));
                }
                strBuilder.append(" }");
                bufferedWriter.write(strBuilder.toString());
                bufferedWriter.newLine();
                for (i = 0; i < styleableAttrs.length; ++i) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("int").append(" ").append("styleable").append(" ").append((String)styleableAttrs[i].left).append(" ").append(i);
                    bufferedWriter.write(stringBuilder.toString());
                    bufferedWriter.newLine();
                }
            }
        }
    }

    public static void signApk(String apkFilePath, String apksigner, SigningConfig signingConfig) throws GradleException, IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        ArrayList<String> commandList = new ArrayList<String>(Arrays.asList(apksigner, "sign", "-v", "--ks", signingConfig.getStoreFile().getAbsolutePath(), "--ks-pass", "pass:" + signingConfig.getStorePassword(), "--key-pass", "pass:" + signingConfig.getKeyPassword(), "--ks-key-alias", signingConfig.getKeyAlias()));
        if (signingConfig.isV1SigningEnabled()) {
            commandList.add("--v1-signing-enabled");
        }
        if (signingConfig.isV2SigningEnabled()) {
            commandList.add("--v2-signing-enabled");
        }
        commandList.add(apkFilePath);
        processBuilder.command(commandList);
        Process process = processBuilder.start();
        ApkUtil.waitForProcessOutput(process);
        if (process.exitValue() != 0) {
            throw new GradleException("sign apk occur error!");
        }
    }

    public static void zipAlignApk(String inputFile, String outputFile, String zipAlignPath) throws GradleException, IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(zipAlignPath, "-f", "4", inputFile, outputFile);
        Process process = processBuilder.start();
        ApkUtil.waitForProcessOutput(process);
        if (process.exitValue() != 0) {
            throw new GradleException("zipalign apk occur error!");
        }
    }
}

