/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace;

import com.tencent.matrix.javalib.util.FileUtil;
import com.tencent.matrix.javalib.util.Util;
import com.tencent.matrix.trace.retrace.MappingCollector;
import java.util.HashSet;

public class Configuration {
    public String packageName;
    public String mappingDir;
    public String baseMethodMapPath;
    public String methodMapFilePath;
    public String ignoreMethodMapFilePath;
    public String blockListFilePath;
    public String traceClassOut;
    public HashSet<String> blockSet = new HashSet();

    public Configuration() {
    }

    Configuration(String packageName, String mappingDir, String baseMethodMapPath, String methodMapFilePath, String ignoreMethodMapFilePath, String blockListFilePath, String traceClassOut) {
        this.packageName = packageName;
        this.mappingDir = Util.nullAsNil((String)mappingDir);
        this.baseMethodMapPath = Util.nullAsNil((String)baseMethodMapPath);
        this.methodMapFilePath = Util.nullAsNil((String)methodMapFilePath);
        this.ignoreMethodMapFilePath = Util.nullAsNil((String)ignoreMethodMapFilePath);
        this.blockListFilePath = Util.nullAsNil((String)blockListFilePath);
        this.traceClassOut = Util.nullAsNil((String)traceClassOut);
    }

    public int parseBlockFile(MappingCollector processor) {
        String blockStr = "[package]\n-keeppackage android/\n-keeppackage com/tencent/matrix/\n" + FileUtil.readFileAsString((String)this.blockListFilePath);
        String[] blockArray = blockStr.trim().replace("/", ".").split("\n");
        if (blockArray != null) {
            for (String block : blockArray) {
                if (block.length() == 0 || block.startsWith("#") || block.startsWith("[")) continue;
                if (block.startsWith("-keepclass ")) {
                    block = block.replace("-keepclass ", "");
                    this.blockSet.add(processor.proguardClassName(block, block));
                    continue;
                }
                if (!block.startsWith("-keeppackage ")) continue;
                block = block.replace("-keeppackage ", "");
                this.blockSet.add(processor.proguardPackageName(block, block));
            }
        }
        return this.blockSet.size();
    }

    public String toString() {
        return "\n# Configuration\n|* packageName:\t" + this.packageName + "\n|* mappingDir:\t" + this.mappingDir + "\n|* baseMethodMapPath:\t" + this.baseMethodMapPath + "\n|* methodMapFilePath:\t" + this.methodMapFilePath + "\n|* ignoreMethodMapFilePath:\t" + this.ignoreMethodMapFilePath + "\n|* blockListFilePath:\t" + this.blockListFilePath + "\n|* traceClassOut:\t" + this.traceClassOut + "\n";
    }

    public static class Builder {
        public String packageName;
        public String mappingPath;
        public String baseMethodMap;
        public String methodMapFile;
        public String ignoreMethodMapFile;
        public String blockListFile;
        public String traceClassOut;

        public Builder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder setMappingPath(String mappingPath) {
            this.mappingPath = mappingPath;
            return this;
        }

        public Builder setBaseMethodMap(String baseMethodMap) {
            this.baseMethodMap = baseMethodMap;
            return this;
        }

        public Builder setTraceClassOut(String traceClassOut) {
            this.traceClassOut = traceClassOut;
            return this;
        }

        public Builder setMethodMapFilePath(String methodMapDir) {
            this.methodMapFile = methodMapDir;
            return this;
        }

        public Builder setIgnoreMethodMapFilePath(String methodMapDir) {
            this.ignoreMethodMapFile = methodMapDir;
            return this;
        }

        public Builder setBlockListFile(String blockListFile) {
            this.blockListFile = blockListFile;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.packageName, this.mappingPath, this.baseMethodMap, this.methodMapFile, this.ignoreMethodMapFile, this.blockListFile, this.traceClassOut);
        }
    }
}

