/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace;

import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.trace.Configuration;
import com.tencent.matrix.trace.TraceBuildConstants;
import com.tencent.matrix.trace.item.TraceMethod;
import com.tencent.matrix.trace.retrace.MappingCollector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodCollector {
    private static final String TAG = "MethodCollector";
    private final ExecutorService executor;
    private final MappingCollector mappingCollector;
    private final ConcurrentHashMap<String, String> collectedClassExtendMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TraceMethod> collectedIgnoreMethodMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TraceMethod> collectedMethodMap;
    private final Configuration configuration;
    private final AtomicInteger methodId;
    private final AtomicInteger ignoreCount = new AtomicInteger();
    private final AtomicInteger incrementCount = new AtomicInteger();

    public MethodCollector(ExecutorService executor, MappingCollector mappingCollector, AtomicInteger methodId, Configuration configuration, ConcurrentHashMap<String, TraceMethod> collectedMethodMap) {
        this.executor = executor;
        this.mappingCollector = mappingCollector;
        this.configuration = configuration;
        this.methodId = methodId;
        this.collectedMethodMap = collectedMethodMap;
    }

    public ConcurrentHashMap<String, String> getCollectedClassExtendMap() {
        return this.collectedClassExtendMap;
    }

    public ConcurrentHashMap<String, TraceMethod> getCollectedMethodMap() {
        return this.collectedMethodMap;
    }

    public void collect(Set<File> srcFolderList, Set<File> dependencyJarList) throws ExecutionException, InterruptedException {
        LinkedList futures = new LinkedList();
        for (File file : srcFolderList) {
            ArrayList<File> classFileList = new ArrayList<File>();
            if (file.isDirectory()) {
                this.listClassFiles(classFileList, file);
            } else {
                classFileList.add(file);
            }
            for (File classFile : classFileList) {
                futures.add(this.executor.submit(new CollectSrcTask(classFile)));
            }
        }
        for (File file : dependencyJarList) {
            futures.add(this.executor.submit(new CollectJarTask(file)));
        }
        for (Future future : futures) {
            future.get();
        }
        futures.clear();
        futures.add(this.executor.submit(new Runnable(){

            @Override
            public void run() {
                MethodCollector.this.saveIgnoreCollectedMethod(MethodCollector.this.mappingCollector);
            }
        }));
        futures.add(this.executor.submit(new Runnable(){

            @Override
            public void run() {
                MethodCollector.this.saveCollectedMethod(MethodCollector.this.mappingCollector);
            }
        }));
        for (Future future : futures) {
            future.get();
        }
        futures.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIgnoreCollectedMethod(MappingCollector mappingCollector) {
        File methodMapFile = new File(this.configuration.ignoreMethodMapFilePath);
        if (!methodMapFile.getParentFile().exists()) {
            methodMapFile.getParentFile().mkdirs();
        }
        ArrayList<TraceMethod> ignoreMethodList = new ArrayList<TraceMethod>();
        ignoreMethodList.addAll(this.collectedIgnoreMethodMap.values());
        Log.i((String)TAG, (String)"[saveIgnoreCollectedMethod] size:%s path:%s", (Object[])new Object[]{this.collectedIgnoreMethodMap.size(), methodMapFile.getAbsolutePath()});
        Collections.sort(ignoreMethodList, new Comparator<TraceMethod>(){

            @Override
            public int compare(TraceMethod o1, TraceMethod o2) {
                return o1.className.compareTo(o2.className);
            }
        });
        PrintWriter pw = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(methodMapFile, false);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            pw = new PrintWriter(w);
            pw.println("ignore methods:");
            for (TraceMethod traceMethod : ignoreMethodList) {
                traceMethod.revert(mappingCollector);
                pw.println(traceMethod.toIgnoreString());
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"write method map Exception:%s", (Object[])new Object[]{e.getMessage()});
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCollectedMethod(MappingCollector mappingCollector) {
        File methodMapFile = new File(this.configuration.methodMapFilePath);
        if (!methodMapFile.getParentFile().exists()) {
            methodMapFile.getParentFile().mkdirs();
        }
        ArrayList<TraceMethod> methodList = new ArrayList<TraceMethod>();
        TraceMethod extra = TraceMethod.create(1048574, 1, "android.os.Handler", "dispatchMessage", "(Landroid.os.Message;)V");
        this.collectedMethodMap.put(extra.getMethodName(), extra);
        methodList.addAll(this.collectedMethodMap.values());
        Log.i((String)TAG, (String)"[saveCollectedMethod] size:%s incrementCount:%s path:%s", (Object[])new Object[]{this.collectedMethodMap.size(), this.incrementCount.get(), methodMapFile.getAbsolutePath()});
        Collections.sort(methodList, new Comparator<TraceMethod>(){

            @Override
            public int compare(TraceMethod o1, TraceMethod o2) {
                return o1.id - o2.id;
            }
        });
        PrintWriter pw = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(methodMapFile, false);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            pw = new PrintWriter(w);
            for (TraceMethod traceMethod : methodList) {
                traceMethod.revert(mappingCollector);
                pw.println(traceMethod.toString());
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"write method map Exception:%s", (Object[])new Object[]{e.getMessage()});
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    public static boolean isWindowFocusChangeMethod(String name, String desc) {
        return null != name && null != desc && name.equals("onWindowFocusChanged") && desc.equals("(Z)V");
    }

    public static boolean isNeedTrace(Configuration configuration, String clsName, MappingCollector mappingCollector) {
        boolean isNeed = true;
        if (configuration.blockSet.contains(clsName)) {
            isNeed = false;
        } else {
            if (null != mappingCollector) {
                clsName = mappingCollector.originalClassName(clsName, clsName);
            }
            clsName = clsName.replaceAll("/", ".");
            for (String packageName : configuration.blockSet) {
                if (!clsName.startsWith(packageName.replaceAll("/", "."))) continue;
                isNeed = false;
                break;
            }
        }
        return isNeed;
    }

    private void listClassFiles(ArrayList<File> classFiles, File folder) {
        File[] files = folder.listFiles();
        if (null == files) {
            Log.e((String)TAG, (String)"[listClassFiles] files is null! %s", (Object[])new Object[]{folder.getAbsolutePath()});
            return;
        }
        for (File file : files) {
            if (file == null) continue;
            if (file.isDirectory()) {
                this.listClassFiles(classFiles, file);
                continue;
            }
            if (!MethodCollector.isNeedTraceFile(file.getName())) continue;
            classFiles.add(file);
        }
    }

    public static boolean isNeedTraceFile(String fileName) {
        if (fileName.endsWith(".class")) {
            for (String unTraceCls : TraceBuildConstants.UN_TRACE_CLASS) {
                if (!fileName.contains(unTraceCls)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private class CollectMethodNode
    extends MethodNode {
        private String className;
        private boolean isConstructor;

        CollectMethodNode(String className, int access, String name, String desc, String signature, String[] exceptions) {
            super(327680, access, name, desc, signature, exceptions);
            this.className = className;
        }

        public void visitEnd() {
            super.visitEnd();
            TraceMethod traceMethod = TraceMethod.create(0, this.access, this.className, this.name, this.desc);
            if ("<init>".equals(this.name)) {
                this.isConstructor = true;
            }
            boolean isNeedTrace = MethodCollector.isNeedTrace(MethodCollector.this.configuration, traceMethod.className, MethodCollector.this.mappingCollector);
            if ((this.isEmptyMethod() || this.isGetSetMethod() || this.isSingleMethod()) && isNeedTrace) {
                MethodCollector.this.ignoreCount.incrementAndGet();
                MethodCollector.this.collectedIgnoreMethodMap.put(traceMethod.getMethodName(), traceMethod);
                return;
            }
            if (isNeedTrace && !MethodCollector.this.collectedMethodMap.containsKey(traceMethod.getMethodName())) {
                traceMethod.id = MethodCollector.this.methodId.incrementAndGet();
                MethodCollector.this.collectedMethodMap.put(traceMethod.getMethodName(), traceMethod);
                MethodCollector.this.incrementCount.incrementAndGet();
            } else if (!isNeedTrace && !MethodCollector.this.collectedIgnoreMethodMap.containsKey(traceMethod.className)) {
                MethodCollector.this.ignoreCount.incrementAndGet();
                MethodCollector.this.collectedIgnoreMethodMap.put(traceMethod.getMethodName(), traceMethod);
            }
        }

        private boolean isGetSetMethod() {
            int ignoreCount = 0;
            for (AbstractInsnNode insnNode : this.instructions) {
                int opcode = insnNode.getOpcode();
                if (-1 == opcode || opcode == 180 || opcode == 178 || opcode == 1 || opcode == 2 || opcode == 177 || opcode == 176 || opcode == 175 || opcode == 174 || opcode == 173 || opcode == 172 || opcode == 181 || opcode == 179 || opcode == 3 || opcode == 4 || opcode <= 53) continue;
                if (this.isConstructor && opcode == 183) {
                    if (++ignoreCount <= 1) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private boolean isSingleMethod() {
            for (AbstractInsnNode insnNode : this.instructions) {
                int opcode = insnNode.getOpcode();
                if (-1 == opcode || 182 > opcode || opcode > 186) continue;
                return false;
            }
            return true;
        }

        private boolean isEmptyMethod() {
            for (AbstractInsnNode insnNode : this.instructions) {
                int opcode = insnNode.getOpcode();
                if (-1 == opcode) continue;
                return false;
            }
            return true;
        }
    }

    private class TraceClassAdapter
    extends ClassVisitor {
        private String className;
        private boolean isABSClass;
        private boolean hasWindowFocusMethod;

        TraceClassAdapter(int i, ClassVisitor classVisitor) {
            super(i, classVisitor);
            this.isABSClass = false;
            this.hasWindowFocusMethod = false;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
            if ((access & 0x400) > 0 || (access & 0x200) > 0) {
                this.isABSClass = true;
            }
            MethodCollector.this.collectedClassExtendMap.put(this.className, superName);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.isABSClass) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            if (!this.hasWindowFocusMethod) {
                this.hasWindowFocusMethod = MethodCollector.isWindowFocusChangeMethod(name, desc);
            }
            return new CollectMethodNode(this.className, access, name, desc, signature, exceptions);
        }
    }

    class CollectJarTask
    implements Runnable {
        File fromJar;

        CollectJarTask(File jarFile) {
            this.fromJar = jarFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block11: {
                ZipFile zipFile = null;
                zipFile = new ZipFile(this.fromJar);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String zipEntryName = zipEntry.getName();
                    if (!MethodCollector.isNeedTraceFile(zipEntryName)) continue;
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    ClassReader classReader = new ClassReader(inputStream);
                    ClassWriter classWriter = new ClassWriter(1);
                    TraceClassAdapter visitor = new TraceClassAdapter(327680, (ClassVisitor)classWriter);
                    classReader.accept((ClassVisitor)visitor, 0);
                }
                try {
                    zipFile.close();
                }
                catch (Exception e) {
                    Log.e((String)MethodCollector.TAG, (String)"close stream err! fromJar:%s", (Object[])new Object[]{this.fromJar.getAbsolutePath()});
                }
                break block11;
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        try {
                            zipFile.close();
                        }
                        catch (Exception e2) {
                            Log.e((String)MethodCollector.TAG, (String)"close stream err! fromJar:%s", (Object[])new Object[]{this.fromJar.getAbsolutePath()});
                        }
                        throw throwable;
                    }
                    try {
                        zipFile.close();
                    }
                    catch (Exception e3) {
                        Log.e((String)MethodCollector.TAG, (String)"close stream err! fromJar:%s", (Object[])new Object[]{this.fromJar.getAbsolutePath()});
                    }
                }
            }
        }
    }

    class CollectSrcTask
    implements Runnable {
        File classFile;

        CollectSrcTask(File classFile) {
            this.classFile = classFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream is = null;
            try {
                is = new FileInputStream(this.classFile);
                ClassReader classReader = new ClassReader(is);
                ClassWriter classWriter = new ClassWriter(1);
                TraceClassAdapter visitor = new TraceClassAdapter(327680, (ClassVisitor)classWriter);
                classReader.accept((ClassVisitor)visitor, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

