/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.iocanary.core;

import com.tencent.matrix.iocanary.config.IOConfig;
import com.tencent.matrix.iocanary.core.IOIssue;
import com.tencent.matrix.iocanary.core.OnJniIssuePublishListener;
import com.tencent.matrix.iocanary.util.IOCanaryUtil;
import com.tencent.matrix.util.MatrixLog;
import java.util.ArrayList;

public class IOCanaryJniBridge {
    private static final String TAG = "Matrix.IOCanaryJniBridge";
    private static OnJniIssuePublishListener sOnIssuePublishListener;
    private static boolean sIsTryInstall;
    private static boolean sIsLoadJniLib;

    public static void install(IOConfig config, OnJniIssuePublishListener listener) {
        MatrixLog.v((String)TAG, (String)"install sIsTryInstall:%b", (Object[])new Object[]{sIsTryInstall});
        if (sIsTryInstall) {
            return;
        }
        if (!IOCanaryJniBridge.loadJni()) {
            MatrixLog.e((String)TAG, (String)"install loadJni failed", (Object[])new Object[0]);
            return;
        }
        sOnIssuePublishListener = listener;
        try {
            if (config != null) {
                if (config.isDetectFileIOInMainThread()) {
                    IOCanaryJniBridge.enableDetector(0);
                    IOCanaryJniBridge.setConfig(0, (long)config.getFileMainThreadTriggerThreshold() * 1000L);
                }
                if (config.isDetectFileIOBufferTooSmall()) {
                    IOCanaryJniBridge.enableDetector(1);
                    IOCanaryJniBridge.setConfig(1, config.getFileBufferSmallThreshold());
                }
                if (config.isDetectFileIORepeatReadSameFile()) {
                    IOCanaryJniBridge.enableDetector(2);
                    IOCanaryJniBridge.setConfig(2, config.getFileRepeatReadThreshold());
                }
            }
            IOCanaryJniBridge.doHook();
            sIsTryInstall = true;
        }
        catch (Error e) {
            MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"call jni method error", (Object[])new Object[0]);
        }
    }

    public static void uninstall() {
        if (!sIsTryInstall) {
            return;
        }
        IOCanaryJniBridge.doUnHook();
        sIsTryInstall = false;
    }

    private static boolean loadJni() {
        if (sIsLoadJniLib) {
            return true;
        }
        try {
            System.loadLibrary("io-canary");
        }
        catch (Exception e) {
            MatrixLog.e((String)TAG, (String)"hook: e: %s", (Object[])new Object[]{e.getLocalizedMessage()});
            sIsLoadJniLib = false;
            return false;
        }
        sIsLoadJniLib = true;
        return true;
    }

    public static void onIssuePublish(ArrayList<IOIssue> issues) {
        if (sOnIssuePublishListener == null) {
            return;
        }
        sOnIssuePublishListener.onIssuePublish(issues);
    }

    private static JavaContext getJavaContext() {
        try {
            return new JavaContext();
        }
        catch (Throwable th) {
            MatrixLog.printErrStackTrace((String)TAG, (Throwable)th, (String)"get javacontext exception", (Object[])new Object[0]);
            return null;
        }
    }

    private static native void enableDetector(int var0);

    private static native void setConfig(int var0, long var1);

    private static native boolean doHook();

    private static native boolean doUnHook();

    private static final class ConfigKey {
        static final int MAIN_THREAD_THRESHOLD = 0;
        static final int SMALL_BUFFER_THRESHOLD = 1;
        static final int REPEAT_READ_THRESHOLD = 2;

        private ConfigKey() {
        }
    }

    private static final class DetectorType {
        static final int MAIN_THREAD_IO = 0;
        static final int SMALL_BUFFER = 1;
        static final int REPEAT_READ = 2;

        private DetectorType() {
        }
    }

    private static final class JavaContext {
        private final String stack = IOCanaryUtil.getThrowableStack(new Throwable());
        private String threadName;

        private JavaContext() {
            if (null != Thread.currentThread()) {
                this.threadName = Thread.currentThread().getName();
            }
        }
    }
}

