/*
 * Decompiled with CFR 0.152.
 */
package com.toolmatrix.webview.lib_jsbridge.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.WebView;
import com.google.gson.Gson;
import com.toolmatrix.webview.lib_jsbridge.callback.JsCallback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0001J&\u0010 \u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010!J\u0010\u0010\"\u001a\u00020\u00042\b\u0010#\u001a\u0004\u0018\u00010\u0004J\u0010\u0010$\u001a\u00020\u00042\b\u0010#\u001a\u0004\u0018\u00010\u0004J\u0018\u0010%\u001a\u00020&2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010'\u001a\u00020\u0004J\u0010\u0010(\u001a\u00020\u00042\b\u0010)\u001a\u0004\u0018\u00010\u0004J0\u0010*\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010!2\b\u0010'\u001a\u0004\u0018\u00010\u0004J0\u0010,\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010!2\u0006\u0010'\u001a\u00020\u0004H\u0002J\u0016\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0004J\u001a\u0010/\u001a\u00020\u001c2\b\u0010.\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u00100\u001a\u00020\u0004J\u0018\u00101\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u00102\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/toolmatrix/webview/lib_jsbridge/util/BridgeUtil;", "", "()V", "BRIDGE_TAG", "", "CALLBACK_ID_FORMAT", "EMPTY_STR", "JAVASCRIPT_STR", "JAVA_SCRIPT", "JS_FETCH_QUEUE_FROM_JAVA", "JS_HANDLE_MESSAGE_FROM_JAVA", "JS_HANDLE_MESSAGE_FROM_JAVA_NEW", "OVERRIDE_SCHEMA", "RETURN_DATA", "SPLIT_MARK", "UNDERLINE_STR", "URL_MAX_CHARACTER_NUM", "", "YY_FETCH_QUEUE", "mGson", "Lcom/google/gson/Gson;", "mMessages", "", "assetFile2Str", "c", "Landroid/content/Context;", "urlStr", "dispatchMessage", "", "webView", "Landroid/webkit/WebView;", "message", "dispatchMessageWrapper", "", "getDataFromReturnUrl", "url", "getFunctionFromReturnUrl", "initCallback", "Lcom/toolmatrix/webview/lib_jsbridge/callback/JsCallback;", "callbackId", "parseFunctionName", "jsUrl", "responseFromWeb", "data", "sendResponse", "webViewLoadJs", "view", "webViewLoadLocalJs", "path", "wevViewLoadJsString", "jsString", "lib-jsbridge_release"})
@SourceDebugExtension(value={"SMAP\nBridgeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeUtil.kt\ncom/toolmatrix/webview/lib_jsbridge/util/BridgeUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
public final class BridgeUtil {
    @NotNull
    public static final BridgeUtil INSTANCE = new BridgeUtil();
    @NotNull
    public static final String BRIDGE_TAG = "JavascriptBridgeLog";
    @NotNull
    public static final String OVERRIDE_SCHEMA = "toolMatrix://";
    @NotNull
    public static final String RETURN_DATA = "toolMatrix://return/";
    @NotNull
    public static final String YY_FETCH_QUEUE = "toolMatrix://return/_fetchQueue/";
    @NotNull
    public static final String EMPTY_STR = "";
    @NotNull
    public static final String UNDERLINE_STR = "_";
    @NotNull
    public static final String SPLIT_MARK = "/";
    @NotNull
    public static final String CALLBACK_ID_FORMAT = "JAVA_CB_%s";
    @NotNull
    public static final String JS_HANDLE_MESSAGE_FROM_JAVA = "javascript:WebViewJavascriptBridge._handleMessageFromNative(%s);";
    @NotNull
    public static final String JS_HANDLE_MESSAGE_FROM_JAVA_NEW = "javascript:handleWebViewCallback(%s);";
    @NotNull
    public static final String JS_FETCH_QUEUE_FROM_JAVA = "javascript:WebViewJavascriptBridge._fetchQueue();";
    public static final int URL_MAX_CHARACTER_NUM = 0x200000;
    @NotNull
    public static final String JAVA_SCRIPT = "WebViewJavascriptBridge.js";
    @NotNull
    public static final String JAVASCRIPT_STR = "javascript:%s";
    @Nullable
    private static List<Object> mMessages = new ArrayList();
    @NotNull
    private static final Gson mGson = new Gson();

    private BridgeUtil() {
    }

    public final void webViewLoadJs(@NotNull WebView view, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String js = "var newscript = document.createElement(\"script\");";
        js = js + "newscript.src=\"" + url + "\";";
        js = js + "document.scripts[0].parentNode.insertBefore(newscript,document.scripts[0]);";
        view.loadUrl("javascript:" + js);
    }

    public final void webViewLoadLocalJs(@Nullable WebView view, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        WebView webView = view;
        String jsContent = this.assetFile2Str((Context)(webView != null ? webView.getContext() : null), path);
        WebView webView2 = view;
        if (webView2 != null) {
            webView2.loadUrl("javascript:" + jsContent);
        }
        List<Object> messages = mMessages;
        if (messages != null) {
            for (Object message : messages) {
                this.dispatchMessage(view, message);
            }
            mMessages = null;
        }
    }

    public static /* synthetic */ void webViewLoadLocalJs$default(BridgeUtil bridgeUtil, WebView webView, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = JAVA_SCRIPT;
        }
        bridgeUtil.webViewLoadLocalJs(webView, string);
    }

    public final void wevViewLoadJsString(@Nullable WebView webView, @NotNull String jsString) {
        block0: {
            block1: {
                Intrinsics.checkNotNullParameter((Object)jsString, (String)"jsString");
                if (Thread.currentThread() != Looper.getMainLooper().getThread()) break block0;
                if (Build.VERSION.SDK_INT < 19 || jsString.length() < 0x200000) break block1;
                WebView webView2 = webView;
                if (webView2 == null) break block0;
                webView2.evaluateJavascript("javascript:" + jsString, null);
                break block0;
            }
            WebView webView3 = webView;
            if (webView3 == null) break block0;
            webView3.loadUrl("javascript:" + jsString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String assetFile2Str(@Nullable Context c, @Nullable String urlStr) {
        InputStream in = null;
        try {
            CharSequence charSequence;
            Context context = c;
            Intrinsics.checkNotNull((Object)context);
            AssetManager assetManager = context.getAssets();
            String string = urlStr;
            Intrinsics.checkNotNull((Object)string);
            in = assetManager.open(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            StringBuilder sb = new StringBuilder();
            do {
                if ((line = bufferedReader.readLine()) == null || new Regex("^\\s*\\/\\/.*").matches(charSequence = (CharSequence)line)) continue;
                sb.append(line);
            } while (line != null);
            bufferedReader.close();
            in.close();
            charSequence = sb.toString();
            return charSequence;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @NotNull
    public final String getFunctionFromReturnUrl(@Nullable String url) {
        return EMPTY_STR;
    }

    @NotNull
    public final String getDataFromReturnUrl(@Nullable String url) {
        return EMPTY_STR;
    }

    @NotNull
    public final String parseFunctionName(@Nullable String jsUrl) {
        return EMPTY_STR;
    }

    public final void dispatchMessage(@Nullable WebView webView, @NotNull Object message) {
        block0: {
            String javascriptCommand;
            block1: {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                String messageJson = mGson.toJson(message);
                messageJson = JSONObject.quote((String)messageJson);
                Object[] objectArray = new Object[]{messageJson};
                String string = String.format(JS_HANDLE_MESSAGE_FROM_JAVA_NEW, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                javascriptCommand = string;
                if (Thread.currentThread() != Looper.getMainLooper().getThread()) break block0;
                if (Build.VERSION.SDK_INT < 19 || javascriptCommand.length() < 0x200000) break block1;
                WebView webView2 = webView;
                if (webView2 == null) break block0;
                webView2.evaluateJavascript(javascriptCommand, null);
                break block0;
            }
            WebView webView3 = webView;
            if (webView3 == null) break block0;
            webView3.loadUrl(javascriptCommand);
        }
    }

    public final void dispatchMessageWrapper(@Nullable WebView webView, @NotNull Map<String, ? extends Object> message) {
        block0: {
            String javascriptCommand;
            block1: {
                Intrinsics.checkNotNullParameter(message, (String)"message");
                String messageJson = mGson.toJson(message);
                Object[] objectArray = new Object[]{messageJson};
                String string = String.format(JS_HANDLE_MESSAGE_FROM_JAVA_NEW, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                javascriptCommand = string;
                if (Thread.currentThread() != Looper.getMainLooper().getThread()) break block0;
                if (Build.VERSION.SDK_INT < 19 || javascriptCommand.length() < 0x200000) break block1;
                WebView webView2 = webView;
                if (webView2 == null) break block0;
                webView2.evaluateJavascript(javascriptCommand, null);
                break block0;
            }
            WebView webView3 = webView;
            if (webView3 == null) break block0;
            webView3.loadUrl(javascriptCommand);
        }
    }

    private final void sendResponse(WebView webView, Map<String, ? extends Object> data, String callbackId) {
        block0: {
            block1: {
                if (TextUtils.isEmpty((CharSequence)callbackId)) break block0;
                if (Thread.currentThread() != Looper.getMainLooper().getThread()) break block1;
                this.dispatchMessageWrapper(webView, data);
                break block0;
            }
            WebView webView2 = webView;
            if (webView2 == null) break block0;
            webView2.post(() -> BridgeUtil.sendResponse$lambda$0(webView, data));
        }
    }

    public final void responseFromWeb(@Nullable WebView webView, @NotNull Map<String, ? extends Object> data, @Nullable String callbackId) {
        block0: {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            String string = callbackId;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            INSTANCE.sendResponse(webView, data, it);
        }
    }

    @NotNull
    public final JsCallback initCallback(@Nullable WebView webView, @NotNull String callbackId) {
        Intrinsics.checkNotNullParameter((Object)callbackId, (String)"callbackId");
        return new JsCallback(callbackId, webView){
            final /* synthetic */ String $callbackId;
            final /* synthetic */ WebView $webView;
            {
                this.$callbackId = $callbackId;
                this.$webView = $webView;
            }

            public void callbackSuccess(@Nullable Object data) {
                Map result = new LinkedHashMap<K, V>();
                result.put("code", 0);
                result.put("data", data);
                result.put("callbackId", this.$callbackId);
                BridgeUtil.INSTANCE.responseFromWeb(this.$webView, result, this.$callbackId);
            }

            public void callbackFail(@Nullable Object data) {
                Map result = new LinkedHashMap<K, V>();
                result.put("code", 1);
                result.put("data", data);
                result.put("callbackId", this.$callbackId);
                BridgeUtil.INSTANCE.responseFromWeb(this.$webView, result, this.$callbackId);
            }
        };
    }

    private static final void sendResponse$lambda$0(WebView $webView, Map $data) {
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        INSTANCE.dispatchMessageWrapper($webView, $data);
    }
}

