/*
 * Decompiled with CFR 0.152.
 */
package com.toolmatrix.webview.lib_jsbridge.core;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.toolmatrix.webview.lib_jsbridge.callback.IBridgeHandler;
import com.toolmatrix.webview.lib_jsbridge.callback.JsCallback;
import com.toolmatrix.webview.lib_jsbridge.entity.BridgeResponse;
import com.toolmatrix.webview.lib_jsbridge.entity.Status;
import com.toolmatrix.webview.lib_jsbridge.util.BridgeUtil;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b&\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0007JD\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0016\u0010\u001f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00010 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$H\u0007J\u0014\u0010%\u001a\u0004\u0018\u00010\u00142\b\u0010&\u001a\u0004\u0018\u00010\u0014H\u0007J\u0012\u0010'\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010\u0014H\u0007J\u0018\u0010(\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0001H\u0002J\b\u0010)\u001a\u00020\u0006H$JD\u0010*\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00142\u0016\u0010\u001f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00010 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/toolmatrix/webview/lib_jsbridge/core/BaseJavascriptInterface;", "", "webView", "Landroid/webkit/WebView;", "(Landroid/webkit/WebView;)V", "bridgeHandler", "Lcom/toolmatrix/webview/lib_jsbridge/callback/IBridgeHandler;", "getBridgeHandler", "()Lcom/toolmatrix/webview/lib_jsbridge/callback/IBridgeHandler;", "bridgeHandler$delegate", "Lkotlin/Lazy;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "mainHandler", "Landroid/os/Handler;", "getMainHandler", "()Landroid/os/Handler;", "webCallbackMethodName", "", "getWebCallbackMethodName", "()Ljava/lang/String;", "callAndroidNative", "", "data", "callbackId", "callNative", "context", "Landroid/content/Context;", "methodName", "params", "", "jsCallback", "Lcom/toolmatrix/webview/lib_jsbridge/callback/JsCallback;", "isSync", "", "callWebView", "msg", "callWebViewAsync", "callback", "createBridgeHandler", "tryInvokeMethod", "Companion", "lib-jsbridge_release"})
public abstract class BaseJavascriptInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebView webView;
    @NotNull
    private final Gson gson;
    @NotNull
    private final Handler mainHandler;
    @NotNull
    private final Lazy bridgeHandler$delegate;
    @NotNull
    public static final String METHOD = "method";
    @NotNull
    public static final String CALLBACK_ID = "callbackId";
    @NotNull
    public static final String PARAMS = "params";

    public BaseJavascriptInterface(@NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        this.webView = webView;
        this.gson = new Gson();
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.bridgeHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IBridgeHandler>(this){
            final /* synthetic */ BaseJavascriptInterface this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IBridgeHandler invoke() {
                return this.this$0.createBridgeHandler();
            }
        }));
    }

    @NotNull
    protected final Gson getGson() {
        return this.gson;
    }

    @NotNull
    protected final Handler getMainHandler() {
        return this.mainHandler;
    }

    @NotNull
    protected final IBridgeHandler getBridgeHandler() {
        Lazy lazy = this.bridgeHandler$delegate;
        return (IBridgeHandler)lazy.getValue();
    }

    @NotNull
    protected abstract IBridgeHandler createBridgeHandler();

    @NotNull
    protected abstract String getWebCallbackMethodName();

    @JvmOverloads
    @Nullable
    public final Object callNative(@NotNull Context context, @NotNull String methodName, @NotNull Map<String, ? extends Object> params, @NotNull JsCallback jsCallback, boolean isSync) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(params, (String)PARAMS);
        Intrinsics.checkNotNullParameter((Object)jsCallback, (String)"jsCallback");
        try {
            String string;
            if (isSync) {
                Object data = this.getBridgeHandler().executeSync(context, methodName, params);
                if (data instanceof BridgeResponse) {
                    Map result = new LinkedHashMap();
                    result.put("code", ((BridgeResponse)data).getCode());
                    result.put("data", ((BridgeResponse)data).getData());
                    string = this.gson.toJson((Object)result);
                } else {
                    if (data instanceof String) {
                        return data;
                    }
                    string = this.gson.toJson(data);
                }
            } else {
                this.getBridgeHandler().executeAsync(context, methodName, params, jsCallback);
                string = null;
            }
            return string;
        }
        catch (Throwable e) {
            String errorMessage = "Method '" + methodName + "' execution failed: " + e.getMessage();
            String response = this.gson.toJson((Object)new Status(1, errorMessage));
            if (!isSync) {
                jsCallback.callbackFail(response);
            }
            return response;
        }
    }

    public static /* synthetic */ Object callNative$default(BaseJavascriptInterface baseJavascriptInterface, Context context, String string, Map map, JsCallback jsCallback, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callNative");
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return baseJavascriptInterface.callNative(context, string, map, jsCallback, bl);
    }

    @JavascriptInterface
    public final void callAndroidNative(@NotNull String data, @NotNull String callbackId) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)callbackId, (String)CALLBACK_ID);
        Log.d((String)"JavascriptBridgeLog", (String)(data + ", callbackId: " + callbackId + ' ' + Thread.currentThread().getName()));
        JsCallback callback = BridgeUtil.INSTANCE.initCallback(this.webView, this.getWebCallbackMethodName(), callbackId);
        if (((CharSequence)data).length() > 0) {
            Type type2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
            Type type3 = type2;
            try {
                Map map = (Map)this.gson.fromJson(data, type3);
                String method = String.valueOf(map.get(METHOD));
                Intrinsics.checkNotNull((Object)map);
                Map params = MapsKt.minus((Map)MapsKt.minus((Map)map, (Object)METHOD), (Object)CALLBACK_ID);
                BaseJavascriptInterface.tryInvokeMethod$default(this, this.webView, method, params, callback, false, 16, null);
            }
            catch (Exception e) {
                String response = "callAndroidNative response: params invalid";
                callback.callbackFail(response);
            }
        } else {
            String response = "callAndroidNative response fail: params invalid";
            callback.callbackFail(response);
        }
    }

    private final Object tryInvokeMethod(WebView webView, String methodName, Map<String, ? extends Object> params, JsCallback jsCallback, boolean isSync) {
        Context context = webView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return this.callNative(context, methodName, params, jsCallback, isSync);
    }

    static /* synthetic */ Object tryInvokeMethod$default(BaseJavascriptInterface baseJavascriptInterface, WebView webView, String string, Map map, JsCallback jsCallback, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tryInvokeMethod");
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return baseJavascriptInterface.tryInvokeMethod(webView, string, map, jsCallback, bl);
    }

    @JavascriptInterface
    @Nullable
    public final String callWebView(@Nullable String msg) {
        Log.d((String)"JavascriptBridgeLog", (String)("\u540c\u6b65\u8c03\u7528:---->\u5185\u5bb9:" + msg + " , \u5f53\u524d\u7ebf\u7a0b:" + Thread.currentThread().getName()));
        CharSequence charSequence = msg;
        if (charSequence == null || charSequence.length() == 0) {
            return this.gson.toJson((Object)new BridgeResponse.Fail("callAndroidNative response fail: params invalid"));
        }
        Type type2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
        Type type3 = type2;
        try {
            Map map = (Map)this.gson.fromJson(msg, type3);
            String method = String.valueOf(map.get(METHOD));
            Intrinsics.checkNotNull((Object)map);
            Map params = MapsKt.minus((Map)MapsKt.minus((Map)map, (Object)METHOD), (Object)CALLBACK_ID);
            String callbackId = String.valueOf(map.get(CALLBACK_ID));
            JsCallback callback = BridgeUtil.INSTANCE.initCallback(this.webView, this.getWebCallbackMethodName(), callbackId);
            return String.valueOf(this.tryInvokeMethod(this.webView, method, params, callback, true));
        }
        catch (Exception e) {
            return this.gson.toJson((Object)new BridgeResponse.Fail("callAndroidNative response fail: params invalid"));
        }
    }

    @JavascriptInterface
    public final void callWebViewAsync(@Nullable String msg) {
        Log.d((String)"JavascriptBridgeLog", (String)("\u5f02\u6b65\u8c03\u7528:---->\u5185\u5bb9:" + msg + " , \u5f53\u524d\u7ebf\u7a0b:" + Thread.currentThread().getName()));
        CharSequence charSequence = msg;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        Type type2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
        Type type3 = type2;
        try {
            Map map = (Map)this.gson.fromJson(msg, type3);
            String method = String.valueOf(map.get(METHOD));
            Intrinsics.checkNotNull((Object)map);
            Map params = MapsKt.minus((Map)MapsKt.minus((Map)map, (Object)METHOD), (Object)CALLBACK_ID);
            String callbackId = String.valueOf(map.get(CALLBACK_ID));
            JsCallback callback = BridgeUtil.INSTANCE.initCallback(this.webView, this.getWebCallbackMethodName(), callbackId);
            this.tryInvokeMethod(this.webView, method, params, callback, false);
        }
        catch (Exception e) {
            Log.e((String)"JavascriptBridgeLog", (String)"callAndroidNative response fail: params invalid");
        }
    }

    private final void callback(String callbackId, Object data) {
        JSONObject resultObj = new JSONObject();
        resultObj.put("result", data);
        resultObj.put(CALLBACK_ID, (Object)callbackId);
        this.mainHandler.post(() -> BaseJavascriptInterface.callback$lambda$0(this, resultObj));
    }

    @JvmOverloads
    @Nullable
    public final Object callNative(@NotNull Context context, @NotNull String methodName, @NotNull Map<String, ? extends Object> params, @NotNull JsCallback jsCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(params, (String)PARAMS);
        Intrinsics.checkNotNullParameter((Object)jsCallback, (String)"jsCallback");
        return BaseJavascriptInterface.callNative$default(this, context, methodName, params, jsCallback, false, 16, null);
    }

    private static final void callback$lambda$0(BaseJavascriptInterface this$0, JSONObject $resultObj) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$resultObj, (String)"$resultObj");
        this$0.webView.loadUrl("javascript:handleWebViewCallback('" + $resultObj + "')");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/toolmatrix/webview/lib_jsbridge/core/BaseJavascriptInterface$Companion;", "", "()V", "CALLBACK_ID", "", "METHOD", "PARAMS", "lib-jsbridge_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

