/*
 * Decompiled with CFR 0.152.
 */
package com.toolmatrix.webview.lib_jsbridge.core;

import android.content.Context;
import android.webkit.WebView;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.toolmatrix.webview.lib_jsbridge.callback.IBridgeHandler;
import com.toolmatrix.webview.lib_jsbridge.callback.JsCallback;
import com.toolmatrix.webview.lib_jsbridge.entity.BridgeResponse;
import java.lang.reflect.Type;
import java.util.Map;

public class HandlerMethod {
    private final IBridgeHandler handler;
    private final String methodName;
    private final boolean sync;
    private final Gson gson = new Gson();

    private HandlerMethod(IBridgeHandler handler, String methodName, boolean sync) {
        this.handler = handler;
        this.methodName = methodName;
        this.sync = sync;
    }

    public static HandlerMethod async(IBridgeHandler handler, String methodName) {
        return new HandlerMethod(handler, methodName, false);
    }

    public static HandlerMethod sync(IBridgeHandler handler, String methodName) {
        return new HandlerMethod(handler, methodName, true);
    }

    public void callAsync(String jsonParams, String callbackId) {
        try {
            Map<String, Object> params = this.parseJsonParams(jsonParams);
            Context ctx = this.extractContext();
            JsCallback cb = this.wrapJsCallback(ctx, callbackId);
            this.handler.executeAsync(ctx, this.methodName, params, cb);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public BridgeResponse callSync(String jsonParams) {
        try {
            Map<String, Object> params = this.parseJsonParams(jsonParams);
            Context ctx = this.extractContext();
            Object result = this.handler.executeSync(ctx, this.methodName, params);
            if (result instanceof BridgeResponse) {
                return (BridgeResponse)result;
            }
            Object r = 0;
            if (result != null) {
                r = result;
            }
            return new BridgeResponse.Fail(r);
        }
        catch (Throwable t) {
            Object r = 0;
            if (t.getMessage() != null) {
                r = t.getMessage();
            }
            return new BridgeResponse.Fail(r);
        }
    }

    private Map<String, Object> parseJsonParams(String json) {
        Type type2 = new TypeToken<Map<String, Object>>(){}.getType();
        return (Map)this.gson.fromJson(json, type2);
    }

    private Context extractContext() {
        try {
            Object ins = this.handler.getClass().getDeclaredField("instance").get(this.handler);
            WebView wv = (WebView)ins.getClass().getDeclaredField("webView").get(ins);
            return wv.getContext();
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u63d0\u53d6 Context", e);
        }
    }

    private JsCallback wrapJsCallback(Context context, final String callbackId) {
        return new JsCallback(){

            @Override
            public void callbackSuccess(Object data) {
                this.send(0, data);
            }

            @Override
            public void callbackFail(Object data) {
                this.send(1, data);
            }

            private void send(int status, Object data) {
                try {
                    Object ins = HandlerMethod.this.handler.getClass().getDeclaredField("instance").get(HandlerMethod.this.handler);
                    WebView wv = (WebView)ins.getClass().getDeclaredField("webView").get(ins);
                    String payload = HandlerMethod.this.gson.toJson((Object)new CallbackPayload(callbackId, status, data));
                    wv.post(() -> wv.loadUrl("javascript:handleWebViewCallback(" + HandlerMethod.this.gson.toJson((Object)payload) + ")"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    static class CallbackPayload {
        final String callbackId;
        final Object data;
        final int code;

        CallbackPayload(String id, int code, Object d) {
            this.callbackId = id;
            this.code = code;
            this.data = d;
        }
    }

    static class ErrorResult {
        final String error;

        ErrorResult(String e) {
            this.error = e;
        }
    }
}

