/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tp.adx.open.AdError;
import com.tp.adx.open.TPAdOptions;
import com.tp.adx.open.TPInnerAdListener;
import com.tp.adx.sdk.InnerBaseMgr;
import com.tp.adx.sdk.bean.TPFullScreenInfo;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.event.InnerSendEventMessage;
import com.tp.adx.sdk.tracking.InnerTrackNotification;
import com.tp.adx.sdk.ui.InnerActivity;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.vast.VastManager;
import com.tp.vast.VastManagerFactory;
import com.tp.vast.VastTracker;
import com.tp.vast.VastVideoConfig;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.DeviceUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class InnerFullScreenMgr
extends InnerBaseMgr {
    private static final String TAG = "InnerSDK";
    private boolean isMute = true;
    private InnerSendEventMessage innerSendEventMessage;
    private boolean mIsShowing = false;
    private TPPayloadInfo.SeatBid.Bid bidInfo;
    private VastVideoConfig vastVideoConfig;
    private int rewarded;
    private boolean isReady;
    private boolean isHtml;
    private TPPayloadInfo payloadInfo;
    private int skipTime;

    public InnerFullScreenMgr(String adUnitId, String payload) {
        super(adUnitId, payload);
    }

    @Override
    public void setAdOption(TPAdOptions options) {
        super.setAdOption(options);
        this.isMute = options.isMute();
        this.rewarded = options.getRewarded();
        this.skipTime = options.getSkipTime();
    }

    @Override
    public void loadAd() {
        if (this.tpInnerAdListener == null) {
            this.tpInnerAdListener = new TPInnerAdListener();
        }
        if (this.adUnitId == null || this.adUnitId.length() <= 0) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1000, "adUnitId is null"));
            return;
        }
        if (this.payload == null || this.payload.length() <= 0) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1001, "payload is null"));
            return;
        }
        Log.v((String)TAG, (String)"fullscreen loadStart");
        InnerLog.v(TAG, "payload:" + this.payload + " adUnitId:" + this.adUnitId);
        this.payloadInfo = (TPPayloadInfo)JSON.parseObject((String)this.payload, TPPayloadInfo.class);
        this.innerSendEventMessage = new InnerSendEventMessage(GlobalTradPlus.getInstance().getContext(), this.adUnitId, this.payloadInfo);
        this.innerSendEventMessage.sendLoadAdNetworkStart();
        if (this.payloadInfo == null || this.payloadInfo.getSeatBid() == null || this.payloadInfo.getSeatBid().size() <= 0 || this.payloadInfo.getSeatBid().get(0).getBid() == null || this.payloadInfo.getSeatBid().get(0).getBid().size() <= 0) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1100, "no fill, payload is null"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(12);
            return;
        }
        this.mIsShowing = false;
        try {
            this.startLoad(this.payloadInfo);
        }
        catch (Exception e) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1005, "payload parse error"));
            return;
        }
    }

    private void startLoad(TPPayloadInfo payloadInfo) {
        this.bidInfo = payloadInfo.getSeatBid().get(0).getBid().get(0);
        if (this.bidInfo.getAdm() == null) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1100, "no fill\uff0cadm is null"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(12);
            return;
        }
        if (!DeviceUtils.isNetworkAvailable((Context)GlobalTradPlus.getInstance().getContext())) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1002, "network is not connection"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(7);
            return;
        }
        if (this.checkAdIsTimeOut(this.bidInfo)) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1004, "payload is timeout"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(16);
            return;
        }
        this.parseAdm(this.bidInfo);
    }

    private void parseAdm(final TPPayloadInfo.SeatBid.Bid bidInfo) {
        this.innerSendEventMessage.sendLoadAdNetworkEnd(1);
        this.startTimeOutDelay(this.innerSendEventMessage);
        Log.v((String)TAG, (String)"fullscreen download video start");
        final long startTime = System.currentTimeMillis();
        final VastManager vastManager = VastManagerFactory.create(GlobalTradPlus.getInstance().getContext(), true);
        vastManager.prepareVastVideoConfiguration(bidInfo.getAdm(), new VastManager.VastManagerListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onVastVideoConfigurationPrepared(VastVideoConfig vastVideoConfig) {
                block9: {
                    InnerLog.v(InnerFullScreenMgr.TAG, "onVastVideoConfigurationPrepared " + (vastVideoConfig == null ? "null" : vastVideoConfig.toJsonString()));
                    InnerFullScreenMgr.this.endOverTimeRunnable(InnerFullScreenMgr.this.innerSendEventMessage != null ? InnerFullScreenMgr.this.innerSendEventMessage.getRequestId() : "");
                    if (vastVideoConfig == null || vastVideoConfig.getDiskMediaFileUrl() == null) {
                        if (InnerFullScreenMgr.this.innerSendEventMessage != null && vastManager.isStartDownload()) {
                            InnerFullScreenMgr.this.innerSendEventMessage.sendDownloadAdEnd("5840", 18, startTime);
                        }
                        if (bidInfo.getAdm().contains("<VAST")) {
                            if (InnerFullScreenMgr.this.tpInnerAdListener != null) {
                                InnerFullScreenMgr.this.tpInnerAdListener.onAdLoadFailed(new AdError(1006, "ad media source download fail"));
                            }
                            return;
                        }
                        if (bidInfo.getAdm().startsWith("<") || bidInfo.getAdm().contains("mraid.js")) {
                            InnerFullScreenMgr.this.isHtml = true;
                            break block9;
                        } else {
                            if (InnerFullScreenMgr.this.tpInnerAdListener != null) {
                                InnerFullScreenMgr.this.tpInnerAdListener.onAdLoadFailed(new AdError(1006, "ad media source download fail"));
                            }
                            return;
                        }
                    }
                    if (InnerFullScreenMgr.this.innerSendEventMessage != null) {
                        InnerFullScreenMgr.this.innerSendEventMessage.sendDownloadAdEnd("5840", 1, startTime);
                    }
                }
                InnerFullScreenMgr.this.vastVideoConfig = vastVideoConfig;
                InnerFullScreenMgr.this.getTrackUrlToBidInfo(bidInfo, vastVideoConfig);
                if (InnerFullScreenMgr.this.tpInnerAdListener != null) {
                    InnerFullScreenMgr.this.isReady = true;
                    InnerTrackNotification.sendWinNotification(bidInfo, VastManager.getVastNetworkMediaUrl(vastVideoConfig));
                    InnerFullScreenMgr.this.tpInnerAdListener.onAdLoaded();
                }
            }

            @Override
            public void onVastVideoDownloadStart() {
                InnerFullScreenMgr.this.innerSendEventMessage.sendDownloadAdStart("5830");
            }
        }, bidInfo.getCrid(), GlobalTradPlus.getInstance().getContext());
    }

    private void getTrackUrlToBidInfo(TPPayloadInfo.SeatBid.Bid bid, VastVideoConfig config) {
        if (bid == null || config == null) {
            return;
        }
        if (bid.getExt() == null) {
            bid.setExt(new TPPayloadInfo.SeatBid.Bid.Ext());
        }
        for (VastTracker vastTracker : config.getImpressionTrackers()) {
            if (TextUtils.isEmpty((CharSequence)vastTracker.getContent())) continue;
            bid.getExt().getImpurl().add(vastTracker.getContent());
        }
        for (VastTracker vastTracker : config.getClickTrackers()) {
            if (TextUtils.isEmpty((CharSequence)vastTracker.getContent())) continue;
            bid.getExt().getClkurl().add(vastTracker.getContent());
        }
    }

    public boolean isReady() {
        this.innerSendEventMessage.sendAdNetworkIsReady(0, this.isReady);
        return this.isReady && !this.checkAdIsTimeOut(this.bidInfo) && this.rewarded == 0 ? true : this.hasDiskFileUrl();
    }

    public void show() {
        TPPayloadInfo.Ext.AppRenderStye appRenderStye;
        TPFullScreenInfo tpFullScreenInfo = new TPFullScreenInfo();
        tpFullScreenInfo.setAdUnitId(this.adUnitId);
        tpFullScreenInfo.setBidInfo(this.bidInfo);
        tpFullScreenInfo.setVastVideoConfig(this.vastVideoConfig);
        tpFullScreenInfo.setMute(this.isMute);
        tpFullScreenInfo.setIsRewared(this.rewarded);
        tpFullScreenInfo.setHtml(this.isHtml);
        tpFullScreenInfo.setInnerSendEventMessage(this.innerSendEventMessage);
        tpFullScreenInfo.setTpPayloadInfo(this.payloadInfo);
        tpFullScreenInfo.setTpInnerAdListener(this.tpInnerAdListener);
        tpFullScreenInfo.setSkipTime(this.skipTime);
        if (this.payloadInfo != null && this.payloadInfo.getExt() != null && (appRenderStye = this.payloadInfo.getExt().getRender_style()) != null) {
            tpFullScreenInfo.setEndcard_close_time(appRenderStye.getEndcard_close_time());
            tpFullScreenInfo.setInterstitial_video_skip_time(appRenderStye.getVideo_skip_time());
            tpFullScreenInfo.setCanFullClick(appRenderStye.getVideo_click_area() == 2);
        }
        InnerFullscreenAdMessager.getInstance().setListener(this.adUnitId, tpFullScreenInfo);
        InnerActivity.start(this.adUnitId);
    }

    public boolean hasDiskFileUrl() {
        String diskFile;
        if (this.isHtml) {
            return true;
        }
        if (this.vastVideoConfig != null && !TextUtils.isEmpty((CharSequence)(diskFile = this.vastVideoConfig.getDiskMediaFileUrl()))) {
            File f = new File(diskFile);
            return f.exists();
        }
        return false;
    }

    public static class InnerFullscreenAdMessager {
        public static final String TAG = InnerFullscreenAdMessager.class.getSimpleName();
        private Map<String, TPFullScreenInfo> mEventMap = new HashMap<String, TPFullScreenInfo>(2);

        private InnerFullscreenAdMessager() {
        }

        public static InnerFullscreenAdMessager getInstance() {
            return Holder.sInstance;
        }

        public void setListener(String key, TPFullScreenInfo tpFullScreenInfo) {
            this.mEventMap.put(key, tpFullScreenInfo);
        }

        public TPFullScreenInfo getListener(String key) {
            return this.mEventMap.get(key);
        }

        public void unRegister(String key) {
            this.mEventMap.remove(key);
        }

        private static class Holder {
            private static final InnerFullscreenAdMessager sInstance = new InnerFullscreenAdMessager();

            private Holder() {
            }
        }
    }
}

