/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.tracking;

import android.util.Log;
import com.tp.adx.sdk.tracking.InnerTrackNotification;
import com.tp.vast.VastAbsoluteProgressTracker;
import com.tp.vast.VastCompanionAdConfig;
import com.tp.vast.VastFractionalProgressTracker;
import com.tp.vast.VastManager;
import com.tp.vast.VastTracker;
import com.tp.vast.VastVideoConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class InnerVastNotificationUtils {
    private static InnerVastNotificationUtils instance;

    public static InnerVastNotificationUtils getInstance() {
        if (instance == null) {
            instance = new InnerVastNotificationUtils();
        }
        return instance;
    }

    public void sendProgressNotification(int progress, VastVideoConfig vastVideoConfig) {
        ArrayList<VastTracker> completeTrackers;
        Log.i((String)"InnerVastNotification", (String)("sendProgressNotification = " + progress));
        if (vastVideoConfig == null) {
            return;
        }
        if (progress == 0) {
            ArrayList<VastAbsoluteProgressTracker> absoluteTrackers = vastVideoConfig.getAbsoluteTrackers();
            if (absoluteTrackers == null || absoluteTrackers.size() <= 0) {
                return;
            }
            Log.i((String)"InnerVastNotification", (String)("sendProgressNotification start = " + absoluteTrackers.get(0).getContent()));
            InnerTrackNotification.sendVideoProgressNotification(absoluteTrackers.get(0).getContent(), VastManager.getVastNetworkMediaUrl(vastVideoConfig));
        } else {
            ArrayList<VastFractionalProgressTracker> trackers = vastVideoConfig.getFractionalTrackers();
            if (trackers == null || trackers.size() <= 0) {
                return;
            }
            if (progress == 25 && trackers.size() > 0) {
                Log.i((String)"InnerVastNotification", (String)("sendProgressNotification 25 = " + trackers.get(0).getContent()));
                InnerTrackNotification.sendVideoProgressNotification(trackers.get(0).getContent(), VastManager.getVastNetworkMediaUrl(vastVideoConfig));
            } else if (progress == 50 && trackers.size() > 1) {
                Log.i((String)"InnerVastNotification", (String)("sendProgressNotification 50 = " + trackers.get(1).getContent()));
                InnerTrackNotification.sendVideoProgressNotification(trackers.get(1).getContent(), VastManager.getVastNetworkMediaUrl(vastVideoConfig));
            } else if (progress == 75 && trackers.size() > 2) {
                Log.i((String)"InnerVastNotification", (String)("sendProgressNotification 75 = " + trackers.get(2).getContent()));
                InnerTrackNotification.sendVideoProgressNotification(trackers.get(2).getContent(), VastManager.getVastNetworkMediaUrl(vastVideoConfig));
            }
        }
        if (progress == 100 && (completeTrackers = vastVideoConfig.getCompleteTrackers()) != null) {
            for (int i = 0; i < completeTrackers.size(); ++i) {
                Log.i((String)"InnerVastNotification", (String)("sendProgressNotification complete i = " + i + " url = " + completeTrackers.get(i).getContent()));
                InnerTrackNotification.sendVideoProgressNotification(completeTrackers.get(i).getContent(), VastManager.getVastNetworkMediaUrl(vastVideoConfig));
            }
        }
    }

    public void sendResumeNotification(VastVideoConfig vastVideoConfig) {
        if (vastVideoConfig == null) {
            return;
        }
        ArrayList<VastTracker> resumeTrackers = vastVideoConfig.getResumeTrackers();
        if (resumeTrackers != null) {
            for (int i = 0; i < resumeTrackers.size(); ++i) {
                Log.i((String)"InnerVastNotification", (String)("sendResumeNotification resume i = " + i + " url = " + resumeTrackers.get(i).getContent()));
                InnerTrackNotification.sendVideoProgressNotification(resumeTrackers.get(i).getContent(), VastManager.getVastNetworkMediaUrl(vastVideoConfig));
            }
        }
    }

    public void sendPauseNotification(VastVideoConfig vastVideoConfig) {
        if (vastVideoConfig == null) {
            return;
        }
        ArrayList<VastTracker> pauseTrackers = vastVideoConfig.getPauseTrackers();
        if (pauseTrackers != null) {
            for (int i = 0; i < pauseTrackers.size(); ++i) {
                Log.i((String)"InnerVastNotification", (String)("sendPauseNotification pause i = " + i + " url = " + pauseTrackers.get(i).getContent()));
                InnerTrackNotification.sendVideoProgressNotification(pauseTrackers.get(i).getContent(), VastManager.getVastNetworkMediaUrl(vastVideoConfig));
            }
        }
    }

    public void sendSkipNotification(VastVideoConfig vastVideoConfig) {
        if (vastVideoConfig == null) {
            return;
        }
        ArrayList<VastTracker> skipTrackers = vastVideoConfig.getSkipTrackers();
        if (skipTrackers != null) {
            for (int i = 0; i < skipTrackers.size(); ++i) {
                Log.i((String)"InnerVastNotification", (String)("sendSkipNotification skip i = " + i + " url = " + skipTrackers.get(i).getContent()));
                InnerTrackNotification.sendVideoProgressNotification(skipTrackers.get(i).getContent(), VastManager.getVastNetworkMediaUrl(vastVideoConfig));
            }
        }
    }

    public void sendCloseNotification(VastVideoConfig vastVideoConfig) {
        if (vastVideoConfig == null) {
            return;
        }
        ArrayList<VastTracker> closeTrackers = vastVideoConfig.getCloseTrackers();
        if (closeTrackers != null) {
            for (int i = 0; i < closeTrackers.size(); ++i) {
                Log.i((String)"InnerVastNotification", (String)("sendCloseNotification close i = " + i + " url = " + closeTrackers.get(i).getContent()));
                InnerTrackNotification.sendVideoProgressNotification(closeTrackers.get(i).getContent(), VastManager.getVastNetworkMediaUrl(vastVideoConfig));
            }
        }
    }

    public void sendUntriggerNotification(VastVideoConfig vastVideoConfig, int current, int length) {
        Log.i((String)"InnerVastNotification", (String)("sendProgressNotification current = " + current + " length = " + length));
        if (vastVideoConfig == null) {
            return;
        }
        List<VastTracker> untriggeredTrackersBefore = vastVideoConfig.getUntriggeredTrackersBefore(current, length);
        if (untriggeredTrackersBefore != null) {
            for (int i = 0; i < untriggeredTrackersBefore.size(); ++i) {
                Log.i((String)"InnerVastNotification", (String)("sendUntriggerNotification untrigger i = " + i + " url = " + untriggeredTrackersBefore.get(i).getContent()));
                InnerTrackNotification.sendVideoProgressNotification(untriggeredTrackersBefore.get(i).getContent(), VastManager.getVastNetworkMediaUrl(vastVideoConfig));
            }
        }
    }

    public void sendCompanionClickNotification(VastVideoConfig vastVideoConfig) {
        if (vastVideoConfig == null) {
            return;
        }
        Set<VastCompanionAdConfig> vastCompanionAdConfigs = vastVideoConfig.getVastCompanionAdConfigs();
        if (vastCompanionAdConfigs != null) {
            for (VastCompanionAdConfig next : vastCompanionAdConfigs) {
                List<VastTracker> clickTrackers;
                if (next == null || (clickTrackers = next.getClickTrackers()) == null) continue;
                for (int i = 0; i < clickTrackers.size(); ++i) {
                    Log.i((String)"InnerVastNotification", (String)("sendCompanionClickNotification companionClick i = " + i + " url = " + clickTrackers.get(i).getContent()));
                    InnerTrackNotification.sendVideoProgressNotification(clickTrackers.get(i).getContent(), VastManager.getVastNetworkMediaUrl(vastVideoConfig));
                }
            }
        }
    }

    public void sendCompanionImpNotification(VastVideoConfig vastVideoConfig) {
        if (vastVideoConfig == null) {
            return;
        }
        Set<VastCompanionAdConfig> vastCompanionAdConfigs = vastVideoConfig.getVastCompanionAdConfigs();
        if (vastCompanionAdConfigs != null) {
            for (VastCompanionAdConfig next : vastCompanionAdConfigs) {
                List<VastTracker> creativeViewTrackers;
                if (next == null || (creativeViewTrackers = next.getCreativeViewTrackers()) == null) continue;
                for (int i = 0; i < creativeViewTrackers.size(); ++i) {
                    Log.i((String)"InnerVastNotification", (String)("sendCompanionImpNotification companionImp i = " + i + " url = " + creativeViewTrackers.get(i).getContent()));
                    InnerTrackNotification.sendVideoProgressNotification(creativeViewTrackers.get(i).getContent(), VastManager.getVastNetworkMediaUrl(vastVideoConfig));
                }
            }
        }
    }
}

