/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.util;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

public class ViewUtils {
    public static final int LAYOUT_PARAMS_TOP_R = 1;
    public static final int LAYOUT_PARAMS_TOP_L = 2;
    public static final int LAYOUT_PARAMS_BOT_R = 3;
    public static final int LAYOUT_PARAMS_BOT_L = 4;

    public static ViewGroup.LayoutParams generateLayoutParamsByViewGroup(ViewGroup viewGroup, int width, int height, int position) {
        if (viewGroup instanceof FrameLayout) {
            FrameLayout.LayoutParams fl = new FrameLayout.LayoutParams(width, height);
            ViewUtils.setFrameLayoutParamsPosition(fl, position);
            return fl;
        }
        if (viewGroup instanceof RelativeLayout) {
            RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(width, height);
            ViewUtils.setRelativeLayoutParamsPosition(rl, position);
            return rl;
        }
        if (viewGroup instanceof LinearLayout) {
            LinearLayout.LayoutParams ll = new LinearLayout.LayoutParams(width, height);
            switch (position) {
                case 1: {
                    ll.gravity = 53;
                    break;
                }
                case 2: {
                    ll.gravity = 51;
                    break;
                }
                case 3: {
                    ll.gravity = 85;
                    break;
                }
                case 4: {
                    ll.gravity = 83;
                    break;
                }
            }
            return ll;
        }
        return new ViewGroup.LayoutParams(width, height);
    }

    public static void setFrameLayoutParamsPosition(FrameLayout.LayoutParams params, int position) {
        switch (position) {
            case 1: {
                params.gravity = 53;
                break;
            }
            case 2: {
                params.gravity = 51;
                break;
            }
            case 3: {
                params.gravity = 85;
                break;
            }
            case 4: {
                params.gravity = 83;
                break;
            }
        }
    }

    public static void setRelativeLayoutParamsPosition(RelativeLayout.LayoutParams params, int position) {
        switch (position) {
            case 1: {
                params.addRule(10);
                params.addRule(11);
                break;
            }
            case 2: {
                params.addRule(10);
                params.addRule(9);
                break;
            }
            case 3: {
                params.addRule(12);
                params.addRule(11);
                break;
            }
            case 4: {
                params.addRule(12);
                params.addRule(9);
                break;
            }
        }
    }

    public static int dp2px(Context context, int width) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int)((float)width * density + 0.5f);
    }

    public static boolean isCover(View view) {
        boolean totalViewVisible;
        View currentView = view;
        Rect currentViewRect = new Rect();
        boolean partVisible = currentView.getGlobalVisibleRect(currentViewRect);
        boolean halfPercentVisible = (currentViewRect.bottom - currentViewRect.top) * (currentViewRect.right - currentViewRect.left) >= view.getMeasuredHeight() * view.getMeasuredWidth() / 2;
        boolean bl = totalViewVisible = partVisible && halfPercentVisible;
        if (!totalViewVisible) {
            return true;
        }
        while (currentView.getParent() instanceof ViewGroup) {
            ViewGroup currentParent = (ViewGroup)currentView.getParent();
            if (currentParent.getVisibility() != 0) {
                return true;
            }
            int start = ViewUtils.indexOfViewInParent(currentView, currentParent);
            for (int i = start + 1; i < currentParent.getChildCount(); ++i) {
                int height;
                int width;
                ColorDrawable colorDrawable;
                Drawable background;
                Rect viewRect = new Rect();
                view.getGlobalVisibleRect(viewRect);
                View otherView = currentParent.getChildAt(i);
                if (otherView.getVisibility() != 0 || (background = otherView.getBackground()) == null || background instanceof ColorDrawable && (colorDrawable = (ColorDrawable)background).getAlpha() == 0) continue;
                Rect otherViewRect = new Rect();
                otherView.getGlobalVisibleRect(otherViewRect);
                if (!Rect.intersects((Rect)viewRect, (Rect)otherViewRect) || (width = Math.min(viewRect.right, otherViewRect.right) - Math.max(viewRect.left, otherViewRect.left)) * (height = Math.min(viewRect.bottom, otherViewRect.bottom) - Math.max(viewRect.top, otherViewRect.top)) * 2 < view.getMeasuredHeight() * view.getMeasuredWidth()) continue;
                return true;
            }
            currentView = currentParent;
        }
        return false;
    }

    private static int indexOfViewInParent(View view, ViewGroup parent) {
        int index;
        for (index = 0; index < parent.getChildCount() && parent.getChildAt(index) != view; ++index) {
        }
        return index;
    }
}

