/*
 * Decompiled with CFR 0.152.
 */
package com.tp.common;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.StatFs;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.tp.adx.sdk.util.InnerLog;
import com.tradplus.ads.common.CreativeOrientation;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.Reflection;
import com.tradplus.ads.common.util.Utils;
import java.io.File;
import java.net.SocketException;

public class DeviceUtils {
    private static final int MAX_MEMORY_CACHE_SIZE = 0x1E00000;
    private static final int MIN_DISK_CACHE_SIZE = 0x1E00000;
    private static final int MAX_DISK_CACHE_SIZE = 0x6400000;

    private DeviceUtils() {
    }

    public static boolean isNetworkAvailable(Context context) {
        if (context == null) {
            return false;
        }
        try {
            ConnectivityManager connnectionManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connnectionManager.getActiveNetworkInfo();
            return networkInfo.isConnected();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static int memoryCacheSizeBytes(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        long memoryClass = activityManager.getMemoryClass();
        try {
            int flagLargeHeap = ApplicationInfo.class.getDeclaredField("FLAG_LARGE_HEAP").getInt(null);
            if (Utils.bitMaskContainsFlag((int)context.getApplicationInfo().flags, (int)flagLargeHeap)) {
                memoryClass = ((Integer)new Reflection.MethodBuilder((Object)activityManager, "getLargeMemoryClass").execute()).intValue();
            }
        }
        catch (Exception e) {
            InnerLog.v("Unable to reflectively determine large heap size.");
        }
        long result = Math.min(0x1E00000L, memoryClass / 8L * 1024L * 1024L);
        return (int)result;
    }

    public static long diskCacheSizeBytes(File dir, long minSize) {
        long size = minSize;
        try {
            StatFs statFs = new StatFs(dir.getAbsolutePath());
            long availableBytes = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
            size = availableBytes / 50L;
        }
        catch (IllegalArgumentException e) {
            InnerLog.v("Unable to calculate 2% of available disk space, defaulting to minimum");
        }
        return Math.max(Math.min(size, 0x6400000L), 0x1E00000L);
    }

    public static long diskCacheSizeBytes(File dir) {
        return DeviceUtils.diskCacheSizeBytes(dir, 0x1E00000L);
    }

    public static int getScreenOrientation(Activity activity) {
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int deviceOrientation = activity.getResources().getConfiguration().orientation;
        return DeviceUtils.getScreenOrientationFromRotationAndOrientation(rotation, deviceOrientation);
    }

    static int getScreenOrientationFromRotationAndOrientation(int rotation, int orientation) {
        if (1 == orientation) {
            switch (rotation) {
                case 1: 
                case 2: {
                    return 9;
                }
            }
            return 1;
        }
        if (2 == orientation) {
            switch (rotation) {
                case 2: 
                case 3: {
                    return 8;
                }
            }
            return 0;
        }
        InnerLog.v("Unknown screen orientation. Defaulting to portrait.");
        return 9;
    }

    public static void lockOrientation(Activity activity, CreativeOrientation creativeOrientation) {
        if (!Preconditions.NoThrow.checkNotNull((Object)creativeOrientation) || !Preconditions.NoThrow.checkNotNull((Object)activity)) {
            return;
        }
        Display display = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
        int currentRotation = display.getRotation();
        int deviceOrientation = activity.getResources().getConfiguration().orientation;
        int currentOrientation = DeviceUtils.getScreenOrientationFromRotationAndOrientation(currentRotation, deviceOrientation);
        int requestedOrientation = CreativeOrientation.PORTRAIT == creativeOrientation ? (9 == currentOrientation ? 9 : 1) : (CreativeOrientation.LANDSCAPE == creativeOrientation ? (8 == currentOrientation ? 8 : 0) : 4);
        activity.setRequestedOrientation(requestedOrientation);
    }

    public static Point getDeviceDimensions(Context context) {
        Integer bestWidthPixels = null;
        Integer bestHeightPixels = null;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager != null) {
            Display display = windowManager.getDefaultDisplay();
            Point screenSize = new Point();
            display.getRealSize(screenSize);
            bestWidthPixels = screenSize.x;
            bestHeightPixels = screenSize.y;
        }
        if (bestWidthPixels == null) {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            bestWidthPixels = displayMetrics.widthPixels;
            bestHeightPixels = displayMetrics.heightPixels;
        }
        return new Point(bestWidthPixels.intValue(), bestHeightPixels.intValue());
    }

    @Deprecated
    public static String getIpAddress(IP ip) throws SocketException {
        return null;
    }

    @Deprecated
    public static String getHashedUdid(Context context) {
        return null;
    }

    @Deprecated
    public static enum IP {
        IPv4,
        IPv6;

    }

    public static enum ForceOrientation {
        FORCE_PORTRAIT("portrait"),
        FORCE_LANDSCAPE("landscape"),
        DEVICE_ORIENTATION("device"),
        UNDEFINED("");

        private final String mKey;

        private ForceOrientation(String key) {
            this.mKey = key;
        }

        public static ForceOrientation getForceOrientation(String key) {
            for (ForceOrientation orientation : ForceOrientation.values()) {
                if (!orientation.mKey.equalsIgnoreCase(key)) continue;
                return orientation;
            }
            return UNDEFINED;
        }
    }
}

