/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import com.tp.vast.ViewabilityVendor;
import com.tradplus.ads.base.util.XmlUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;

class VastAdVerificationsParser {
    private static final String AD_VERIFICATIONS = "AdVerifications";
    private static final String VERIFICATION = "Verification";
    private static final String VENDOR = "vendor";
    private static final String JAVASCRIPT_RESOURCE = "JavaScriptResource";
    private static final String TRACKING_EVENTS = "TrackingEvents";
    private static final String EVENT = "event";
    private static final String VERIFICATION_PARAMETERS = "VerificationParameters";
    private static final String TRACKING = "Tracking";
    private static final String API_FRAMEWORK = "apiFramework";
    private static final String OMID = "omid";
    private static final String VERIFICATION_NOT_EXECUTED = "verificationNotExecuted";
    private final Set<ViewabilityVendor> viewabilityVendors = new HashSet<ViewabilityVendor>();

    VastAdVerificationsParser(Node adVerificationsParent) {
        if (adVerificationsParent != null) {
            this.parse(adVerificationsParent);
        }
    }

    private void parse(Node adVerificationParent) {
        Node adVerifications = XmlUtils.getFirstMatchingChildNode((Node)adVerificationParent, (String)AD_VERIFICATIONS);
        List verificationNodes = XmlUtils.getMatchingChildNodes((Node)adVerifications, (String)VERIFICATION);
        if (verificationNodes == null || verificationNodes.isEmpty()) {
            return;
        }
        for (Node verification : verificationNodes) {
            Node javascriptNode = XmlUtils.getFirstMatchingChildNode((Node)verification, (String)JAVASCRIPT_RESOURCE, (String)API_FRAMEWORK, Collections.singletonList(OMID));
            if (javascriptNode == null) continue;
            Node trackingEventsNode = XmlUtils.getFirstMatchingChildNode((Node)verification, (String)TRACKING_EVENTS);
            Node notExecutedNode = XmlUtils.getFirstMatchingChildNode((Node)trackingEventsNode, (String)TRACKING, (String)EVENT, Collections.singletonList(VERIFICATION_NOT_EXECUTED));
            Node parametersNode = XmlUtils.getFirstMatchingChildNode((Node)verification, (String)VERIFICATION_PARAMETERS);
            String javascriptResource = XmlUtils.getNodeValue((Node)javascriptNode);
            ViewabilityVendor.Builder builder = new ViewabilityVendor.Builder(javascriptResource);
            builder.withApiFramework(OMID).withVendorKey(XmlUtils.getAttributeValue((Node)verification, (String)VENDOR)).withVerificationParameters(XmlUtils.getNodeValue((Node)parametersNode)).withVerificationNotExecuted(XmlUtils.getNodeValue((Node)notExecutedNode));
            ViewabilityVendor viewabilityVendor = builder.build();
            if (viewabilityVendor == null) continue;
            this.viewabilityVendors.add(viewabilityVendor);
        }
    }

    Set<ViewabilityVendor> getViewabilityVendors() {
        return this.viewabilityVendors;
    }
}

