/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import com.tp.adx.sdk.util.InnerLog;
import com.tp.vast.VastAbsoluteProgressTracker;
import com.tp.vast.VastFractionalProgressTracker;
import com.tp.vast.VastIconXmlManager;
import com.tp.vast.VastMediaXmlManager;
import com.tp.vast.VastTracker;
import com.tradplus.ads.base.util.XmlUtils;
import com.tradplus.ads.common.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;

class VastLinearXmlManager {
    private static final String TRACKING_EVENTS = "TrackingEvents";
    private static final String VIDEO_CLICKS = "VideoClicks";
    private static final String VIDEO_TRACKER = "Tracking";
    private static final String CLICK_THROUGH = "ClickThrough";
    private static final String CLICK_TRACKER = "ClickTracking";
    private static final String MEDIA_FILES = "MediaFiles";
    private static final String MEDIA_FILE = "MediaFile";
    public static final String ICONS = "Icons";
    public static final String ICON = "Icon";
    private static final String EVENT = "event";
    private static final String OFFSET = "offset";
    private static final String SKIP_OFFSET = "skipoffset";
    private static final String CREATIVE_VIEW = "creativeView";
    private static final String START = "start";
    private static final String FIRST_QUARTILE = "firstQuartile";
    private static final String MIDPOINT = "midpoint";
    private static final String THIRD_QUARTILE = "thirdQuartile";
    private static final String COMPLETE = "complete";
    private static final String PAUSE = "pause";
    private static final String RESUME = "resume";
    private static final String CLOSE = "close";
    private static final String CLOSE_LINEAR = "closeLinear";
    private static final String PROGRESS = "progress";
    private static final String SKIP = "skip";
    private static final int CREATIVE_VIEW_TRACKER_THRESHOLD = 0;
    private static final int START_TRACKER_THRESHOLD = 0;
    private static final float FIRST_QUARTER_MARKER = 0.25f;
    private static final float MID_POINT_MARKER = 0.5f;
    private static final float THIRD_QUARTER_MARKER = 0.75f;
    private final Node mLinearNode;

    VastLinearXmlManager(Node linearNode) {
        Preconditions.checkNotNull((Object)linearNode);
        this.mLinearNode = linearNode;
    }

    List<VastFractionalProgressTracker> getFractionalProgressTrackers() {
        ArrayList<VastFractionalProgressTracker> percentTrackers = new ArrayList<VastFractionalProgressTracker>();
        this.addQuartileTrackerWithFraction(percentTrackers, this.getVideoTrackersByAttribute(FIRST_QUARTILE), 0.25f);
        this.addQuartileTrackerWithFraction(percentTrackers, this.getVideoTrackersByAttribute(MIDPOINT), 0.5f);
        this.addQuartileTrackerWithFraction(percentTrackers, this.getVideoTrackersByAttribute(THIRD_QUARTILE), 0.75f);
        Node trackingEvents = XmlUtils.getFirstMatchingChildNode((Node)this.mLinearNode, (String)TRACKING_EVENTS);
        if (trackingEvents != null) {
            List progressNodes = XmlUtils.getMatchingChildNodes((Node)trackingEvents, (String)VIDEO_TRACKER, (String)EVENT, Collections.singletonList(PROGRESS));
            for (Node progressNode : progressNodes) {
                String offsetString = XmlUtils.getAttributeValue((Node)progressNode, (String)OFFSET);
                if (offsetString == null || !VastFractionalProgressTracker.Companion.isPercentageTracker(offsetString = offsetString.trim())) continue;
                String trackingUrl = XmlUtils.getNodeValue((Node)progressNode);
                try {
                    float trackingFraction = Float.parseFloat(offsetString.replace("%", "")) / 100.0f;
                    if (!(trackingFraction >= 0.0f)) continue;
                    percentTrackers.add(new VastFractionalProgressTracker.Builder(trackingUrl, trackingFraction).build());
                }
                catch (NumberFormatException e) {
                    InnerLog.v(String.format("Failed to parse VAST progress tracker %s", offsetString));
                }
            }
        }
        Collections.sort(percentTrackers);
        return percentTrackers;
    }

    List<VastAbsoluteProgressTracker> getAbsoluteProgressTrackers() {
        ArrayList<VastAbsoluteProgressTracker> trackers = new ArrayList<VastAbsoluteProgressTracker>();
        List<String> startTrackers = this.getVideoTrackersByAttribute(START);
        for (String url : startTrackers) {
            trackers.add(new VastAbsoluteProgressTracker.Builder(url, 0).build());
        }
        Node trackingEvents = XmlUtils.getFirstMatchingChildNode((Node)this.mLinearNode, (String)TRACKING_EVENTS);
        if (trackingEvents != null) {
            List progressNodes = XmlUtils.getMatchingChildNodes((Node)trackingEvents, (String)VIDEO_TRACKER, (String)EVENT, Collections.singletonList(PROGRESS));
            for (Node progressNode : progressNodes) {
                String offsetString = XmlUtils.getAttributeValue((Node)progressNode, (String)OFFSET);
                if (offsetString == null || !VastAbsoluteProgressTracker.Companion.isAbsoluteTracker(offsetString = offsetString.trim())) continue;
                String trackingUrl = XmlUtils.getNodeValue((Node)progressNode);
                try {
                    Integer trackingMilliseconds = VastAbsoluteProgressTracker.Companion.parseAbsoluteOffset(offsetString);
                    if (trackingMilliseconds == null || trackingMilliseconds < 0) continue;
                    trackers.add(new VastAbsoluteProgressTracker.Builder(trackingUrl, trackingMilliseconds).build());
                }
                catch (NumberFormatException e) {
                    InnerLog.v(String.format("Failed to parse VAST progress tracker %s", offsetString));
                }
            }
            List creativeViewNodes = XmlUtils.getMatchingChildNodes((Node)trackingEvents, (String)VIDEO_TRACKER, (String)EVENT, Collections.singletonList(CREATIVE_VIEW));
            for (Node creativeViewNode : creativeViewNodes) {
                String creativeNodeValue = XmlUtils.getNodeValue((Node)creativeViewNode);
                if (creativeNodeValue == null) continue;
                trackers.add(new VastAbsoluteProgressTracker.Builder(creativeNodeValue, 0).build());
            }
        }
        Collections.sort(trackers);
        return trackers;
    }

    List<VastTracker> getVideoCompleteTrackers() {
        return this.getVideoTrackersByAttributeAsVastTrackers(COMPLETE);
    }

    List<VastTracker> getPauseTrackers() {
        List<String> trackers = this.getVideoTrackersByAttribute(PAUSE);
        ArrayList<VastTracker> vastRepeatableTrackers = new ArrayList<VastTracker>();
        for (String tracker : trackers) {
            vastRepeatableTrackers.add(new VastTracker.Builder(tracker).isRepeatable(true).build());
        }
        return vastRepeatableTrackers;
    }

    List<VastTracker> getResumeTrackers() {
        List<String> trackers = this.getVideoTrackersByAttribute(RESUME);
        ArrayList<VastTracker> vastRepeatableTrackers = new ArrayList<VastTracker>();
        for (String tracker : trackers) {
            vastRepeatableTrackers.add(new VastTracker.Builder(tracker).isRepeatable(true).build());
        }
        return vastRepeatableTrackers;
    }

    List<VastTracker> getVideoCloseTrackers() {
        List<VastTracker> closeTrackers = this.getVideoTrackersByAttributeAsVastTrackers(CLOSE);
        closeTrackers.addAll(this.getVideoTrackersByAttributeAsVastTrackers(CLOSE_LINEAR));
        return closeTrackers;
    }

    List<VastTracker> getVideoSkipTrackers() {
        return this.getVideoTrackersByAttributeAsVastTrackers(SKIP);
    }

    String getClickThroughUrl() {
        Node videoClicks = XmlUtils.getFirstMatchingChildNode((Node)this.mLinearNode, (String)VIDEO_CLICKS);
        if (videoClicks == null) {
            return null;
        }
        return XmlUtils.getNodeValue((Node)XmlUtils.getFirstMatchingChildNode((Node)videoClicks, (String)CLICK_THROUGH));
    }

    List<VastTracker> getClickTrackers() {
        ArrayList<VastTracker> clickTrackers = new ArrayList<VastTracker>();
        Node videoClicks = XmlUtils.getFirstMatchingChildNode((Node)this.mLinearNode, (String)VIDEO_CLICKS);
        if (videoClicks == null) {
            return clickTrackers;
        }
        List clickTrackerNodes = XmlUtils.getMatchingChildNodes((Node)videoClicks, (String)CLICK_TRACKER);
        for (Node clickTrackerNode : clickTrackerNodes) {
            String tracker = XmlUtils.getNodeValue((Node)clickTrackerNode);
            if (tracker == null) continue;
            clickTrackers.add(new VastTracker.Builder(tracker).build());
        }
        return clickTrackers;
    }

    String getSkipOffset() {
        String skipOffsetString = XmlUtils.getAttributeValue((Node)this.mLinearNode, (String)SKIP_OFFSET);
        if (skipOffsetString == null) {
            return null;
        }
        if (skipOffsetString.trim().isEmpty()) {
            return null;
        }
        return skipOffsetString.trim();
    }

    List<VastMediaXmlManager> getMediaXmlManagers() {
        ArrayList<VastMediaXmlManager> mediaXmlManagers = new ArrayList<VastMediaXmlManager>();
        Node mediaFiles = XmlUtils.getFirstMatchingChildNode((Node)this.mLinearNode, (String)MEDIA_FILES);
        if (mediaFiles == null) {
            return mediaXmlManagers;
        }
        List mediaNodes = XmlUtils.getMatchingChildNodes((Node)mediaFiles, (String)MEDIA_FILE);
        for (Node mediaNode : mediaNodes) {
            mediaXmlManagers.add(new VastMediaXmlManager(mediaNode));
        }
        return mediaXmlManagers;
    }

    List<VastIconXmlManager> getIconXmlManagers() {
        ArrayList<VastIconXmlManager> iconXmlManagers = new ArrayList<VastIconXmlManager>();
        Node icons = XmlUtils.getFirstMatchingChildNode((Node)this.mLinearNode, (String)ICONS);
        if (icons == null) {
            return iconXmlManagers;
        }
        List iconNodes = XmlUtils.getMatchingChildNodes((Node)icons, (String)ICON);
        for (Node iconNode : iconNodes) {
            iconXmlManagers.add(new VastIconXmlManager(iconNode));
        }
        return iconXmlManagers;
    }

    private List<VastTracker> getVideoTrackersByAttributeAsVastTrackers(String attributeValue) {
        List<String> trackers = this.getVideoTrackersByAttribute(attributeValue);
        ArrayList<VastTracker> vastTrackers = new ArrayList<VastTracker>(trackers.size());
        for (String tracker : trackers) {
            vastTrackers.add(new VastTracker.Builder(tracker).build());
        }
        return vastTrackers;
    }

    private List<String> getVideoTrackersByAttribute(String attributeValue) {
        Preconditions.checkNotNull((Object)attributeValue);
        ArrayList<String> videoTrackers = new ArrayList<String>();
        Node trackingEvents = XmlUtils.getFirstMatchingChildNode((Node)this.mLinearNode, (String)TRACKING_EVENTS);
        if (trackingEvents == null) {
            return videoTrackers;
        }
        List videoTrackerNodes = XmlUtils.getMatchingChildNodes((Node)trackingEvents, (String)VIDEO_TRACKER, (String)EVENT, Collections.singletonList(attributeValue));
        for (Node videoTrackerNode : videoTrackerNodes) {
            String tracker = XmlUtils.getNodeValue((Node)videoTrackerNode);
            if (tracker == null) continue;
            videoTrackers.add(tracker);
        }
        return videoTrackers;
    }

    private void addQuartileTrackerWithFraction(List<VastFractionalProgressTracker> trackers, List<String> urls, float fraction) {
        Preconditions.checkNotNull(trackers, (String)"trackers cannot be null");
        Preconditions.checkNotNull(urls, (String)"urls cannot be null");
        for (String url : urls) {
            trackers.add(new VastFractionalProgressTracker.Builder(url, fraction).build());
        }
    }
}

