/*
 * Decompiled with CFR 0.152.
 */
package com.tp.ads.adx;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.tp.ads.adx.AdxErrorUtil;
import com.tp.adx.open.AdError;
import com.tp.adx.open.TPAdOptions;
import com.tp.adx.open.TPInnerAdListener;
import com.tp.adx.open.TPInnerBannerAd;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AdxBannerAdapter
extends TPBannerAdapter {
    private static final String TAG = "AdxBanner";
    private TPBannerAdImpl tpBannerAd;
    private TPInnerBannerAd tpInnerBannerAd;

    public void clean() {
        if (this.tpInnerBannerAd != null) {
            this.tpInnerBannerAd.onDestroy();
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("40");
    }

    public String getNetworkVersion() {
        return "40.10.5.0";
    }

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        String provicy_icon;
        String placementId = tpParams.get("placementId");
        String payload = tpParams.get("ADX-Payload");
        String isClosable = tpParams.get("is_closable");
        String startTimeStr = tpParams.get("ADX-Payload_Start_time");
        String tempWidth = tpParams.get("ad_size_info_x" + placementId);
        String tempHeight = tpParams.get("ad_size_info_y" + placementId);
        int width = tempWidth == null ? 0 : Integer.valueOf(tempWidth);
        int height = tempHeight == null ? 0 : Integer.valueOf(tempHeight);
        Log.v((String)TAG, (String)("loadCustomAd placementId:" + placementId + " isClosable:" + isClosable + " startTime:" + startTimeStr + " width:" + width + " height:" + height));
        if (placementId == null || placementId.length() <= 0 || payload == null || payload.length() <= 0) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        boolean privacyIcon = true;
        if (userParams.containsKey("adx_provicy_icon") && (provicy_icon = (String)userParams.get("adx_provicy_icon")).equals("1")) {
            privacyIcon = false;
        }
        long startTime = 0L;
        try {
            startTime = startTimeStr == null ? 0L : Long.parseLong(startTimeStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tpInnerBannerAd = new TPInnerBannerAd(context, placementId, payload);
        this.tpInnerBannerAd.setAdOptions(new TPAdOptions.Builder().setBannerSize(width, height).setShowCloseBtn(isClosable != null && "1".equals(isClosable)).setPayloadStartTime(startTime).build());
        this.tpInnerBannerAd.needPrivacyIcon(privacyIcon);
        this.tpInnerBannerAd.setAdListener(new TPInnerAdListener(){

            @Override
            public void onAdLoaded() {
                Log.v((String)AdxBannerAdapter.TAG, (String)"onAdLoaded");
                if (AdxBannerAdapter.this.mLoadAdapterListener != null) {
                    AdxBannerAdapter.this.tpBannerAd = new TPBannerAdImpl(null, (View)AdxBannerAdapter.this.tpInnerBannerAd);
                    AdxBannerAdapter.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)AdxBannerAdapter.this.tpBannerAd);
                }
            }

            @Override
            public void onAdImpression() {
                Log.v((String)AdxBannerAdapter.TAG, (String)"onAdImpression");
                if (AdxBannerAdapter.this.tpBannerAd != null) {
                    AdxBannerAdapter.this.tpBannerAd.adShown();
                }
            }

            @Override
            public void onAdLoadFailed(AdError error) {
                Log.v((String)AdxBannerAdapter.TAG, (String)("onAdLoadFailed code:" + error.getErrorCode() + " msg:" + error.getErrorMsg()));
                if (AdxBannerAdapter.this.mLoadAdapterListener != null) {
                    AdxBannerAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(AdxErrorUtil.getTradPlusErrorCode(error));
                }
            }

            @Override
            public void onAdClicked() {
                if (AdxBannerAdapter.this.tpBannerAd != null) {
                    AdxBannerAdapter.this.tpBannerAd.adClicked();
                }
            }

            @Override
            public void onAdClosed() {
                if (AdxBannerAdapter.this.tpBannerAd != null) {
                    AdxBannerAdapter.this.tpBannerAd.adClosed();
                }
            }
        });
        this.tpInnerBannerAd.loadAd();
    }
}

