/*
 * Decompiled with CFR 0.152.
 */
package com.tp.ads.adx;

import android.content.Context;
import android.text.TextUtils;
import com.tp.ads.adx.AdxErrorUtil;
import com.tp.adx.open.AdError;
import com.tp.adx.open.TPAdOptions;
import com.tp.adx.open.TPInnerAdListener;
import com.tp.adx.open.TPInnerFullScreen;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AdxRewardAdapter
extends TPRewardAdapter {
    private TPInnerFullScreen tpInnerReward;

    public void showAd() {
        if (this.tpInnerReward != null) {
            this.tpInnerReward.show();
        }
    }

    public boolean isReady() {
        if (this.tpInnerReward != null) {
            return !this.isAdsTimeOut() && this.tpInnerReward.isReady();
        }
        return false;
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("40");
    }

    public String getNetworkVersion() {
        return "40.10.5.0";
    }

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        boolean isMute;
        String placementId = tpParams.get("placementId");
        String payload = tpParams.get("ADX-Payload");
        String mute = tpParams.get("video_mute");
        String startTimeStr = tpParams.get("ADX-Payload_Start_time");
        String skipTimeStr = tpParams.get("skip_time");
        boolean bl = TextUtils.isEmpty((CharSequence)mute) ? true : (isMute = TextUtils.equals((CharSequence)"1", (CharSequence)mute));
        if (placementId == null || placementId.length() == 0 || payload == null || payload.length() == 0) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        long startTime = 0L;
        try {
            startTime = startTimeStr == null ? 0L : Long.parseLong(startTimeStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tpInnerReward = new TPInnerFullScreen(placementId, payload);
        this.tpInnerReward.setAdOptions(new TPAdOptions.Builder().setPayloadStartTime(startTime).setMute(isMute).setSkipTime(Integer.parseInt(skipTimeStr)).setRewarded(1).build());
        this.tpInnerReward.setAdListener(new TPInnerAdListener(){

            @Override
            public void onAdLoaded() {
                AdxRewardAdapter.this.setFirstLoadedTime();
                if (AdxRewardAdapter.this.mLoadAdapterListener != null) {
                    AdxRewardAdapter.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }

            @Override
            public void onAdLoadFailed(AdError error) {
                if (AdxRewardAdapter.this.mLoadAdapterListener != null) {
                    AdxRewardAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(AdxErrorUtil.getTradPlusErrorCode(error));
                }
            }

            @Override
            public void onAdClosed() {
                if (AdxRewardAdapter.this.mShowListener != null) {
                    AdxRewardAdapter.this.mShowListener.onAdClosed();
                }
            }

            @Override
            public void onAdClicked() {
                if (AdxRewardAdapter.this.mShowListener != null) {
                    AdxRewardAdapter.this.mShowListener.onAdClicked();
                }
            }

            @Override
            public void onAdImpression() {
                if (AdxRewardAdapter.this.mShowListener != null) {
                    AdxRewardAdapter.this.mShowListener.onAdShown();
                }
            }

            @Override
            public void onReward() {
                if (AdxRewardAdapter.this.mShowListener != null) {
                    AdxRewardAdapter.this.mShowListener.onReward();
                }
            }

            @Override
            public void onVideoStart() {
                if (AdxRewardAdapter.this.mShowListener != null) {
                    AdxRewardAdapter.this.mShowListener.onAdVideoStart();
                }
            }

            @Override
            public void onVideoEnd() {
                if (AdxRewardAdapter.this.mShowListener != null) {
                    AdxRewardAdapter.this.mShowListener.onAdVideoEnd();
                }
            }
        });
        this.tpInnerReward.loadAd();
    }
}

