/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.event;

import android.content.Context;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.event.BaseInnerEventRequest;
import com.tp.adx.sdk.event.InnerEventRequest;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.event.TPPushCenter;
import java.util.UUID;

public class InnerSendEventMessage {
    public static final String EVENT_ADX_INIT = "5100";
    public static final String EVENT_ADX_LOADAD_START = "5700";
    public static final String EVENT_ADX_LOADAD_END = "5800";
    public static final String EVENT_ADX_VIDEO_DOWN_START = "5830";
    public static final String EVENT_ADX_VIDEO_DOWN_END = "5840";
    public static final String EVENT_ADX_IMG_DOWN_START = "5850";
    public static final String EVENT_ADX_IMG_DOWN_END = "5860";
    public static final String EVENT_ADX_IS_READY = "5900";
    public static final String EVENT_ADX_SHOW_START = "6000";
    public static final String EVENT_ADX_SHOW_END = "6100";
    public static final String EVENT_ADX_THIRD_SHOW_START = "6145";
    public static final String EVENT_ADX_THIRD_SHOW_END = "6150";
    public static final String EVENT_ADX_CLICK_AD_START = "6200";
    public static final String EVENT_ADX_CLICK_AD_END = "6230";
    public static final String EVENT_ADX_AUTO_JUMP = "6300";
    public static final String EVENT_ADX_CLOSE_AD = "6400";
    public static final String EVENT_ADX_OPEN_AD = "6240";
    public static final String EVENT_ADX_THIRD_CLICK_START = "6245";
    public static final String EVENT_ADX_THIRD_CLICK_END = "6250";
    public static final int ERROR_CODE_SUCCESS = 1;
    public static final int ERROR_CODE_NO_FILL = 15;
    public static final int ERROR_CODE_PAYLOAD_TIME_OUT = 16;
    public static final int ERROR_CODE_NETWORK_TIMEOUT = 3;
    public static final int ERROR_CODE_NO_CONNECTION = 7;
    public static final int ERROR_CODE_DATA_NULL = 12;
    public static final int ERROR_CODE_DATA_PARSE_NULL = 17;
    public static final int ERROR_CODE_DATA_DOWNLOAD_NULL = 18;
    public static final int ERROR_CODE_HAS_CACHED = 2001;
    public static final int ERROR_CODE_IS_LOADING = 2101;
    public static final int ERROR_CODE_UNSPECIFIED = 2;
    public static final int ERROR_CODE_NO_IMG = 20;
    public static final int ERROR_CODE_NO_VIDEO = 21;
    public static final int ERROR_CODE_NOT_READY = 5;
    public static final int ERROR_CODE_SHOW_FAILED = 14;
    public static final int ERROR_CODE_VIDEO_PLAY_FAILED = 24;
    public static final int ERROR_CODE_JUMP_FAILED = 32;
    private Context context;
    private String request;
    private String pid;
    private TPPayloadInfo.Ext.Tp tp;
    private TPPayloadInfo tpPayloadInfo;
    private long loadStartTime = 0L;

    public InnerSendEventMessage(Context context, String pid, TPPayloadInfo tpPayloadInfo) {
        this.context = context == null ? GlobalTradPlus.getInstance().getContext() : context.getApplicationContext();
        this.pid = pid;
        this.request = UUID.randomUUID().toString();
        this.tpPayloadInfo = tpPayloadInfo;
        if (tpPayloadInfo != null && tpPayloadInfo.getExt() != null) {
            this.tp = tpPayloadInfo.getExt().getTp();
        }
    }

    public InnerSendEventMessage(Context context, String pid, String requestId, TPPayloadInfo tpPayloadInfo) {
        this.context = context == null ? GlobalTradPlus.getInstance().getContext() : context.getApplicationContext();
        this.pid = pid;
        this.request = requestId;
        this.tpPayloadInfo = tpPayloadInfo;
        if (tpPayloadInfo != null && tpPayloadInfo.getExt() != null) {
            this.tp = tpPayloadInfo.getExt().getTp();
        }
    }

    public String getRequestId() {
        return this.request;
    }

    public String getPid() {
        return this.pid;
    }

    public void sendOpenAPIStart() {
        if (this.context == null) {
            return;
        }
        TPPushCenter.getInstance().saveAdxEvent((Object)new BaseInnerEventRequest(this.context, EVENT_ADX_INIT, this.request, this.pid, null));
    }

    public void sendLoadAdNetworkStart() {
        if (this.context == null) {
            return;
        }
        this.loadStartTime = System.currentTimeMillis();
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, EVENT_ADX_LOADAD_START, this.request, this.pid, this.tp);
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public void sendLoadAdNetworkEnd(int errorCode) {
        if (this.context == null) {
            return;
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, EVENT_ADX_LOADAD_END, this.request, this.pid, this.tp);
        eventStartRequest.setError_code(errorCode);
        eventStartRequest.setLoad_time(System.currentTimeMillis() - this.loadStartTime);
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public void sendDownloadAdStart(String event) {
        if (this.context == null) {
            return;
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, event, this.request, this.pid, this.tp);
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public void sendDownloadAdEnd(String event, int errorCode, long startTime) {
        if (this.context == null) {
            return;
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, event, this.request, this.pid, this.tp);
        if (errorCode >= 0) {
            eventStartRequest.setError_code(errorCode);
        }
        if (startTime >= 0L) {
            eventStartRequest.setLoad_time(System.currentTimeMillis() - startTime);
        }
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public void sendAdNetworkIsReady(int errorCode, boolean isReady) {
        if (this.context == null) {
            return;
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, EVENT_ADX_IS_READY, this.request, this.pid, this.tp);
        if (errorCode >= 0) {
            eventStartRequest.setError_code(errorCode);
        }
        eventStartRequest.setIs_ad_ready(isReady ? 1 : 0);
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public void sendShowAdStart() {
        if (this.context == null) {
            return;
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, EVENT_ADX_SHOW_START, this.request, this.pid, this.tp);
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public void sendShowEndAd(int errorCode) {
        if (this.context == null) {
            return;
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, EVENT_ADX_SHOW_END, this.request, this.pid, this.tp);
        if (errorCode >= 0) {
            eventStartRequest.setError_code(errorCode);
        }
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public void sendThirdShowStart(String event, int errorCode) {
        if (this.context == null) {
            return;
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, event, this.request, this.pid, this.tp);
        if (errorCode >= 0) {
            eventStartRequest.setError_code(errorCode);
        }
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public void sendClickAdStart(float x, float y) {
        if (this.context == null) {
            return;
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, EVENT_ADX_CLICK_AD_START, this.request, this.pid, this.tp);
        eventStartRequest.setTouchx(x);
        eventStartRequest.setTouchy(y);
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public void sendClickAdStart() {
        this.sendClickAdStart(0.0f, 0.0f);
    }

    public void sendCloseAd(float x, float y) {
        if (this.context == null) {
            return;
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, EVENT_ADX_CLOSE_AD, this.request, this.pid, this.tp);
        eventStartRequest.setTouchx(x);
        eventStartRequest.setTouchy(y);
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public void sendClickAdEnd(int errorCode) {
        if (this.context == null) {
            return;
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, EVENT_ADX_CLICK_AD_END, this.request, this.pid, this.tp);
        if (errorCode >= 0) {
            eventStartRequest.setError_code(errorCode);
        }
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public void sendAutoJumpAction(String ecpm, int tag) {
        if (this.context == null) {
            return;
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, EVENT_ADX_AUTO_JUMP, this.request, this.pid, this.tp);
        eventStartRequest.setEcpm(ecpm);
        eventStartRequest.setIntercept_tag(tag);
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public static void sendOpenAd(Context context, String request, String pid, int errorCode, TPPayloadInfo tpPayloadInfo) {
        if (context == null) {
            return;
        }
        TPPayloadInfo.Ext.Tp tp = null;
        if (tpPayloadInfo != null && tpPayloadInfo.getExt() != null) {
            tp = tpPayloadInfo.getExt().getTp();
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(context, EVENT_ADX_OPEN_AD, request, pid, tp);
        if (errorCode >= 0) {
            eventStartRequest.setError_code(errorCode);
        }
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public void sendThirdClickStart(String event, int errorCode) {
        if (this.context == null) {
            return;
        }
        InnerEventRequest eventStartRequest = new InnerEventRequest(this.context, event, this.request, this.pid, this.tp);
        if (errorCode >= 0) {
            eventStartRequest.setError_code(errorCode);
        }
        TPPushCenter.getInstance().saveAdxEvent((Object)eventStartRequest);
    }

    public TPPayloadInfo getTpPayloadInfo() {
        return this.tpPayloadInfo;
    }

    public void setTpPayloadInfo(TPPayloadInfo tpPayloadInfo) {
        this.tpPayloadInfo = tpPayloadInfo;
    }
}

