/*
 * Decompiled with CFR 0.152.
 */
package com.tp.common;

import com.tp.adx.sdk.util.InnerLog;
import com.tradplus.ads.common.Preconditions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public abstract class TPHttpUrlConnection
extends HttpURLConnection {
    private static final int CONNECT_TIMEOUT = 20000;
    private static final int READ_TIMEOUT = 20000;

    private TPHttpUrlConnection(URL url) {
        super(url);
    }

    public static HttpURLConnection getHttpUrlConnection(String url) throws IOException {
        String getUrl;
        Preconditions.checkNotNull((Object)url);
        if (TPHttpUrlConnection.isUrlImproperlyEncoded(url)) {
            throw new IllegalArgumentException("URL is improperly encoded: " + url);
        }
        try {
            getUrl = TPHttpUrlConnection.urlEncode(url);
        }
        catch (Exception e) {
            getUrl = url;
        }
        HttpURLConnection urlConnection = (HttpURLConnection)new URL(getUrl).openConnection();
        urlConnection.setRequestProperty("user-agent", System.getProperty("http.agent"));
        urlConnection.setConnectTimeout(20000);
        urlConnection.setReadTimeout(20000);
        return urlConnection;
    }

    public static String urlEncode(String url) throws Exception {
        Preconditions.checkNotNull((Object)url);
        if (TPHttpUrlConnection.isUrlImproperlyEncoded(url)) {
            throw new UnsupportedEncodingException("URL is improperly encoded: " + url);
        }
        URI uri = TPHttpUrlConnection.isUrlUnencoded(url) ? TPHttpUrlConnection.encodeUrl(url) : new URI(url);
        return uri.toURL().toString();
    }

    static boolean isUrlImproperlyEncoded(String url) {
        try {
            URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            InnerLog.v("Url is improperly encoded: " + url);
            return true;
        }
        return false;
    }

    static boolean isUrlUnencoded(String url) {
        try {
            new URI(url);
        }
        catch (URISyntaxException e) {
            return true;
        }
        return false;
    }

    static URI encodeUrl(String urlString) throws Exception {
        URI uri;
        try {
            URL url = new URL(urlString);
            uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
        catch (Exception e) {
            InnerLog.v("Failed to encode url: " + urlString);
            throw e;
        }
        return uri;
    }
}

