/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import android.os.AsyncTask;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.common.CacheService;
import com.tp.common.TPHttpUrlConnection;
import com.tp.common.util.AsyncTasks;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.Streams;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.util.ArrayDeque;
import java.util.Deque;

public class VideoDownloader {
    private static final int MAX_VIDEO_SIZE = 0x1900000;
    private static final Deque<WeakReference<VideoDownloaderTask>> sDownloaderTasks = new ArrayDeque<WeakReference<VideoDownloaderTask>>();

    private VideoDownloader() {
    }

    public static void cache(String url, VideoDownloaderListener listener) {
        Preconditions.checkNotNull((Object)listener);
        listener.onStart();
        if (url == null) {
            InnerLog.v("VideoDownloader attempted to cache video with null url.");
            listener.onComplete(false);
            return;
        }
        VideoDownloaderTask videoDownloaderTask = new VideoDownloaderTask(listener);
        try {
            AsyncTasks.safeExecuteOnExecutor(videoDownloaderTask, url);
        }
        catch (Exception e) {
            listener.onComplete(false);
        }
    }

    public static void cancelAllDownloaderTasks() {
        for (WeakReference<VideoDownloaderTask> weakDownloaderTask : sDownloaderTasks) {
            VideoDownloader.cancelOneTask(weakDownloaderTask);
        }
        sDownloaderTasks.clear();
    }

    public static void cancelLastDownloadTask() {
        if (sDownloaderTasks.isEmpty()) {
            return;
        }
        VideoDownloader.cancelOneTask(sDownloaderTasks.peekLast());
        sDownloaderTasks.removeLast();
    }

    private static boolean cancelOneTask(WeakReference<VideoDownloaderTask> weakDownloaderTask) {
        if (weakDownloaderTask == null) {
            return false;
        }
        VideoDownloaderTask downloaderTask = (VideoDownloaderTask)((Object)weakDownloaderTask.get());
        if (downloaderTask == null) {
            return false;
        }
        return downloaderTask.cancel(true);
    }

    @Deprecated
    public static Deque<WeakReference<VideoDownloaderTask>> getDownloaderTasks() {
        return sDownloaderTasks;
    }

    @Deprecated
    public static void clearDownloaderTasks() {
        sDownloaderTasks.clear();
    }

    static class VideoDownloaderTask
    extends AsyncTask<String, Void, Boolean> {
        private final VideoDownloaderListener mListener;
        private final WeakReference<VideoDownloaderTask> mWeakSelf;

        VideoDownloaderTask(VideoDownloaderListener listener) {
            this.mListener = listener;
            this.mWeakSelf = new WeakReference<VideoDownloaderTask>(this);
            sDownloaderTasks.add(this.mWeakSelf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground(String ... params) {
            Boolean bl;
            BufferedInputStream inputStream;
            HttpURLConnection urlConnection;
            String videoUrl;
            block13: {
                block12: {
                    if (params == null || params.length == 0 || params[0] == null) {
                        InnerLog.v("VideoDownloader task tried to execute null or empty url.");
                        return false;
                    }
                    videoUrl = params[0];
                    urlConnection = null;
                    inputStream = null;
                    urlConnection = TPHttpUrlConnection.getHttpUrlConnection(videoUrl);
                    inputStream = new BufferedInputStream(urlConnection.getInputStream());
                    int statusCode = urlConnection.getResponseCode();
                    if (statusCode >= 200 && statusCode < 300) break block12;
                    InnerLog.v("VideoDownloader encountered unexpected statusCode: " + statusCode);
                    Boolean bl2 = false;
                    Streams.closeStream((Closeable)inputStream);
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                    return bl2;
                }
                int contentLength = urlConnection.getContentLength();
                if (contentLength <= 0x1900000) break block13;
                InnerLog.v(String.format("VideoDownloader encountered video larger than disk cap. (%d bytes / %d maximum).", contentLength, 0x1900000));
                Boolean bl3 = false;
                Streams.closeStream((Closeable)inputStream);
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                return bl3;
            }
            try {
                boolean diskPutResult = CacheService.putToDiskCache(videoUrl, inputStream);
                bl = diskPutResult;
            }
            catch (Exception e) {
                Boolean bl4;
                try {
                    InnerLog.v("VideoDownloader task threw an internal exception." + e);
                    bl4 = false;
                }
                catch (Throwable throwable) {
                    Streams.closeStream(inputStream);
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                    throw throwable;
                }
                Streams.closeStream((Closeable)inputStream);
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                return bl4;
            }
            Streams.closeStream((Closeable)inputStream);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            return bl;
        }

        protected void onPostExecute(Boolean success) {
            if (this.isCancelled()) {
                this.onCancelled();
                return;
            }
            sDownloaderTasks.remove(this.mWeakSelf);
            if (success == null) {
                this.mListener.onComplete(false);
                return;
            }
            this.mListener.onComplete(success);
        }

        protected void onCancelled() {
            InnerLog.v("VideoDownloader task was cancelled.");
            sDownloaderTasks.remove(this.mWeakSelf);
            this.mListener.onComplete(false);
        }
    }

    static interface VideoDownloaderListener {
        public void onComplete(boolean var1);

        public void onStart();
    }
}

