/*
 * Decompiled with CFR 0.152.
 */
package com.tp.ads.adx;

import android.content.Context;
import android.text.TextUtils;
import com.tp.ads.adx.AdxErrorUtil;
import com.tp.ads.adx.AdxMediaVideoAd;
import com.tp.adx.open.AdError;
import com.tp.adx.open.TPAdOptions;
import com.tp.adx.open.TPInnerAdListener;
import com.tp.adx.open.TPInnerMediaVideo;
import com.tradplus.ads.base.adapter.mediavideo.TPMediaVideoAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.base.common.TPVideoAdPlayer;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AdxMediaViewAdapter
extends TPMediaVideoAdapter {
    private TPInnerMediaVideo tpInnerMediaVideo;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        boolean isMute;
        String placementId = tpParams.get("placementId");
        String payload = tpParams.get("ADX-Payload");
        String mute = tpParams.get("video_mute");
        String startTimeStr = tpParams.get("ADX-Payload_Start_time");
        boolean bl = TextUtils.isEmpty((CharSequence)mute) ? true : (isMute = TextUtils.equals((CharSequence)"1", (CharSequence)mute));
        if (placementId == null || placementId.length() <= 0 || payload == null || payload.length() <= 0) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (this.mVideoObject == null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Video object is null"));
            return;
        }
        long startTime = 0L;
        try {
            startTime = startTimeStr == null ? 0L : Long.parseLong(startTimeStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String detailLayoutId = "";
        if (userParams != null && userParams.size() > 0 && userParams.containsKey("tp_inner_mediaview_layout_id")) {
            detailLayoutId = (String)userParams.get("tp_inner_mediaview_layout_id");
        }
        this.tpInnerMediaVideo = new TPInnerMediaVideo(placementId, payload);
        this.tpInnerMediaVideo.setAdOptions(new TPAdOptions.Builder().setPayloadStartTime(startTime).setMute(isMute).build());
        this.tpInnerMediaVideo.setTpVideoAdPlayer((TPVideoAdPlayer)this.mVideoObject);
        this.tpInnerMediaVideo.setAdContainerView(this.mAdContainerView);
        this.tpInnerMediaVideo.setDetailLayoutId(detailLayoutId);
        this.tpInnerMediaVideo.setAdListener(new TPInnerAdListener(){

            @Override
            public void onAdLoaded() {
                AdxMediaViewAdapter.this.setFirstLoadedTime();
                if (AdxMediaViewAdapter.this.mLoadAdapterListener != null) {
                    AdxMediaVideoAd adxMediaVideoAd = new AdxMediaVideoAd(AdxMediaViewAdapter.this.tpInnerMediaVideo);
                    AdxMediaViewAdapter.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)adxMediaVideoAd);
                }
            }

            @Override
            public void onAdLoadFailed(AdError error) {
                if (AdxMediaViewAdapter.this.mLoadAdapterListener != null) {
                    AdxMediaViewAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(AdxErrorUtil.getTradPlusErrorCode(error));
                }
            }

            @Override
            public void onAdClosed() {
                if (AdxMediaViewAdapter.this.mShowListener != null) {
                    AdxMediaViewAdapter.this.mShowListener.onAdVideoEnd();
                }
            }

            @Override
            public void onAdClicked() {
                if (AdxMediaViewAdapter.this.mShowListener != null) {
                    AdxMediaViewAdapter.this.mShowListener.onAdClicked();
                }
            }

            @Override
            public void onAdImpression() {
                if (AdxMediaViewAdapter.this.mShowListener != null) {
                    AdxMediaViewAdapter.this.mShowListener.onAdShown();
                }
            }

            @Override
            public void onVideoStart() {
                if (AdxMediaViewAdapter.this.mShowListener != null) {
                    AdxMediaViewAdapter.this.mShowListener.onAdVideoStart();
                }
            }

            @Override
            public void onVideoEnd() {
                if (AdxMediaViewAdapter.this.mShowListener != null) {
                    AdxMediaViewAdapter.this.mShowListener.onAdVideoEnd();
                }
            }

            @Override
            public void onSkip() {
                if (AdxMediaViewAdapter.this.mShowListener != null) {
                    AdxMediaViewAdapter.this.mShowListener.onAdSkiped();
                }
            }

            @Override
            public void onAdResume() {
                if (AdxMediaViewAdapter.this.mShowListener != null) {
                    AdxMediaViewAdapter.this.mShowListener.onAdResume();
                }
            }

            @Override
            public void onAdPause() {
                if (AdxMediaViewAdapter.this.mShowListener != null) {
                    AdxMediaViewAdapter.this.mShowListener.onAdPause();
                }
            }

            @Override
            public void onAdProgress(float currentTime, double adBreakDuration) {
                if (AdxMediaViewAdapter.this.mShowListener != null) {
                    AdxMediaViewAdapter.this.mShowListener.onAdProgress(currentTime, adBreakDuration);
                }
            }
        });
        this.tpInnerMediaVideo.loadAd();
    }

    public boolean isReady() {
        if (this.tpInnerMediaVideo != null) {
            return !this.isAdsTimeOut() && this.tpInnerMediaVideo.isReady();
        }
        return false;
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("40");
    }

    public String getNetworkVersion() {
        return "40.10.6.0.1";
    }
}

