/*
 * Decompiled with CFR 0.152.
 */
package com.tp.ads.adx;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tp.ads.adx.AdxErrorUtil;
import com.tp.ads.adx.AdxNativeAd;
import com.tp.adx.open.AdError;
import com.tp.adx.open.TPAdOptions;
import com.tp.adx.open.TPInnerAdListener;
import com.tp.adx.open.TPInnerNative;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AdxNativeAdapter
extends TPNativeAdapter {
    private static final String TAG = "AdxNative";
    private AdxNativeAd mAdxNativeAd;
    private boolean mNeedDownloadImg;
    private boolean mClickFullScreen = false;
    private boolean mProvicyIcon = true;
    private boolean isVideoMute = true;
    private TPInnerNative tpInnerNative;

    public void clean() {
        if (this.tpInnerNative != null) {
            this.tpInnerNative.onDestroy();
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("40");
    }

    public String getNetworkVersion() {
        return "40.10.6.0.1";
    }

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        String provicy_icon;
        String click_fullscreen;
        String downLoadImg;
        String videoMute;
        String placementId = tpParams.get("placementId");
        String payload = tpParams.get("ADX-Payload");
        String startTimeStr = tpParams.get("ADX-Payload_Start_time");
        if (tpParams.containsKey("video_mute") && !TextUtils.isEmpty((CharSequence)(videoMute = tpParams.get("video_mute"))) && !videoMute.equals("1")) {
            this.isVideoMute = false;
            Log.i((String)TAG, (String)("videoMute: " + this.isVideoMute));
        }
        Log.v((String)TAG, (String)("loadCustomAd placementId:" + placementId));
        if (placementId == null || placementId.length() <= 0 || payload == null || payload.length() <= 0) {
            TPError tpError = new TPError();
            tpError.setTpErrorCode("Native Network or Custom Event adapter was configured incorrectly.");
            this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            return;
        }
        if (userParams.containsKey("need_down_load_img") && (downLoadImg = (String)userParams.get("need_down_load_img")).equals("true")) {
            this.mNeedDownloadImg = true;
        }
        if (userParams.containsKey("ad_click_fullscreen") && (click_fullscreen = (String)userParams.get("ad_click_fullscreen")).equals("1")) {
            this.mClickFullScreen = true;
        }
        if (userParams.containsKey("adx_provicy_icon") && (provicy_icon = (String)userParams.get("adx_provicy_icon")).equals("1")) {
            this.mProvicyIcon = false;
        }
        long startTime = 0L;
        try {
            startTime = startTimeStr == null ? 0L : Long.parseLong(startTimeStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tpInnerNative = new TPInnerNative(placementId, payload);
        this.tpInnerNative.setAdOptions(new TPAdOptions.Builder().setPayloadStartTime(startTime).setMute(this.isVideoMute).build());
        this.tpInnerNative.setAdListener(new TPInnerAdListener(){

            @Override
            public void onAdLoaded() {
                Log.v((String)AdxNativeAdapter.TAG, (String)"onAdLoaded");
                if (AdxNativeAdapter.this.mLoadAdapterListener != null) {
                    AdxNativeAdapter.this.mAdxNativeAd = new AdxNativeAd(GlobalTradPlus.getInstance().getContext(), AdxNativeAdapter.this.tpInnerNative, AdxNativeAdapter.this.tpInnerNative.getInnerNativeAd(), AdxNativeAdapter.this.mClickFullScreen, AdxNativeAdapter.this.mProvicyIcon);
                    AdxNativeAdapter.this.downloadAndCallback(AdxNativeAdapter.this.mAdxNativeAd, AdxNativeAdapter.this.mNeedDownloadImg);
                }
            }

            @Override
            public void onAdImpression() {
                Log.v((String)AdxNativeAdapter.TAG, (String)"onAdImpression");
                if (AdxNativeAdapter.this.mAdxNativeAd != null) {
                    AdxNativeAdapter.this.mAdxNativeAd.adShown();
                }
            }

            @Override
            public void onAdLoadFailed(AdError error) {
                Log.v((String)AdxNativeAdapter.TAG, (String)("onAdLoadFailed error:" + error.getErrorCode() + " msg:" + error.getErrorMsg()));
                if (AdxNativeAdapter.this.mLoadAdapterListener != null) {
                    AdxNativeAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(AdxErrorUtil.getTradPlusErrorCode(error));
                }
            }

            @Override
            public void onAdClicked() {
                if (AdxNativeAdapter.this.mAdxNativeAd != null) {
                    AdxNativeAdapter.this.mAdxNativeAd.adClicked();
                }
            }

            @Override
            public void onVideoStart() {
                if (AdxNativeAdapter.this.mAdxNativeAd != null) {
                    AdxNativeAdapter.this.mAdxNativeAd.adVideoStart();
                }
            }

            @Override
            public void onVideoEnd() {
                if (AdxNativeAdapter.this.mAdxNativeAd != null) {
                    AdxNativeAdapter.this.mAdxNativeAd.adVideoEnd();
                }
            }

            @Override
            public void onAdClosed() {
                if (AdxNativeAdapter.this.mAdxNativeAd != null) {
                    AdxNativeAdapter.this.mAdxNativeAd.adClosed();
                }
            }
        });
        this.tpInnerNative.loadAd();
    }
}

